/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

public class InterceptorRegistration {
    private final HandlerInterceptor interceptor;
    private final List<String> pathPatterns = new ArrayList<String>();

    public InterceptorRegistration(HandlerInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"Interceptor is required");
        this.interceptor = interceptor;
    }

    public void addPathPatterns(String ... pathPatterns) {
        this.pathPatterns.addAll((Collection<String>)Arrays.asList(pathPatterns));
    }

    protected Object getInterceptor() {
        if (this.pathPatterns.isEmpty()) {
            return this.interceptor;
        }
        return new MappedInterceptor(this.pathPatterns.toArray(new String[this.pathPatterns.size()]), this.interceptor);
    }
}

