export interface Rules {
    trigger: string;
    enum: string;
    len?: number;
    max?: number;
    message: string;
    min?: number;
    pattern: string;
    required: boolean;
    type: string;
}
export interface WidgetForm {
    list: any[];
    config: {
        size: '' | 'default' | 'small' | 'large';
        hideRequiredAsterisk: boolean;
        labelWidth: number;
        labelPosition: 'top' | 'right' | 'left';
    };
}
export declare const getWidgetForm: () => WidgetForm;
export declare const basicComponents: ({
    label: string;
    type: "input";
    options: {
        width: string;
        defaultValue: string;
        placeholder: string;
        maxlength: null;
        prefix: string;
        suffix: string;
        prepend: string;
        append: string;
        disabled: boolean;
        clearable: boolean;
        readonly: boolean;
        rules: Rules;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "password";
    options: {
        width: string;
        defaultValue: string;
        placeholder: string;
        maxlength: null;
        prefix: string;
        suffix: string;
        prepend: string;
        append: string;
        showPassword: boolean;
        disabled: boolean;
        clearable: boolean;
        readonly: boolean;
        rules: Rules;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "textarea";
    options: {
        width: string;
        defaultValue: string;
        placeholder: string;
        maxlength: null;
        rows: number;
        autosize: boolean;
        showWordLimit: boolean;
        disabled: boolean;
        clearable: boolean;
        readonly: boolean;
        rules: Rules;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        showPassword?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "number";
    options: {
        width: string;
        defaultValue: number;
        min: number;
        max: number;
        step: number;
        disabled: boolean;
        rules: Rules;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "radio";
    options: {
        defaultValue: string;
        width: string;
        inline: boolean;
        remote: boolean;
        showLabel: boolean;
        remoteFunc: string;
        options: {
            value: string;
            label: string;
        }[];
        remoteOptions: never[];
        props: {
            value: string;
            label: string;
        };
        disabled: boolean;
        rules: Rules;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "checkbox";
    options: {
        defaultValue: never[];
        width: string;
        inline: boolean;
        remote: boolean;
        showLabel: boolean;
        remoteFunc: string;
        options: {
            label: string;
            value: string;
        }[];
        remoteOptions: never[];
        props: {
            value: string;
            label: string;
        };
        disabled: boolean;
        rules: Rules;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "time";
    options: {
        defaultValue: string;
        width: string;
        placeholder: string;
        format: string;
        valueFormat: string;
        readonly: boolean;
        editable: boolean;
        clearable: boolean;
        disabled: boolean;
        rules: Rules;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "date";
    options: {
        defaultValue: string;
        width: string;
        placeholder: string;
        format: string;
        readonly: boolean;
        editable: boolean;
        clearable: boolean;
        disabled: boolean;
        rules: Rules;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        valueFormat?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "rate";
    options: {
        defaultValue: number;
        max: number;
        allowHalf: boolean;
        disabled: boolean;
        rules: Rules;
        width?: undefined;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "select";
    options: {
        defaultValue: string;
        width: string;
        multiple: boolean;
        placeholder: string;
        remote: boolean;
        showLabel: boolean;
        filterable: boolean;
        clearable: boolean;
        disabled: boolean;
        props: {
            label: string;
            value: string;
        };
        options: {
            label: string;
            value: string;
        }[];
        remoteOptions: never[];
        remoteFunc: string;
        rules: Rules;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "switch";
    options: {
        defaultValue: boolean;
        disabled: boolean;
        activeText: string;
        inactiveText: string;
        rules: Rules;
        width?: undefined;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        range?: undefined;
    };
} | {
    label: string;
    type: "slider";
    options: {
        defaultValue: number;
        width: string;
        min: number;
        max: number;
        step: number;
        disabled: boolean;
        range: boolean;
        rules: Rules;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
    };
} | {
    label: string;
    type: "text";
    options: {
        defaultValue: string;
        width?: undefined;
        placeholder?: undefined;
        maxlength?: undefined;
        prefix?: undefined;
        suffix?: undefined;
        prepend?: undefined;
        append?: undefined;
        disabled?: undefined;
        clearable?: undefined;
        readonly?: undefined;
        rules?: undefined;
        showPassword?: undefined;
        rows?: undefined;
        autosize?: undefined;
        showWordLimit?: undefined;
        min?: undefined;
        max?: undefined;
        step?: undefined;
        inline?: undefined;
        remote?: undefined;
        showLabel?: undefined;
        remoteFunc?: undefined;
        options?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        format?: undefined;
        valueFormat?: undefined;
        editable?: undefined;
        allowHalf?: undefined;
        multiple?: undefined;
        filterable?: undefined;
        activeText?: undefined;
        inactiveText?: undefined;
        range?: undefined;
    };
})[];
export declare const basicFields: ("number" | "input" | "select" | "textarea" | "time" | "switch" | "text" | "password" | "radio" | "checkbox" | "date" | "rate" | "slider")[];
export declare const advanceComponents: ({
    label: string;
    type: "img-upload";
    options: {
        defaultValue: never[];
        name: string;
        action: string;
        method: string;
        listType: string;
        accept: string;
        limit: number;
        multiple: boolean;
        disabled: boolean;
        rules: Rules;
        width?: undefined;
        placeholder?: undefined;
        clearable?: undefined;
        filterable?: undefined;
        remote?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        remoteFunc?: undefined;
    };
    labelWidth?: undefined;
} | {
    label: string;
    type: "download";
    labelWidth: string;
    options: {
        defaultValue: string;
        name: string;
        action?: undefined;
        method?: undefined;
        listType?: undefined;
        accept?: undefined;
        limit?: undefined;
        multiple?: undefined;
        disabled?: undefined;
        rules?: undefined;
        width?: undefined;
        placeholder?: undefined;
        clearable?: undefined;
        filterable?: undefined;
        remote?: undefined;
        remoteOptions?: undefined;
        props?: undefined;
        remoteFunc?: undefined;
    };
} | {
    label: string;
    type: "cascader";
    options: {
        defaultValue: never[];
        width: string;
        placeholder: string;
        disabled: boolean;
        clearable: boolean;
        filterable: boolean;
        remote: boolean;
        remoteOptions: never[];
        props: {
            label: string;
            value: string;
            children: string;
        };
        remoteFunc: string;
        rules: Rules;
        name?: undefined;
        action?: undefined;
        method?: undefined;
        listType?: undefined;
        accept?: undefined;
        limit?: undefined;
        multiple?: undefined;
    };
    labelWidth?: undefined;
})[];
export declare const advanceFields: ("img-upload" | "download" | "cascader")[];
export declare const layoutComponents: ({
    label: string;
    type: string;
    columns: {
        span: number;
        list: never[];
    }[];
    options: {
        gutter: number;
        align: string;
        defaultValue?: undefined;
        disabled?: undefined;
        size?: undefined;
    };
} | {
    label: string;
    type: string;
    columns: {
        label: string;
        prop: string;
    }[];
    options: {
        defaultValue: never[];
        disabled: boolean;
        size: string;
        align: string;
        gutter?: undefined;
    };
} | {
    label: string;
    type: string;
    options: {
        gutter?: undefined;
        align?: undefined;
        defaultValue?: undefined;
        disabled?: undefined;
        size?: undefined;
    };
    columns?: undefined;
})[];
export declare const layoutFields: string[];
