/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageConverterMethodProcessor
extends AbstractMessageConverterMethodArgumentResolver
implements HandlerMethodReturnValueHandler {
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        this.writeWithMessageConverters(returnValue, returnType, inputMessage, outputMessage);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
        Class<?> returnValueClass = returnValue.getClass();
        List<MediaType> acceptableMediaTypes = this.getAcceptableMediaTypes((HttpInputMessage)inputMessage);
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(inputMessage.getServletRequest(), returnValueClass);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType a : acceptableMediaTypes) {
            for (MediaType p : producibleMediaTypes) {
                if (!a.isCompatibleWith(p)) continue;
                compatibleMediaTypes.add(this.getMostSpecificMediaType(a, p));
            }
        }
        if (compatibleMediaTypes.isEmpty()) {
            throw new HttpMediaTypeNotAcceptableException(this.allSupportedMediaTypes);
        }
        ArrayList mediaTypes = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificity(mediaTypes);
        MediaType selectedMediaType = null;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.isConcrete()) {
                selectedMediaType = mediaType;
                break;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION)) continue;
            selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selectedMediaType != null) {
            for (HttpMessageConverter messageConverter : this.messageConverters) {
                if (!messageConverter.canWrite(returnValueClass, selectedMediaType)) continue;
                messageConverter.write(returnValue, selectedMediaType, (HttpOutputMessage)outputMessage);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Written [" + returnValue + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]"));
                }
                return;
            }
        }
        throw new HttpMediaTypeNotAcceptableException(this.allSupportedMediaTypes);
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> returnValueClass) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        if (!this.allSupportedMediaTypes.isEmpty()) {
            ArrayList<MediaType> result = new ArrayList<MediaType>();
            for (HttpMessageConverter converter : this.messageConverters) {
                if (!converter.canWrite(returnValueClass, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
            }
            return result;
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private List<MediaType> getAcceptableMediaTypes(HttpInputMessage inputMessage) {
        List<MediaType> result = inputMessage.getHeaders().getAccept();
        return result.isEmpty() ? Collections.singletonList(MediaType.ALL) : result;
    }

    private MediaType getMostSpecificMediaType(MediaType type1, MediaType type2) {
        MediaType t2;
        double quality = type1.getQualityValue();
        Map<String, String> params = Collections.singletonMap("q", String.valueOf(quality));
        MediaType t1 = new MediaType(type1, params);
        return MediaType.SPECIFICITY_COMPARATOR.compare(t1, t2 = new MediaType(type2, params)) <= 0 ? type1 : type2;
    }
}

