/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.endpoint;

import com.taobao.api.internal.toplink.LinkException;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ChannelSender;
import com.taobao.api.internal.toplink.channel.ClientChannel;
import com.taobao.api.internal.toplink.channel.ServerChannelSender;
import com.taobao.api.internal.toplink.endpoint.ChannelSenderWrapper;
import com.taobao.api.internal.toplink.endpoint.ClientChannelWrapper;
import com.taobao.api.internal.toplink.endpoint.Endpoint;
import com.taobao.api.internal.toplink.endpoint.Identity;
import com.taobao.api.internal.toplink.endpoint.Message;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointProxy {
    private Identity identity;
    private String token;
    private List<ChannelSenderWrapper> senders = new ArrayList<ChannelSenderWrapper>();
    private Map<String, ClientChannelWrapper> clientChannels = new HashMap<String, ClientChannelWrapper>();
    private Random random = new Random();
    private Endpoint endpoint;

    protected EndpointProxy(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    protected void setIdentity(Identity identity) {
        this.identity = identity;
    }

    protected void setToken(String token) {
        this.token = token;
    }

    protected String getToken() {
        return this.token;
    }

    protected synchronized void add(ChannelSenderWrapper sender) {
        this.senders.add(sender);
        if (sender instanceof ClientChannelWrapper) {
            ClientChannelWrapper channel = (ClientChannelWrapper)sender;
            this.clientChannels.put(channel.getUri().toString(), channel);
        }
    }

    protected synchronized void remove(ChannelSender sender) {
        this.senders.remove(sender);
        if (sender instanceof ClientChannelWrapper) {
            ClientChannelWrapper channel = (ClientChannelWrapper)sender;
            this.clientChannels.remove(channel.getUri().toString());
        }
    }

    protected synchronized void remove(URI uri) {
        ClientChannel channel = this.clientChannels.remove(uri.toString());
        if (channel != null) {
            this.senders.remove(channel);
        }
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public boolean hasValidSender() {
        for (ChannelSenderWrapper sender : this.senders) {
            if ((!(sender instanceof ServerChannelSender) || !((ServerChannelSender)((Object)sender)).isOpen()) && (!(sender instanceof ClientChannel) || !((ClientChannel)((Object)sender)).isConnected())) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> sendAndWait(Map<String, Object> message) throws LinkException {
        return this.sendAndWait(message, Endpoint.TIMOUT);
    }

    public Map<String, Object> sendAndWait(Map<String, Object> message, int timeout) throws LinkException {
        return this.sendAndWait(null, message, timeout);
    }

    public Map<String, Object> sendAndWait(ChannelSenderWrapper sender, Map<String, Object> message, int timeout) throws LinkException {
        ChannelSenderWrapper senderWrapper = this.getSenders(sender);
        return this.endpoint.sendAndWait(this, senderWrapper, this.createMessage(message, senderWrapper), timeout);
    }

    public void send(Map<String, Object> message) throws ChannelException {
        this.send(null, message);
    }

    public void send(ChannelSenderWrapper sender, Map<String, Object> message) throws ChannelException {
        ChannelSenderWrapper senderWrapper = this.getSenders(sender);
        this.endpoint.send(senderWrapper, this.createMessage(message, senderWrapper));
    }

    private Message createMessage(Map<String, Object> message, ChannelSenderWrapper senderWrapper) {
        Message msg = new Message();
        msg.protocolVersion = senderWrapper.getProtocolVersion();
        msg.messageType = (short)2;
        msg.content = message;
        msg.token = this.token;
        return msg;
    }

    private ChannelSenderWrapper getSenders(ChannelSenderWrapper sender) throws ChannelException {
        if (this.senders.isEmpty()) {
            throw new ChannelException(Text.E_NO_SENDER);
        }
        if (this.senders.contains(sender)) {
            return sender;
        }
        return this.senders.get(this.random.nextInt(this.senders.size()));
    }
}

