/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.util.ResourceUtils;

public abstract class AbstractResource
implements Resource {
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException iOException) {
            try {
                InputStream is = this.getInputStream();
                is.close();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        throw new FileNotFoundException(String.valueOf(this.getDescription()) + " cannot be resolved to URL");
    }

    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI(url);
        }
        catch (URISyntaxException ex) {
            throw new NestedIOException("Invalid URI [" + url + "]", ex);
        }
    }

    public File getFile() throws IOException {
        throw new FileNotFoundException(String.valueOf(this.getDescription()) + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        long l;
        InputStream is = this.getInputStream();
        try {
            long size = 0L;
            byte[] buf = new byte[255];
            int read = is.read(buf);
            while (read != -1) {
                size += (long)read;
            }
            l = size;
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
        return l;
    }

    public long lastModified() throws IOException {
        long lastModified = this.getFileForLastModifiedCheck().lastModified();
        if (lastModified == 0L) {
            throw new FileNotFoundException(String.valueOf(this.getDescription()) + " cannot be resolved in the file system for resolving its last-modified timestamp");
        }
        return lastModified;
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    public String getFilename() throws IllegalStateException {
        return null;
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Resource && ((Resource)obj).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }
}

