/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.multi.qrcode.detector.MultiDetector;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class QRCodeMultiReader
extends QRCodeReader
implements MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];

    @Override
    public Result[] decodeMultiple(BinaryBitmap image) throws NotFoundException {
        return this.decodeMultiple(image, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        DetectorResult[] detectorResults;
        ArrayList<Result> results = new ArrayList<Result>();
        DetectorResult[] detectorResultArray = detectorResults = new MultiDetector(image.getBlackMatrix()).detectMulti(hints);
        int n = detectorResults.length;
        int n2 = 0;
        while (n2 < n) {
            DetectorResult detectorResult = detectorResultArray[n2];
            try {
                String ecLevel;
                DecoderResult decoderResult = this.getDecoder().decode(detectorResult.getBits(), hints);
                ResultPoint[] points = detectorResult.getPoints();
                Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.QR_CODE);
                List<byte[]> byteSegments = decoderResult.getByteSegments();
                if (byteSegments != null) {
                    result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
                }
                if ((ecLevel = decoderResult.getECLevel()) != null) {
                    result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
                }
                results.add(result);
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
            ++n2;
        }
        if (results.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        return results.toArray(new Result[results.size()]);
    }
}

