/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.Collection;
import java.util.Map;
import org.springframework.ui.ModelMap;
import org.springframework.validation.DataBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedirectAttributesModelMap
extends ModelMap
implements RedirectAttributes {
    private final DataBinder dataBinder;
    private final ModelMap flashAttributes = new ModelMap();

    public RedirectAttributesModelMap(DataBinder dataBinder) {
        this.dataBinder = dataBinder;
    }

    public RedirectAttributesModelMap() {
        this(null);
    }

    @Override
    public Map<String, ?> getFlashAttributes() {
        return this.flashAttributes;
    }

    @Override
    public RedirectAttributesModelMap addAttribute(String attributeName, Object attributeValue) {
        super.addAttribute(attributeName, (Object)this.formatValue(attributeValue));
        return this;
    }

    private String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        return this.dataBinder != null ? (String)this.dataBinder.convertIfNecessary(value, String.class) : value.toString();
    }

    @Override
    public RedirectAttributesModelMap addAttribute(Object attributeValue) {
        super.addAttribute(attributeValue);
        return this;
    }

    @Override
    public RedirectAttributesModelMap addAllAttributes(Collection<?> attributeValues) {
        super.addAllAttributes(attributeValues);
        return this;
    }

    public RedirectAttributesModelMap addAllAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.addAttribute(key, attributes.get(key));
            }
        }
        return this;
    }

    @Override
    public RedirectAttributesModelMap mergeAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                if (this.containsKey(key)) continue;
                this.addAttribute(key, attributes.get(key));
            }
        }
        return this;
    }

    public Map<String, Object> asMap() {
        return this;
    }

    public Object put(String key, Object value) {
        return super.put((Object)key, (Object)this.formatValue(value));
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                this.put(string, (Object)this.formatValue(map.get(string)));
            }
        }
    }

    @Override
    public RedirectAttributes addFlashAttribute(String attributeName, Object attributeValue) {
        this.flashAttributes.addAttribute(attributeName, attributeValue);
        return this;
    }

    @Override
    public RedirectAttributes addFlashAttribute(Object attributeValue) {
        this.flashAttributes.addAttribute(attributeValue);
        return this;
    }
}

