/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.converter.xml.XmlAwareFormHttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.servlet.config.MvcNamespaceUtils;
import org.springframework.web.servlet.handler.ConversionServiceExposingInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ServletWebArgumentResolverAdapter;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    private static final boolean jsr303Present = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader()) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent((String)"com.sun.syndication.feed.WireFeed", (ClassLoader)AnnotationDrivenBeanDefinitionParser.class.getClassLoader());

    AnnotationDrivenBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), source);
        parserContext.pushContainingComponent(compDefinition);
        RootBeanDefinition methodMappingDef = new RootBeanDefinition(RequestMappingHandlerMapping.class);
        methodMappingDef.setSource(source);
        methodMappingDef.setRole(2);
        methodMappingDef.getPropertyValues().add("order", (Object)0);
        String methodMappingName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)methodMappingDef);
        RuntimeBeanReference conversionService = this.getConversionService(element, source, parserContext);
        RuntimeBeanReference validator = this.getValidator(element, source, parserContext);
        RuntimeBeanReference messageCodesResolver = this.getMessageCodesResolver(element, source, parserContext);
        RootBeanDefinition bindingDef = new RootBeanDefinition(ConfigurableWebBindingInitializer.class);
        bindingDef.setSource(source);
        bindingDef.setRole(2);
        bindingDef.getPropertyValues().add("conversionService", (Object)conversionService);
        bindingDef.getPropertyValues().add("validator", (Object)validator);
        bindingDef.getPropertyValues().add("messageCodesResolver", (Object)messageCodesResolver);
        ManagedList<?> messageConverters = this.getMessageConverters(element, source, parserContext);
        ManagedList<?> argumentResolvers = this.getArgumentResolvers(element, source, parserContext);
        ManagedList<?> returnValueHandlers = this.getReturnValueHandlers(element, source, parserContext);
        RootBeanDefinition methodAdapterDef = new RootBeanDefinition(RequestMappingHandlerAdapter.class);
        methodAdapterDef.setSource(source);
        methodAdapterDef.setRole(2);
        methodAdapterDef.getPropertyValues().add("webBindingInitializer", (Object)bindingDef);
        methodAdapterDef.getPropertyValues().add("messageConverters", messageConverters);
        if (element.hasAttribute("ignoreDefaultModelOnRedirect")) {
            Boolean ignoreDefaultModel = Boolean.valueOf(element.getAttribute("ignoreDefaultModelOnRedirect"));
            methodAdapterDef.getPropertyValues().add("ignoreDefaultModelOnRedirect", (Object)ignoreDefaultModel);
        }
        if (argumentResolvers != null) {
            methodAdapterDef.getPropertyValues().add("customArgumentResolvers", argumentResolvers);
        }
        if (returnValueHandlers != null) {
            methodAdapterDef.getPropertyValues().add("customReturnValueHandlers", returnValueHandlers);
        }
        String methodAdapterName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)methodAdapterDef);
        RootBeanDefinition csInterceptorDef = new RootBeanDefinition(ConversionServiceExposingInterceptor.class);
        csInterceptorDef.setSource(source);
        csInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)conversionService);
        RootBeanDefinition mappedCsInterceptorDef = new RootBeanDefinition(MappedInterceptor.class);
        mappedCsInterceptorDef.setSource(source);
        mappedCsInterceptorDef.setRole(2);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(0, null);
        mappedCsInterceptorDef.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)csInterceptorDef);
        String mappedInterceptorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)mappedCsInterceptorDef);
        RootBeanDefinition methodExceptionResolver = new RootBeanDefinition(ExceptionHandlerExceptionResolver.class);
        methodExceptionResolver.setSource(source);
        methodExceptionResolver.setRole(2);
        methodExceptionResolver.getPropertyValues().add("messageConverters", messageConverters);
        methodExceptionResolver.getPropertyValues().add("order", (Object)0);
        String methodExceptionResolverName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)methodExceptionResolver);
        RootBeanDefinition responseStatusExceptionResolver = new RootBeanDefinition(ResponseStatusExceptionResolver.class);
        responseStatusExceptionResolver.setSource(source);
        responseStatusExceptionResolver.setRole(2);
        responseStatusExceptionResolver.getPropertyValues().add("order", (Object)1);
        String responseStatusExceptionResolverName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)responseStatusExceptionResolver);
        RootBeanDefinition defaultExceptionResolver = new RootBeanDefinition(DefaultHandlerExceptionResolver.class);
        defaultExceptionResolver.setSource(source);
        defaultExceptionResolver.setRole(2);
        defaultExceptionResolver.getPropertyValues().add("order", (Object)2);
        String defaultExceptionResolverName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)defaultExceptionResolver);
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)methodMappingDef, methodMappingName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)methodAdapterDef, methodAdapterName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)methodExceptionResolver, methodExceptionResolverName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)responseStatusExceptionResolver, responseStatusExceptionResolverName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)defaultExceptionResolver, defaultExceptionResolverName));
        parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)mappedCsInterceptorDef, mappedInterceptorName));
        MvcNamespaceUtils.registerDefaultComponents(parserContext, source);
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    private RuntimeBeanReference getConversionService(Element element, Object source, ParserContext parserContext) {
        RuntimeBeanReference conversionServiceRef;
        if (element.hasAttribute("conversion-service")) {
            conversionServiceRef = new RuntimeBeanReference(element.getAttribute("conversion-service"));
        } else {
            RootBeanDefinition conversionDef = new RootBeanDefinition(FormattingConversionServiceFactoryBean.class);
            conversionDef.setSource(source);
            conversionDef.setRole(2);
            String conversionName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)conversionDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)conversionDef, conversionName));
            conversionServiceRef = new RuntimeBeanReference(conversionName);
        }
        return conversionServiceRef;
    }

    private RuntimeBeanReference getValidator(Element element, Object source, ParserContext parserContext) {
        if (element.hasAttribute("validator")) {
            return new RuntimeBeanReference(element.getAttribute("validator"));
        }
        if (jsr303Present) {
            RootBeanDefinition validatorDef = new RootBeanDefinition(LocalValidatorFactoryBean.class);
            validatorDef.setSource(source);
            validatorDef.setRole(2);
            String validatorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)validatorDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)validatorDef, validatorName));
            return new RuntimeBeanReference(validatorName);
        }
        return null;
    }

    private RuntimeBeanReference getMessageCodesResolver(Element element, Object source, ParserContext parserContext) {
        if (element.hasAttribute("message-codes-resolver")) {
            return new RuntimeBeanReference(element.getAttribute("message-codes-resolver"));
        }
        return null;
    }

    private ManagedList<?> getArgumentResolvers(Element element, Object source, ParserContext parserContext) {
        Element resolversElement = DomUtils.getChildElementByTagName((Element)element, (String)"argument-resolvers");
        if (resolversElement != null) {
            ManagedList<BeanDefinitionHolder> argumentResolvers = this.extractBeanSubElements(resolversElement, parserContext);
            return this.wrapWebArgumentResolverBeanDefs((List<BeanDefinitionHolder>)argumentResolvers);
        }
        return null;
    }

    private ManagedList<?> getReturnValueHandlers(Element element, Object source, ParserContext parserContext) {
        Element handlersElement = DomUtils.getChildElementByTagName((Element)element, (String)"return-value-handlers");
        if (handlersElement != null) {
            return this.extractBeanSubElements(handlersElement, parserContext);
        }
        return null;
    }

    private ManagedList<?> getMessageConverters(Element element, Object source, ParserContext parserContext) {
        Element convertersElement = DomUtils.getChildElementByTagName((Element)element, (String)"message-converters");
        ManagedList messageConverters = new ManagedList();
        if (convertersElement != null) {
            messageConverters.setSource(source);
            for (Element converter : DomUtils.getChildElementsByTagName((Element)convertersElement, (String)"bean")) {
                BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(converter);
                beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(converter, beanDef);
                messageConverters.add((Object)beanDef);
            }
        }
        if (convertersElement == null || Boolean.valueOf(convertersElement.getAttribute("register-defaults")).booleanValue()) {
            messageConverters.setSource(source);
            messageConverters.add((Object)this.createConverterBeanDefinition(ByteArrayHttpMessageConverter.class, source));
            RootBeanDefinition stringConverterDef = this.createConverterBeanDefinition(StringHttpMessageConverter.class, source);
            stringConverterDef.getPropertyValues().add("writeAcceptCharset", (Object)false);
            messageConverters.add((Object)stringConverterDef);
            messageConverters.add((Object)this.createConverterBeanDefinition(ResourceHttpMessageConverter.class, source));
            messageConverters.add((Object)this.createConverterBeanDefinition(SourceHttpMessageConverter.class, source));
            messageConverters.add((Object)this.createConverterBeanDefinition(XmlAwareFormHttpMessageConverter.class, source));
            if (jaxb2Present) {
                messageConverters.add((Object)this.createConverterBeanDefinition(Jaxb2RootElementHttpMessageConverter.class, source));
            }
            if (jacksonPresent) {
                messageConverters.add((Object)this.createConverterBeanDefinition(MappingJacksonHttpMessageConverter.class, source));
            }
            if (romePresent) {
                messageConverters.add((Object)this.createConverterBeanDefinition(AtomFeedHttpMessageConverter.class, source));
                messageConverters.add((Object)this.createConverterBeanDefinition(RssChannelHttpMessageConverter.class, source));
            }
        }
        return messageConverters;
    }

    private RootBeanDefinition createConverterBeanDefinition(Class<? extends HttpMessageConverter> converterClass, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(converterClass);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }

    private ManagedList<BeanDefinitionHolder> extractBeanSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.extractSource((Object)parentElement));
        for (Element beanElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String)"bean")) {
            BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDef);
            list.add((Object)beanDef);
        }
        return list;
    }

    private ManagedList<BeanDefinitionHolder> wrapWebArgumentResolverBeanDefs(List<BeanDefinitionHolder> beanDefs) {
        ManagedList result = new ManagedList();
        for (BeanDefinitionHolder beanDef : beanDefs) {
            String className = beanDef.getBeanDefinition().getBeanClassName();
            Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
            if (WebArgumentResolver.class.isAssignableFrom(clazz)) {
                RootBeanDefinition adapter = new RootBeanDefinition(ServletWebArgumentResolverAdapter.class);
                adapter.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)beanDef);
                result.add((Object)new BeanDefinitionHolder((BeanDefinition)adapter, String.valueOf(beanDef.getBeanName()) + "Adapter"));
                continue;
            }
            result.add((Object)beanDef);
        }
        return result;
    }
}

