/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingDataSource
implements DataSource,
InitializingBean {
    private DataSource targetDataSource;

    public DelegatingDataSource() {
    }

    public DelegatingDataSource(DataSource targetDataSource) {
        this.setTargetDataSource(targetDataSource);
    }

    public void setTargetDataSource(DataSource targetDataSource) {
        Assert.notNull((Object)targetDataSource, (String)"'targetDataSource' must not be null");
        this.targetDataSource = targetDataSource;
    }

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    public void afterPropertiesSet() {
        if (this.getTargetDataSource() == null) {
            throw new IllegalArgumentException("Property 'targetDataSource' is required");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getTargetDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getTargetDataSource().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getTargetDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getTargetDataSource().setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getTargetDataSource().getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getTargetDataSource().setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getTargetDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getTargetDataSource().isWrapperFor(iface);
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }
}

