/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class JBossModulesAdapter
implements JBossClassLoaderAdapter {
    private static final String TRANSFORMER_FIELD_NAME = "transformer";
    private static final String TRANSFORMER_ADD_METHOD_NAME = "addTransformer";
    private static final String DELEGATING_TRANSFORMER_CLASS_NAME = "org.jboss.as.server.deployment.module.DelegatingClassFileTransformer";
    private final ClassLoader classLoader;
    private final Method addTransformer;
    private final Object delegatingTransformer;

    public JBossModulesAdapter(ClassLoader loader) {
        this.classLoader = loader;
        try {
            Field transformers = ReflectionUtils.findField(this.classLoader.getClass(), (String)TRANSFORMER_FIELD_NAME);
            transformers.setAccessible(true);
            this.delegatingTransformer = transformers.get(this.classLoader);
            Assert.state((boolean)this.delegatingTransformer.getClass().getName().equals(DELEGATING_TRANSFORMER_CLASS_NAME), (String)("Transformer not of the expected type: " + this.delegatingTransformer.getClass().getName()));
            this.addTransformer = ReflectionUtils.findMethod(this.delegatingTransformer.getClass(), (String)TRANSFORMER_ADD_METHOD_NAME, (Class[])new Class[]{ClassFileTransformer.class});
            this.addTransformer.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize JBoss 7 LoadTimeWeaver", ex);
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        try {
            this.addTransformer.invoke(this.delegatingTransformer, transformer);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not add transformer on JBoss 7 classloader " + this.classLoader, ex);
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }
}

