/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.logging.jdbc.ResultSetLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public final class PreparedStatementLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(PreparedStatement.class);
    private PreparedStatement statement;

    private PreparedStatementLogger(PreparedStatement stmt, Log statementLog) {
        super(statementLog);
        this.statement = stmt;
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug("==> Parameters: " + this.getParameterValueString());
                }
                this.clearColumnInfo();
                if ("executeQuery".equals(method.getName())) {
                    ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                    if (rs != null) {
                        return ResultSetLogger.newInstance(rs, this.getStatementLog());
                    }
                    return null;
                }
                return method.invoke((Object)this.statement, params);
            }
            if (SET_METHODS.contains(method.getName())) {
                if ("setNull".equals(method.getName())) {
                    this.setColumn(params[0], null);
                } else {
                    this.setColumn(params[0], params[1]);
                }
                return method.invoke((Object)this.statement, params);
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogger.newInstance(rs, this.getStatementLog());
                }
                return null;
            }
            if ("equals".equals(method.getName())) {
                Object ps = params[0];
                return ps instanceof Proxy && proxy == ps;
            }
            if ("hashCode".equals(method.getName())) {
                return proxy.hashCode();
            }
            return method.invoke((Object)this.statement, params);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    public static PreparedStatement newInstance(PreparedStatement stmt, Log statementLog) {
        PreparedStatementLogger handler = new PreparedStatementLogger(stmt, statementLog);
        ClassLoader cl = PreparedStatement.class.getClassLoader();
        return (PreparedStatement)Proxy.newProxyInstance(cl, new Class[]{PreparedStatement.class, CallableStatement.class}, (InvocationHandler)handler);
    }

    public PreparedStatement getPreparedStatement() {
        return this.statement;
    }

    protected Log getLog() {
        return log;
    }
}

