/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.executor.loader.SerialStateHolder;
import org.apache.ibatis.executor.loader.WriteReplaceInterface;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.property.PropertyCopier;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.ibatis.session.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultObjectProxy {
    private static final Log log = LogFactory.getLog(ResultObjectProxy.class);
    private static final String FINALIZE_METHOD = "finalize";
    private static final String WRITE_REPLACE_METHOD = "writeReplace";

    private ResultObjectProxy() {
    }

    public static Object createProxy(Object target, ResultLoaderMap lazyLoader, Configuration configuration, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        return EnhancedResultObjectProxyImpl.createProxy(target, lazyLoader, configuration, objectFactory, constructorArgTypes, constructorArgs);
    }

    public static Object createDeserializationProxy(Object target, Set<String> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        return EnhancedDeserializationProxyImpl.createProxy(target, unloadedProperties, objectFactory, constructorArgTypes, constructorArgs);
    }

    private static Object crateProxy(Class<?> type, Callback callback, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        Enhancer enhancer = new Enhancer();
        enhancer.setCallback(callback);
        enhancer.setSuperclass(type);
        try {
            type.getDeclaredMethod(WRITE_REPLACE_METHOD, new Class[0]);
            log.debug("writeReplace method was found on bean " + type + ", make sure it returns this");
        }
        catch (NoSuchMethodException e) {
            enhancer.setInterfaces(new Class[]{WriteReplaceInterface.class});
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Object enhanced = null;
        if (constructorArgTypes.isEmpty()) {
            enhanced = enhancer.create();
        } else {
            Class[] typesArray = constructorArgTypes.toArray(new Class[constructorArgTypes.size()]);
            Object[] valuesArray = constructorArgs.toArray(new Object[constructorArgs.size()]);
            enhanced = enhancer.create(typesArray, valuesArray);
        }
        return enhanced;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnhancedDeserializationProxyImpl
    implements MethodInterceptor {
        private Class<?> type;
        private Set<String> unloadedProperties;
        private ObjectFactory objectFactory;
        private List<Class<?>> constructorArgTypes;
        private List<Object> constructorArgs;

        private EnhancedDeserializationProxyImpl(Class<?> type, Set<String> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
            this.type = type;
            this.unloadedProperties = unloadedProperties;
            this.objectFactory = objectFactory;
            this.constructorArgTypes = constructorArgTypes;
            this.constructorArgs = constructorArgs;
        }

        public static Object createProxy(Object target, Set<String> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
            Class<?> type = target.getClass();
            EnhancedDeserializationProxyImpl callback = new EnhancedDeserializationProxyImpl(type, unloadedProperties, objectFactory, constructorArgTypes, constructorArgs);
            Object enhanced = ResultObjectProxy.crateProxy(type, (Callback)callback, constructorArgTypes, constructorArgs);
            PropertyCopier.copyBeanProperties(type, target, enhanced);
            return enhanced;
        }

        public Object intercept(Object enhanced, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            String methodName = method.getName();
            try {
                String property;
                if (ResultObjectProxy.WRITE_REPLACE_METHOD.equals(methodName)) {
                    Object original = null;
                    original = this.constructorArgTypes.isEmpty() ? this.objectFactory.create(this.type) : this.objectFactory.create(this.type, this.constructorArgTypes, this.constructorArgs);
                    PropertyCopier.copyBeanProperties(this.type, enhanced, original);
                    return new SerialStateHolder(original, this.unloadedProperties, this.objectFactory, this.constructorArgTypes, this.constructorArgs);
                }
                if (!ResultObjectProxy.FINALIZE_METHOD.equals(methodName) && PropertyNamer.isProperty(methodName) && this.unloadedProperties.contains((property = PropertyNamer.methodToProperty(methodName)).toUpperCase(Locale.ENGLISH))) {
                    throw new ExecutorException("An attempt has been made to read a not loaded lazy property '" + property + "' of a disconnected object");
                }
                return methodProxy.invokeSuper(enhanced, args);
            }
            catch (Throwable t) {
                throw ExceptionUtil.unwrapThrowable(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnhancedResultObjectProxyImpl
    implements MethodInterceptor {
        private Class<?> type;
        private ResultLoaderMap lazyLoader;
        private boolean aggressive;
        private Set<String> lazyLoadTriggerMethods;
        private ObjectFactory objectFactory;
        private List<Class<?>> constructorArgTypes;
        private List<Object> constructorArgs;

        private EnhancedResultObjectProxyImpl(Class<?> type, ResultLoaderMap lazyLoader, Configuration configuration, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
            this.type = type;
            this.lazyLoader = lazyLoader;
            this.aggressive = configuration.isAggressiveLazyLoading();
            this.lazyLoadTriggerMethods = configuration.getLazyLoadTriggerMethods();
            this.objectFactory = objectFactory;
            this.constructorArgTypes = constructorArgTypes;
            this.constructorArgs = constructorArgs;
        }

        public static Object createProxy(Object target, ResultLoaderMap lazyLoader, Configuration configuration, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
            Class<?> type = target.getClass();
            EnhancedResultObjectProxyImpl callback = new EnhancedResultObjectProxyImpl(type, lazyLoader, configuration, objectFactory, constructorArgTypes, constructorArgs);
            Object enhanced = ResultObjectProxy.crateProxy(type, (Callback)callback, constructorArgTypes, constructorArgs);
            PropertyCopier.copyBeanProperties(type, target, enhanced);
            return enhanced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object enhanced, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            String methodName = method.getName();
            try {
                ResultLoaderMap resultLoaderMap = this.lazyLoader;
                synchronized (resultLoaderMap) {
                    if (ResultObjectProxy.WRITE_REPLACE_METHOD.equals(methodName)) {
                        Object original = null;
                        original = this.constructorArgTypes.isEmpty() ? this.objectFactory.create(this.type) : this.objectFactory.create(this.type, this.constructorArgTypes, this.constructorArgs);
                        PropertyCopier.copyBeanProperties(this.type, enhanced, original);
                        if (this.lazyLoader.size() > 0) {
                            return new SerialStateHolder(original, this.lazyLoader.getPropertyNames(), this.objectFactory, this.constructorArgTypes, this.constructorArgs);
                        }
                        return original;
                    }
                    if (this.lazyLoader.size() > 0 && !ResultObjectProxy.FINALIZE_METHOD.equals(methodName)) {
                        String property;
                        if (this.aggressive || this.lazyLoadTriggerMethods.contains(methodName)) {
                            this.lazyLoader.loadAll();
                        } else if (PropertyNamer.isProperty(methodName) && this.lazyLoader.hasLoader(property = PropertyNamer.methodToProperty(methodName))) {
                            this.lazyLoader.load(property);
                        }
                    }
                }
                return methodProxy.invokeSuper(enhanced, args);
            }
            catch (Throwable t) {
                throw ExceptionUtil.unwrapThrowable(t);
            }
        }
    }
}

