/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.ApiException;
import com.taobao.api.SecretException;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.util.Base64;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.XmlWriter;
import com.taobao.api.internal.util.json.JSONReader;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.util.json.JSONWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaobaoUtils {
    private static final String AES = "AES";
    private static String intranetIp;

    private TaobaoUtils() {
    }

    public static String signTopRequest(RequestParametersHolder requestHolder, String secret, String signMethod) throws IOException {
        return TaobaoUtils.signTopRequest(requestHolder.getAllParams(), null, secret, signMethod);
    }

    public static String signTopRequest(Map<String, String> params, String body, String secret, String signMethod) throws IOException {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if ("md5".equals(signMethod)) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.areNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        if (body != null) {
            query.append(body);
        }
        if ("hmac".equals(signMethod)) {
            bytes = TaobaoUtils.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = TaobaoUtils.encryptMD5(query.toString());
        }
        return TaobaoUtils.byte2hex(bytes);
    }

    public static String signTopRequestWithBody(RequestParametersHolder requestHolder, String body, String secret, String signMethod) throws IOException {
        Map<String, String> params = requestHolder.getAllParams();
        return TaobaoUtils.signTopRequest(params, body, secret, signMethod);
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    public static byte[] encryptMD5(String data) throws IOException {
        return TaobaoUtils.encryptMD5(data.getBytes("UTF-8"));
    }

    public static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException(gse.toString());
        }
        return bytes;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Object jsonToObject(String json) {
        JSONValidatingReader jr = new JSONValidatingReader();
        return ((JSONReader)jr).read(json);
    }

    public static String objectToJson(Object object) {
        JSONWriter writer = new JSONWriter(false, true);
        return writer.write(object);
    }

    public static String objectToXml(Object object) {
        XmlWriter writer = new XmlWriter();
        return writer.write(object);
    }

    public static <T extends TaobaoResponse> T parseResponse(String json, Class<T> clazz) throws ApiException {
        ObjectJsonParser<T> parser = new ObjectJsonParser<T>(clazz);
        Object rsp = parser.parse(json);
        ((TaobaoResponse)rsp).setBody(json);
        return (T)rsp;
    }

    public static String getIntranetIp() {
        if (intranetIp == null) {
            try {
                intranetIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                intranetIp = "127.0.0.1";
            }
        }
        return intranetIp;
    }

    public static String aesEncrypt(String content, byte[] encryptKey) throws SecretException {
        try {
            return TaobaoUtils.aesEncrypt(content.getBytes("UTF-8"), encryptKey);
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String aesDecrypt(String content, byte[] decryptKey) throws SecretException {
        try {
            return new String(TaobaoUtils.aesDecrypt(content.getBytes("UTF-8"), decryptKey), "UTF-8");
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static byte[] aesDecrypt(byte[] encryptBytes, byte[] decryptKey) throws SecretException {
        IvParameterSpec iv = new IvParameterSpec("0102030405060708".getBytes());
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(decryptKey, AES), iv);
            return cipher.doFinal(Base64.decode(encryptBytes));
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String aesEncrypt(byte[] content, byte[] encryptKey) throws SecretException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES);
            kgen.init(new SecureRandom(encryptKey));
            IvParameterSpec iv = new IvParameterSpec("0102030405060708".getBytes());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(encryptKey, AES), iv);
            return TaobaoUtils.base64Encode(cipher.doFinal(content));
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String base64Encode(byte[] src) {
        try {
            return TaobaoUtils.base64Encode(src, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String base64Encode(byte[] src, String charsetName) throws UnsupportedEncodingException {
        byte[] res = Base64.encodeToByte(src, false);
        return src != null ? new String(res, charsetName) : null;
    }
}

