/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.keygen;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdbc3KeyGenerator
implements KeyGenerator {
    @Override
    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    @Override
    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(parameter);
        this.processBatch(ms, stmt, parameters);
    }

    public void processBatch(MappedStatement ms, Statement stmt, List<Object> parameters) {
        block13: {
            ResultSet rs = null;
            try {
                rs = stmt.getGeneratedKeys();
                Configuration configuration = ms.getConfiguration();
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                String[] keyProperties = ms.getKeyProperties();
                ResultSetMetaData rsmd = rs.getMetaData();
                TypeHandler<?>[] typeHandlers = null;
                if (keyProperties == null || rsmd.getColumnCount() < keyProperties.length) break block13;
                for (Object parameter : parameters) {
                    if (!rs.next()) {
                        break;
                    }
                    MetaObject metaParam = configuration.newMetaObject(parameter);
                    if (typeHandlers == null) {
                        typeHandlers = this.getTypeHandlers(typeHandlerRegistry, metaParam, keyProperties);
                    }
                    this.populateKeys(rs, metaParam, keyProperties, typeHandlers);
                }
            }
            catch (Exception e) {
                throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private TypeHandler<?>[] getTypeHandlers(TypeHandlerRegistry typeHandlerRegistry, MetaObject metaParam, String[] keyProperties) {
        TypeHandler[] typeHandlers = new TypeHandler[keyProperties.length];
        for (int i = 0; i < keyProperties.length; ++i) {
            TypeHandler<?> th;
            if (!metaParam.hasSetter(keyProperties[i])) continue;
            Class<?> keyPropertyType = metaParam.getSetterType(keyProperties[i]);
            typeHandlers[i] = th = typeHandlerRegistry.getTypeHandler(keyPropertyType);
        }
        return typeHandlers;
    }

    private void populateKeys(ResultSet rs, MetaObject metaParam, String[] keyProperties, TypeHandler<?>[] typeHandlers) throws SQLException {
        for (int i = 0; i < keyProperties.length; ++i) {
            TypeHandler<?> th = typeHandlers[i];
            if (th == null) continue;
            Object value = th.getResult(rs, i + 1);
            metaParam.setValue(keyProperties[i], value);
        }
    }
}

