/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.CharTypes;
import com.alibaba.fastjson.serializer.SerialWriterStringEncoder;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.Base64;
import com.alibaba.fastjson.util.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializeWriter
extends Writer {
    protected char[] buf;
    protected int count;
    private static final ThreadLocal<SoftReference<char[]>> bufLocal = new ThreadLocal();
    private int features;

    public SerializeWriter() {
        this.features = JSON.DEFAULT_GENERATE_FEATURE;
        SoftReference<char[]> ref = bufLocal.get();
        if (ref != null) {
            this.buf = ref.get();
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
    }

    public SerializeWriter(SerializerFeature ... features) {
        SoftReference<char[]> ref = bufLocal.get();
        if (ref != null) {
            this.buf = ref.get();
            bufLocal.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[1024];
        }
        int featuresValue = 0;
        for (SerializerFeature feature : features) {
            featuresValue |= feature.getMask();
        }
        this.features = featuresValue;
    }

    public SerializeWriter(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    public void config(SerializerFeature feature, boolean state) {
        this.features = state ? (this.features |= feature.getMask()) : (this.features &= ~feature.getMask());
    }

    public boolean isEnabled(SerializerFeature feature) {
        return SerializerFeature.isEnabled(this.features, feature);
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public void write(char c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = c;
        this.count = newcount;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void expandCapacity(int minimumCapacity) {
        int newCapacity = this.buf.length * 3 / 2 + 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        this.buf = newValue;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream out, String charset) throws IOException {
        byte[] bytes = new String(this.buf, 0, this.count).getBytes(charset);
        out.write(bytes);
    }

    public void writeTo(OutputStream out, Charset charset) throws IOException {
        byte[] bytes = new String(this.buf, 0, this.count).getBytes(charset);
        out.write(bytes);
    }

    @Override
    public SerializeWriter append(CharSequence csq) {
        String s = csq == null ? "null" : ((Object)csq).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(CharSequence csq, int start, int end) {
        String s = ((Object)(csq == null ? "null" : csq).subSequence(start, end)).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        char[] newValue = new char[this.count];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        return newValue;
    }

    public byte[] toBytes(String charsetName) {
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        Charset cs = Charset.forName(charsetName);
        SerialWriterStringEncoder encoder = new SerialWriterStringEncoder(cs);
        return encoder.encode(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.buf.length <= 8192) {
            bufLocal.set(new SoftReference<char[]>(this.buf));
        }
        this.buf = null;
    }

    public void writeBooleanArray(boolean[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            boolean val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) ? 4 : 5;
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            boolean val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if (val = array[i]) {
                this.buf[currentSize++] = 116;
                this.buf[currentSize++] = 114;
                this.buf[currentSize++] = 117;
                this.buf[currentSize++] = 101;
                continue;
            }
            this.buf[currentSize++] = 102;
            this.buf[currentSize++] = 97;
            this.buf[currentSize++] = 108;
            this.buf[currentSize++] = 115;
            this.buf[currentSize++] = 101;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    @Override
    public void write(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        int length = text.length();
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        text.getChars(0, length, this.buf, this.count);
        this.count = newcount;
    }

    public void writeInt(int i) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int size = i < 0 ? IOUtils.stringSize((long)(-i)) + 1 : IOUtils.stringSize((long)i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeShortArray(short[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            int size;
            if (i != 0) {
                ++totalSize;
            }
            short val = array[i];
            sizeArray[i] = size = IOUtils.stringSize((long)val);
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            short val = array[i];
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeByteArray(byte[] bytes) {
        int bytesLen = bytes.length;
        if (bytesLen == 0) {
            this.write("\"\"");
            return;
        }
        char[] CA = Base64.CA;
        int eLen = bytesLen / 3 * 3;
        int charsLen = (bytesLen - 1) / 3 + 1 << 2;
        int offset = this.count;
        int newcount = this.count + charsLen + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        this.buf[offset++] = 34;
        int s = 0;
        int d = offset;
        while (s < eLen) {
            int i = (bytes[s++] & 0xFF) << 16 | (bytes[s++] & 0xFF) << 8 | bytes[s++] & 0xFF;
            this.buf[d++] = CA[i >>> 18 & 0x3F];
            this.buf[d++] = CA[i >>> 12 & 0x3F];
            this.buf[d++] = CA[i >>> 6 & 0x3F];
            this.buf[d++] = CA[i & 0x3F];
        }
        int left = bytesLen - eLen;
        if (left > 0) {
            int i = (bytes[eLen] & 0xFF) << 10 | (left == 2 ? (bytes[bytesLen - 1] & 0xFF) << 2 : 0);
            this.buf[newcount - 5] = CA[i >> 12];
            this.buf[newcount - 4] = CA[i >>> 6 & 0x3F];
            this.buf[newcount - 3] = left == 2 ? CA[i & 0x3F] : 61;
            this.buf[newcount - 2] = 61;
        }
        this.buf[newcount - 1] = 34;
    }

    public void writeIntArray(int[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            int val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == Integer.MIN_VALUE ? "-2147483648".length() : (val < 0 ? IOUtils.stringSize((long)(-val)) + 1 : IOUtils.stringSize((long)val));
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            int val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i]) == Integer.MIN_VALUE) {
                System.arraycopy("-2147483648".toCharArray(), 0, this.buf, currentSize, sizeArray[i]);
                currentSize += sizeArray[i];
                continue;
            }
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeIntAndChar(int i, char c) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            this.write(c);
            return;
        }
        int size = i < 0 ? IOUtils.stringSize((long)(-i)) + 1 : IOUtils.stringSize((long)i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLongAndChar(long i, char c) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            this.write(c);
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLong(long i) {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeNull() {
        int newcount = this.count + 4;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 110;
        this.buf[this.count + 1] = 117;
        this.buf[this.count + 2] = 108;
        this.buf[this.count + 3] = 108;
        this.count = newcount;
    }

    public void writeLongArray(long[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            long val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == Long.MIN_VALUE ? "-9223372036854775808".length() : (val < 0L ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val));
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            long val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i]) == Long.MIN_VALUE) {
                System.arraycopy("-9223372036854775808".toCharArray(), 0, this.buf, currentSize, sizeArray[i]);
                currentSize += sizeArray[i];
                continue;
            }
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    private void writeStringWithDoubleQuote(String text, char seperator) {
        this.writeStringWithDoubleQuote(text, seperator, true);
    }

    private void writeStringWithDoubleQuote(String text, char seperator, boolean checkSpecial) {
        char ch;
        int i;
        if (text == null) {
            this.writeNull();
            if (seperator != '\u0000') {
                this.write(seperator);
            }
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (seperator != '\u0000') {
            ++newcount;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char ch2;
            int i2;
            int lastSpecialIndex = -1;
            for (i2 = start; i2 < end; ++i2) {
                ch2 = this.buf[i2];
                if (ch2 == '\"' || ch2 == '/' || ch2 == '\\') {
                    lastSpecialIndex = i2;
                    ++newcount;
                    continue;
                }
                if (ch2 == '\b' || ch2 == '\f' || ch2 == '\n' || ch2 == '\r' || ch2 == '\t') {
                    lastSpecialIndex = i2;
                    ++newcount;
                    continue;
                }
                if (ch2 < ' ') {
                    lastSpecialIndex = i2;
                    newcount += 5;
                    continue;
                }
                if (ch2 < '\u007f') continue;
                lastSpecialIndex = i2;
                newcount += 5;
            }
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            for (i2 = lastSpecialIndex; i2 >= start; --i2) {
                ch2 = this.buf[i2];
                if (ch2 == '\b' || ch2 == '\f' || ch2 == '\n' || ch2 == '\r' || ch2 == '\t') {
                    System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 2, end - i2 - 1);
                    this.buf[i2] = 92;
                    this.buf[i2 + 1] = CharTypes.replaceChars[ch2];
                    ++end;
                    continue;
                }
                if (ch2 == '\"' || ch2 == '/' || ch2 == '\\') {
                    System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 2, end - i2 - 1);
                    this.buf[i2] = 92;
                    this.buf[i2 + 1] = ch2;
                    ++end;
                    continue;
                }
                if (ch2 < ' ') {
                    System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 6, end - i2 - 1);
                    this.buf[i2] = 92;
                    this.buf[i2 + 1] = 117;
                    this.buf[i2 + 2] = 48;
                    this.buf[i2 + 3] = 48;
                    this.buf[i2 + 4] = CharTypes.ASCII_CHARS[ch2 * 2];
                    this.buf[i2 + 5] = CharTypes.ASCII_CHARS[ch2 * 2 + 1];
                    end += 5;
                    continue;
                }
                if (ch2 < '\u007f') continue;
                System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 6, end - i2 - 1);
                this.buf[i2] = 92;
                this.buf[i2 + 1] = 117;
                this.buf[i2 + 2] = CharTypes.digits[ch2 >>> 12 & 0xF];
                this.buf[i2 + 3] = CharTypes.digits[ch2 >>> 8 & 0xF];
                this.buf[i2 + 4] = CharTypes.digits[ch2 >>> 4 & 0xF];
                this.buf[i2 + 5] = CharTypes.digits[ch2 & 0xF];
                end += 5;
            }
            if (seperator != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = seperator;
            } else {
                this.buf[this.count - 1] = 34;
            }
            return;
        }
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        if (checkSpecial) {
            for (i = start; i < end; ++i) {
                ch = this.buf[i];
                if (ch >= ']' || ch == ' ' || ch >= '0' && ch != '\\' || !(ch < CharTypes.specicalFlags_doubleQuotes.length && CharTypes.specicalFlags_doubleQuotes[ch] || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
            }
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++end;
            for (i = lastSpecialIndex - 2; i >= start; --i) {
                ch = this.buf[i];
                if (!(ch < CharTypes.specicalFlags_doubleQuotes.length && CharTypes.specicalFlags_doubleQuotes[ch] || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = CharTypes.replaceChars[ch];
                ++end;
            }
        }
        if (seperator != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = seperator;
        } else {
            this.buf[this.count - 1] = 34;
        }
    }

    public void writeKeyWithDoubleQuote(String text) {
        this.writeKeyWithDoubleQuote(text, true);
    }

    public void writeKeyWithDoubleQuote(String text, boolean checkSpecial) {
        boolean[] specicalFlags_doubleQuotes = CharTypes.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 3;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        if (checkSpecial) {
            for (int i = start; i < end; ++i) {
                char ch = this.buf[i];
                if (!(ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                if (++newcount > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                ++end;
            }
        }
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public void writeFieldNull(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeNull();
    }

    public void writeFieldEmptyList(char seperator, String key) {
        this.write(seperator);
        this.writeFieldName(key);
        this.write("[]");
    }

    public void writeFieldNullString(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullStringAsEmpty)) {
            this.writeString("");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullBoolean(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullBooleanAsFalse)) {
            this.write("false");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullList(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
            this.write("[]");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullNumber(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
            this.write('0');
        } else {
            this.writeNull();
        }
    }

    public void writeFieldValue(char seperator, String name, char value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(value));
        }
    }

    public void writeFieldValue(char seperator, String name, boolean value) {
        int keySeperator = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
        int intSize = value ? 4 : 5;
        int nameLen = name.length();
        int newcount = this.count + nameLen + 4 + intSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        this.count = newcount;
        this.buf[start] = seperator;
        int nameEnd = start + nameLen + 1;
        this.buf[start + 1] = keySeperator;
        name.getChars(0, nameLen, this.buf, start + 2);
        this.buf[nameEnd + 1] = keySeperator;
        if (value) {
            System.arraycopy(":true".toCharArray(), 0, this.buf, nameEnd + 2, 5);
        } else {
            System.arraycopy(":false".toCharArray(), 0, this.buf, nameEnd + 2, 6);
        }
    }

    public void writeFieldValue1(char seperator, String name, boolean value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char seperator, String name, int value) {
        if (value == Integer.MIN_VALUE || !this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeFieldValue1(seperator, name, value);
            return;
        }
        int keySeperator = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
        int intSize = value < 0 ? IOUtils.stringSize((long)(-value)) + 1 : IOUtils.stringSize((long)value);
        int nameLen = name.length();
        int newcount = this.count + nameLen + 4 + intSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        this.count = newcount;
        this.buf[start] = seperator;
        int nameEnd = start + nameLen + 1;
        this.buf[start + 1] = keySeperator;
        name.getChars(0, nameLen, this.buf, start + 2);
        this.buf[nameEnd + 1] = keySeperator;
        this.buf[nameEnd + 2] = 58;
        IOUtils.getChars(value, this.count, this.buf);
    }

    public void writeFieldValue1(char seperator, String name, int value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeInt(value);
    }

    public void writeFieldValue(char seperator, String name, long value) {
        if (value == Long.MIN_VALUE || !this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeFieldValue1(seperator, name, value);
            return;
        }
        int keySeperator = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
        int intSize = value < 0L ? IOUtils.stringSize(-value) + 1 : IOUtils.stringSize(value);
        int nameLen = name.length();
        int newcount = this.count + nameLen + 4 + intSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        this.count = newcount;
        this.buf[start] = seperator;
        int nameEnd = start + nameLen + 1;
        this.buf[start + 1] = keySeperator;
        name.getChars(0, nameLen, this.buf, start + 2);
        this.buf[nameEnd + 1] = keySeperator;
        this.buf[nameEnd + 2] = 58;
        IOUtils.getChars(value, this.count, this.buf);
    }

    public void writeFieldValue1(char seperator, String name, long value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeLong(value);
    }

    public void writeFieldValue(char seperator, String name, float value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0f) {
            this.write('0');
        } else if (Float.isNaN(value)) {
            this.writeNull();
        } else if (Float.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Float.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, double value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0) {
            this.write('0');
        } else if (Double.isNaN(value)) {
            this.writeNull();
        } else if (Double.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Double.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, String value) {
        if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
                this.write(seperator);
                this.writeFieldName(name);
                if (value == null) {
                    this.writeNull();
                } else {
                    this.writeString(value);
                }
            } else if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                this.write(seperator);
                this.writeStringWithDoubleQuote(name, ':');
                this.writeStringWithDoubleQuote(value, '\u0000');
            } else {
                this.writeFieldValueStringWithDoubleQuote(seperator, name, value, true);
            }
        } else {
            this.write(seperator);
            this.writeFieldName(name);
            if (value == null) {
                this.writeNull();
            } else {
                this.writeString(value);
            }
        }
    }

    private void writeFieldValueStringWithDoubleQuote(char seperator, String name, String value, boolean checkSpecial) {
        int valueLen;
        int nameLen = name.length();
        int newcount = this.count;
        if (value == null) {
            valueLen = 4;
            newcount += nameLen + 8;
        } else {
            valueLen = value.length();
            newcount += nameLen + valueLen + 6;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = seperator;
        int nameStart = this.count + 2;
        int nameEnd = nameStart + nameLen;
        this.buf[this.count + 1] = 34;
        name.getChars(0, nameLen, this.buf, nameStart);
        this.count = newcount;
        this.buf[nameEnd] = 34;
        int index = nameEnd + 1;
        this.buf[index++] = 58;
        if (value == null) {
            this.buf[index++] = 110;
            this.buf[index++] = 117;
            this.buf[index++] = 108;
            this.buf[index++] = 108;
            return;
        }
        this.buf[index++] = 34;
        int valueStart = index;
        int valueEnd = valueStart + valueLen;
        value.getChars(0, valueLen, this.buf, valueStart);
        if (checkSpecial && !this.isEnabled(SerializerFeature.DisableCheckSpecialChar)) {
            char ch;
            int i;
            int specialCount = 0;
            int lastSpecialIndex = -1;
            char lastSpecial = '\u0000';
            for (i = valueStart; i < valueEnd; ++i) {
                ch = this.buf[i];
                if (ch >= ']' || !SerializeWriter.isSpecial(ch, this.features)) continue;
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
            }
            if (specialCount > 0) {
                if ((newcount += specialCount) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                if (specialCount == 1) {
                    System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, valueEnd - lastSpecialIndex - 1);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
                } else if (specialCount > 1) {
                    System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, valueEnd - lastSpecialIndex - 1);
                    this.buf[lastSpecialIndex] = 92;
                    this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
                    ++valueEnd;
                    for (i = lastSpecialIndex - 2; i >= valueStart; --i) {
                        ch = this.buf[i];
                        if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"' && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                        System.arraycopy(this.buf, i + 1, this.buf, i + 2, valueEnd - i - 1);
                        this.buf[i] = 92;
                        this.buf[i + 1] = CharTypes.replaceChars[ch];
                        ++valueEnd;
                    }
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    static final boolean isSpecial(char ch, int features) {
        if (ch == ' ') {
            return false;
        }
        if (ch == '/' && SerializerFeature.isEnabled(features, SerializerFeature.WriteSlashAsSpecial)) {
            return true;
        }
        if (ch > '#' && ch != '\\') {
            return false;
        }
        return ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\"' || ch == '\t' && SerializerFeature.isEnabled(features, SerializerFeature.WriteTabAsSpecial);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeFieldValue(char seperator, String name, Enum<?> value) {
        if (value == null) {
            this.write(seperator);
            this.writeFieldName(name);
            this.writeNull();
            return;
        }
        if (!this.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            this.writeFieldValue(seperator, name, value.ordinal());
            return;
        }
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeFieldValue(seperator, name, value.name());
            return;
        }
        this.writeFieldValueStringWithDoubleQuote(seperator, name, value.name(), false);
    }

    public void writeFieldValue(char seperator, String name, BigDecimal value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == null) {
            this.writeNull();
        } else {
            this.write(value.toString());
        }
    }

    public void writeString(String text, char seperator) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeStringWithSingleQuote(text);
            this.write(seperator);
        } else {
            this.writeStringWithDoubleQuote(text, seperator);
        }
    }

    public void writeString(String text) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeStringWithSingleQuote(text);
        } else {
            this.writeStringWithDoubleQuote(text, '\u0000');
        }
    }

    private void writeStringWithSingleQuote(String text) {
        char ch;
        int i;
        if (text == null) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = newcount;
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        for (i = start; i < end; ++i) {
            ch = this.buf[i];
            if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\'' && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++end;
            for (i = lastSpecialIndex - 2; i >= start; --i) {
                ch = this.buf[i];
                if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\'' && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = CharTypes.replaceChars[ch];
                ++end;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeFieldName(String key) {
        this.writeFieldName(key, false);
    }

    public void writeFieldName(String key, boolean checkSpecial) {
        if (key == null) {
            this.write("null:");
            return;
        }
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
                this.writeKeyWithSingleQuote(key);
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(key);
            }
        } else if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeKeyWithDoubleQuote(key, checkSpecial);
        } else {
            this.writeKeyWithDoubleQuoteIfHasSpecial(key);
        }
    }

    private void writeKeyWithSingleQuote(String text) {
        boolean[] specicalFlags_singleQuotes = CharTypes.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 3;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (!(ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch] || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) && (ch != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[this.count - 2] = 39;
        this.buf[this.count - 1] = 58;
    }

    private void writeKeyWithDoubleQuoteIfHasSpecial(String text) {
        boolean[] specicalFlags_doubleQuotes = CharTypes.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch >= specicalFlags_doubleQuotes.length || !specicalFlags_doubleQuotes[ch]) continue;
            if (!hasSpecial) {
                if ((newcount += 3) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[start] = 34;
                this.buf[++i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                end += 2;
                this.buf[this.count - 2] = 34;
                hasSpecial = true;
                continue;
            }
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[this.count - 1] = 58;
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String text) {
        boolean[] specicalFlags_singleQuotes = CharTypes.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch >= specicalFlags_singleQuotes.length || !specicalFlags_singleQuotes[ch]) continue;
            if (!hasSpecial) {
                if ((newcount += 3) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[start] = 39;
                this.buf[++i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                end += 2;
                this.buf[this.count - 2] = 39;
                hasSpecial = true;
                continue;
            }
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[newcount - 1] = 58;
    }
}

