/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoRetryTaobaoClient
extends DefaultTaobaoClient {
    private static final Log log = LogFactory.getLog(AutoRetryTaobaoClient.class);
    private static final ApiException RETRY_FAIL = new ApiException("sdk.retry-call-fail", "API\u8c03\u7528\u91cd\u8bd5\u5931\u8d25");
    private int maxRetryCount = 3;
    private long retryWaitTime = 100L;
    private boolean throwIfOverMaxRetry = false;
    private Set<String> retryErrorCodes;

    public AutoRetryTaobaoClient(String serverUrl, String appKey, String appSecret) {
        super(serverUrl, appKey, appSecret);
    }

    public AutoRetryTaobaoClient(String serverUrl, String appKey, String appSecret, String format) {
        super(serverUrl, appKey, appSecret, format);
    }

    public AutoRetryTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
    }

    public AutoRetryTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout, signMethod);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        TaobaoResponse rsp = null;
        ApiException exp = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                if (!(rsp != null && (rsp.getSubCode() != null && rsp.getSubCode().startsWith("isp.") || this.retryErrorCodes != null && this.retryErrorCodes.contains(rsp.getSubCode()))) && exp == null) break;
                this.sleepWithoutInterrupt(this.retryWaitTime);
                log.warn((Object)this.buildRetryLog(request.getApiMethodName(), request.getTextParams(), i));
            }
            try {
                rsp = super.execute(request, session);
                if (rsp.isSuccess()) {
                    return (T)rsp;
                }
                if (i != this.maxRetryCount || !this.throwIfOverMaxRetry) continue;
                throw RETRY_FAIL;
            }
            catch (ApiException e) {
                if (exp != null) continue;
                exp = e;
            }
        }
        if (exp != null) {
            throw exp;
        }
        return (T)rsp;
    }

    private String buildRetryLog(String apiName, Map<String, String> params, int retryCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(apiName).append(" retry call ").append(retryCount);
        params.remove("fields");
        sb.append(" times, params=").append(params);
        return sb.toString();
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setRetryWaitTime(long retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    public void setThrowIfOverMaxRetry(boolean throwIfOverMaxRetry) {
        this.throwIfOverMaxRetry = throwIfOverMaxRetry;
    }

    public void setRetryErrorCodes(Set<String> retryErrorCodes) {
        this.retryErrorCodes = retryErrorCodes;
    }

    private void sleepWithoutInterrupt(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

