/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import snaq.util.EventDispatcher;
import snaq.util.EventNotifier;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;
import snaq.util.Reusable;
import snaq.util.TimeWrapper;
import snaq.util.logging.LogUtil;

public abstract class ObjectPool<T extends Reusable>
implements Comparable<ObjectPool> {
    protected Log logger;
    private static final int ACCESS_FIFO = 1;
    private static final int ACCESS_LIFO = 2;
    private static final int ACCESS_RANDOM = 3;
    private int accessMethod = 2;
    private Random randGen = null;
    private LogUtil logUtil;
    private String name;
    private static int unnamedCount = 0;
    private List<TimeWrapper<T>> free;
    private List<T> used;
    private int minPool;
    private int maxPool;
    private int maxSize;
    private long idleTimeout;
    private long requests;
    private long hits;
    private volatile boolean released = false;
    private boolean asyncDestroy = false;
    private EventDispatcher<ObjectPoolListener, ObjectPoolEvent> eventDispatcher;
    private Cleaner cleaner;
    private InitThread initer;
    private Thread shutdownHook = null;
    private static int cleanerCount = 0;
    private final List<ObjectPoolListener> listeners = new CopyOnWriteArrayList<ObjectPoolListener>();

    protected ObjectPool(String name, int minPool, int maxPool, int maxSize, long idleTimeout) {
        Class<List> type = this.getPoolClass();
        if (type == null || !List.class.isAssignableFrom(type)) {
            throw new RuntimeException("Invalid pool class type specified: " + type.getName() + " (must implement java.util.List)");
        }
        try {
            this.free = type.newInstance();
            this.used = type.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to instantiate pool class type: " + type.getName());
        }
        this.name = name == null || name.equals("") ? "unknown" + unnamedCount++ : name;
        this.logger = LogFactory.getLog((String)(this.getClass().getName() + "." + name));
        this.setParameters(minPool, maxPool, maxSize, idleTimeout);
        this.eventDispatcher = new EventDispatcher<ObjectPoolListener, ObjectPoolEvent>(this.listeners, new Notifier());
        this.eventDispatcher.start();
    }

    protected ObjectPool(String name, int maxPool, int maxSize, long idleTimeout) {
        this(name, 0, maxPool, maxSize, idleTimeout);
    }

    public synchronized void registerShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        try {
            this.shutdownHook = new Releaser(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (IllegalArgumentException iax) {
            System.err.println("Shutdown-hook not registered (unsupported) for pool " + this);
        }
        catch (Exception ex) {
            System.err.println("Error registering shutdown-hook for pool " + this);
            ex.printStackTrace();
        }
    }

    public synchronized void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        this.shutdownHook = null;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(this.getParametersString());
        return sb.toString();
    }

    public String getParametersString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("name=");
        sb.append(this.getName());
        sb.append(",minPool=");
        sb.append(this.getMinPool());
        sb.append(",maxPool=");
        sb.append(this.getMaxPool());
        sb.append(",maxSize=");
        sb.append(this.getMaxSize());
        sb.append(",idleTimeout=");
        sb.append(this.getIdleTimeout());
        sb.append("]");
        return sb.toString();
    }

    public final synchronized void init() {
        if (this.initer != null) {
            return;
        }
        int dif = this.minPool - this.getSize();
        if (dif > 0) {
            this.init(this.minPool);
        }
    }

    public final synchronized void init(int num) {
        if (num == 0) {
            return;
        }
        if (num < 0) {
            throw new IllegalArgumentException("Invalid number of items specified for initialization: " + num);
        }
        if (this.idleTimeout == 0L && this.maxSize == 0 && num > this.maxPool) {
            throw new IllegalArgumentException("Invalid number of items specified for initialization: " + num + " (max " + this.getMaxPool() + ")");
        }
        if (this.maxSize > 0 && num > this.maxSize) {
            throw new IllegalArgumentException("Invalid number of items specified for initialization: " + num + " (max " + this.getMaxSize() + ")");
        }
        if (this.initer != null) {
            this.initer.halt();
            try {
                this.initer.join();
            }
            catch (InterruptedException ix) {
                this.log_warn(ix.getMessage(), ix);
            }
        }
        this.initer = new InitThread(this, num);
        this.initer.start();
    }

    protected final synchronized T checkOut() throws Exception {
        boolean hit;
        if (this.released) {
            throw new RuntimeException("Pool no longer valid for use");
        }
        int preTotal = this.used.size() + this.free.size();
        TimeWrapper<T> tw = null;
        Reusable o = null;
        if (this.free.size() > 0) {
            switch (this.accessMethod) {
                case 1: {
                    tw = this.free.remove(0);
                    break;
                }
                case 3: {
                    tw = this.free.remove(this.randGen.nextInt(this.free.size()));
                    break;
                }
                default: {
                    tw = this.free.remove(this.free.size() - 1);
                }
            }
            o = (Reusable)tw.getObject();
            boolean valid = this.isValid(o);
            while (!valid && this.free.size() > 0) {
                this.destroyObject(o);
                this.log_info("Removed invalid item from pool");
                this.firePoolEvent(4);
                switch (this.accessMethod) {
                    case 1: {
                        tw = this.free.remove(0);
                        break;
                    }
                    case 3: {
                        tw = this.free.remove(this.randGen.nextInt(this.free.size()));
                        break;
                    }
                    default: {
                        tw = this.free.remove(this.free.size() - 1);
                    }
                }
                o = (Reusable)tw.getObject();
                valid = this.isValid(o);
            }
            if (this.free.size() == 0 && !valid) {
                o = null;
            }
        }
        boolean bl = hit = o != null;
        if (o == null) {
            if (this.maxSize > 0 && this.used.size() == this.maxSize) {
                this.firePoolEvent(8);
            } else if (!(this.maxSize != 0 && this.used.size() >= this.maxSize || this.isValid(o = this.create()))) {
                this.firePoolEvent(4);
                throw new RuntimeException("Unable to create a valid item");
            }
        }
        if (o != null) {
            this.used.add(o);
            ++this.requests;
            if (hit) {
                ++this.hits;
            }
            this.firePoolEvent(2);
            int postTotal = this.used.size() + this.free.size();
            if (postTotal == this.maxPool && postTotal > preTotal) {
                this.firePoolEvent(5);
            } else if (postTotal == this.maxPool + 1 && postTotal > preTotal) {
                this.firePoolEvent(6);
            }
            if (postTotal == this.maxSize && postTotal > preTotal) {
                this.firePoolEvent(7);
            }
        }
        if (this.logger.isDebugEnabled()) {
            String ratio = this.used.size() + "/" + (this.used.size() + this.free.size());
            String hitRate = " (HitRate=" + this.getPoolHitRate() * 100.0f + "%)";
            this.log_debug("Checkout - " + ratio + hitRate + (o == null ? " - null returned" : ""));
        }
        return (T)o;
    }

    protected final synchronized T checkOut(long timeout) throws Exception {
        long time = System.currentTimeMillis();
        T o = this.checkOut();
        while (o == null && System.currentTimeMillis() - time < timeout) {
            try {
                this.log_debug("No pooled items spare...waiting for up to " + timeout + "ms");
                this.wait(timeout);
                o = this.checkOut();
            }
            catch (InterruptedException e) {
                this.log_warn("Checkout interrupted", e);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkIn(T o) {
        if (o == null) {
            this.log_info("Attempt to return null item");
            return;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            boolean nonRecyclable;
            this.firePoolEvent(3);
            if (!this.used.remove(o)) {
                this.log_warn("Attempt to return item not belonging to pool");
                throw new RuntimeException("Attempt to return item not belonging to pool " + this.name);
            }
            boolean bl = nonRecyclable = this.maxSize > 0 && this.getSize() >= this.maxPool || this.maxSize == 0 && this.getFreeCount() >= this.maxPool;
            if (o.isDirty() || nonRecyclable) {
                this.destroyObject(o);
                this.log_debug("Checkin* - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
            } else {
                try {
                    o.recycle();
                    this.free.add(new TimeWrapper<T>(o, this.idleTimeout));
                    this.log_debug("Checkin  - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                    this.notifyAll();
                }
                catch (Exception e) {
                    this.destroyObject(o);
                    this.log_info("Unable to recycle item - destroyed", e);
                }
            }
        }
    }

    public final void release() {
        this.release(false);
    }

    public final boolean isReleased() {
        return this.released;
    }

    public final synchronized void releaseAsync() {
        this.releaseAsync(false);
    }

    public final void releaseForcibly() {
        this.release(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void release(boolean forced) {
        if (this.released) {
            return;
        }
        this.released = true;
        this.preRelease();
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.initer != null) {
                this.initer.halt();
                this.initer = null;
            }
            if (this.cleaner != null) {
                this.cleaner.halt();
                this.cleaner = null;
            }
            int releasedCount = 0;
            int failedCount = 0;
            for (TimeWrapper<T> tw : this.free) {
                Reusable o = (Reusable)tw.getObject();
                try {
                    this.destroy(o);
                    ++releasedCount;
                }
                catch (Exception ex) {
                    ++failedCount;
                    this.log_warn("Unable to release item in pool", ex);
                }
            }
            this.free.clear();
            if (forced) {
                for (Reusable o : this.used) {
                    try {
                        this.destroy(o);
                        ++releasedCount;
                    }
                    catch (Exception ex) {
                        ++failedCount;
                        this.log_warn("Unable to release item in pool", ex);
                    }
                }
                this.used.clear();
            } else {
                if (this.logger.isDebugEnabled() && this.used.size() > 0) {
                    this.log_debug("Waiting for used items to be checked-in...");
                }
                while (this.used.size() > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ix) {
                        this.log_warn(ix.getMessage(), ix);
                    }
                }
            }
            if (this.logger.isDebugEnabled()) {
                String s = "Released " + releasedCount + (releasedCount > 1 ? " items" : " item");
                if (failedCount > 0) {
                    s = s + " (failed to release " + failedCount + (failedCount > 1 ? " items)" : " item)");
                }
                this.log_debug(s);
            }
        }
        this.firePoolReleasedEvent();
        objectPool = this;
        synchronized (objectPool) {
            if (this.logUtil != null) {
                this.logUtil.close();
            }
            this.listeners.clear();
            this.eventDispatcher.halt();
            if (!forced) {
                try {
                    this.eventDispatcher.join();
                }
                catch (InterruptedException ix) {
                    this.log_warn("Interrupted during halting of event dispatch thread", ix);
                }
            }
            this.eventDispatcher = null;
        }
        this.postRelease();
    }

    protected void preRelease() {
    }

    protected void postRelease() {
    }

    private final void releaseAsync(final boolean forced) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectPool.this.release(forced);
            }
        });
        t.start();
    }

    protected abstract T create() throws Exception;

    protected abstract boolean isValid(T var1);

    protected abstract void destroy(T var1);

    private final void destroyObject(T o) {
        if (o == null) {
            return;
        }
        if (this.asyncDestroy) {
            Thread t = new Thread(new Runnable((Reusable)o){
                final /* synthetic */ Reusable val$o;
                {
                    this.val$o = reusable;
                }

                @Override
                public void run() {
                    ObjectPool.this.destroy(this.val$o);
                }
            });
            t.start();
        } else {
            this.destroy(o);
        }
    }

    public final void setAsyncDestroy(boolean b) {
        this.asyncDestroy = b;
    }

    public final boolean isAsyncDestroy() {
        return this.asyncDestroy;
    }

    public void setLog(PrintWriter writer) {
        if (this.logUtil == null) {
            this.logUtil = new LogUtil();
        }
        this.logUtil.setLog(writer);
    }

    public LogUtil getCustomLogger() {
        return this.logUtil;
    }

    protected void log_error(String s) {
        String msg = this.name + ": " + s;
        this.logger.error((Object)msg);
        if (this.logUtil != null) {
            this.logUtil.log(msg);
        }
    }

    protected void log_error(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.error((Object)msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(msg, throwable);
        }
    }

    protected void log_warn(String s) {
        String msg = this.name + ": " + s;
        this.logger.warn((Object)msg);
        if (this.logUtil != null) {
            this.logUtil.log(msg);
        }
    }

    protected void log_warn(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.warn((Object)msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(msg, throwable);
        }
    }

    protected void log_info(String s) {
        String msg = this.name + ": " + s;
        this.logger.info((Object)msg);
        if (this.logUtil != null) {
            this.logUtil.log(msg);
        }
    }

    protected void log_info(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.info((Object)msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.log(msg, throwable);
        }
    }

    protected void log_debug(String s) {
        String msg = this.name + ": " + s;
        this.logger.debug((Object)msg);
        if (this.logUtil != null) {
            this.logUtil.debug(msg);
        }
    }

    protected void log_debug(String s, Throwable throwable) {
        String msg = this.name + ": " + s;
        this.logger.debug((Object)msg, throwable);
        if (this.logUtil != null) {
            this.logUtil.debug(msg, throwable);
        }
    }

    protected void log_trace(String s) {
        this.logger.trace((Object)(this.name + ": " + s));
    }

    protected void log_trace(String s, Throwable throwable) {
        this.logger.trace((Object)(this.name + ": " + s), throwable);
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized int getMinPool() {
        return this.minPool;
    }

    public final synchronized int getMaxPool() {
        return this.maxPool;
    }

    public final synchronized int getMaxSize() {
        return this.maxSize;
    }

    protected synchronized long getIdleTimeoutUnadjusted() {
        return this.idleTimeout;
    }

    public synchronized long getIdleTimeout() {
        return (long)((float)this.idleTimeout / this.getIdleTimeoutMultiplier());
    }

    @Deprecated
    public long getExpiryTime() {
        return this.getIdleTimeout();
    }

    protected float getIdleTimeoutMultiplier() {
        return 1.0f;
    }

    protected long getMinimumCleaningInterval() {
        return 200L;
    }

    protected long getMaximumCleaningInterval() {
        return 5000L;
    }

    public final void setParameters(int maxPool, int maxSize, long idleTimeout) {
        this.setParameters(this.minPool, maxPool, maxSize, idleTimeout);
    }

    public final synchronized void setParameters(int minPool, int maxPool, int maxSize, long idleTimeout) {
        if (minPool < 0 || maxPool < 0 || maxSize < 0 || idleTimeout < 0L) {
            throw new IllegalArgumentException("Negative values not accepted as pool parameters");
        }
        if (maxPool < minPool) {
            throw new IllegalArgumentException("Invalid minPool/maxPool values: " + minPool + "/" + maxPool);
        }
        if (maxSize > 0 && maxSize < maxPool) {
            throw new IllegalArgumentException("Invalid maxPool/maxSize values: " + maxPool + "/" + maxSize);
        }
        if (this.cleaner != null) {
            this.cleaner.halt();
            this.cleaner = null;
        }
        this.minPool = minPool;
        this.maxPool = maxPool;
        this.maxSize = maxSize;
        this.idleTimeout = (long)((float)idleTimeout * this.getIdleTimeoutMultiplier());
        this.resetHitCounter();
        for (TimeWrapper<T> tw : this.free) {
            tw.setLiveTime(this.idleTimeout);
        }
        if (this.idleTimeout > 0L) {
            long min = this.getMinimumCleaningInterval();
            long max = this.getMaximumCleaningInterval();
            if (min < 0L || max < 0L || min >= max) {
                throw new RuntimeException("Invalid min/max cleaner interval specified");
            }
            long iVal = Math.max(min, Math.min(max, this.idleTimeout / 5L));
            this.cleaner = new Cleaner(this, iVal);
            this.cleaner.start();
        }
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("minpool=");
            sb.append(this.getMinPool());
            sb.append(",maxpool=");
            sb.append(this.getMaxPool());
            sb.append(",maxsize=");
            sb.append(this.getMaxSize());
            sb.append(",idleTimeout=");
            long it = this.getIdleTimeout();
            if (it == 0L) {
                sb.append("none");
            } else {
                sb.append(it);
                sb.append(",cleanInterval=");
                sb.append(this.cleaner.interval);
            }
            this.log_debug("Parameters changed (" + sb.toString() + ")");
        }
        this.firePoolEvent(9);
    }

    public final synchronized int getSize() {
        return this.free.size() + this.used.size();
    }

    public final synchronized int getCheckedOut() {
        return this.used.size();
    }

    public final synchronized int getFreeCount() {
        return this.free.size();
    }

    public final synchronized long getRequestCount() {
        return this.requests;
    }

    @Deprecated
    public final synchronized float getHitRate() {
        return this.getPoolHitRate() * 100.0f;
    }

    public final synchronized float getPoolHitRate() {
        return this.requests == 0L ? 0.0f : (float)this.hits / (float)this.requests;
    }

    public final synchronized float getPoolMissRate() {
        return this.requests == 0L ? 0.0f : (float)(this.requests - this.hits) / (float)this.requests;
    }

    public final synchronized void resetHitCounter() {
        this.hits = 0L;
        this.requests = 0L;
    }

    protected final synchronized void setAccessFIFO() {
        this.accessMethod = 1;
    }

    protected final synchronized void setAccessLIFO() {
        this.accessMethod = 2;
    }

    protected final synchronized void setAccessRandom() {
        if (this.randGen == null) {
            this.randGen = new Random();
        }
        this.accessMethod = 3;
    }

    protected Class<? extends List> getPoolClass() {
        return ArrayList.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        int count = 0;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            TimeWrapper<T> tw = null;
            Iterator<TimeWrapper<T>> iter = this.free.iterator();
            while (iter.hasNext()) {
                tw = iter.next();
                iter.remove();
                this.destroyObject((Reusable)tw.getObject());
                ++count;
            }
            if (count > 0) {
                this.log_debug("Flushed all spare items from pool");
            }
            this.firePoolEvent(10);
            if (this.idleTimeout == 0L && this.minPool > 0) {
                this.init();
            }
        }
    }

    final synchronized boolean purge() {
        this.log_trace("Checking for expired items");
        if (this.free.size() == 0) {
            return false;
        }
        int count = 0;
        TimeWrapper<T> tw = null;
        Iterator<TimeWrapper<T>> iter = this.free.iterator();
        while (iter.hasNext()) {
            tw = iter.next();
            if (!tw.isExpired()) continue;
            iter.remove();
            this.destroyObject((Reusable)tw.getObject());
            ++count;
        }
        return this.free.size() > 0 || count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object o) {
        ObjectPool op;
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPool objectPool = op = (ObjectPool)o;
        synchronized (objectPool) {
            if (this.name == null ? op.name != null : !this.name.equals(op.name)) {
                return false;
            }
            if (this.minPool != op.minPool) {
                return false;
            }
            if (this.maxPool != op.maxPool) {
                return false;
            }
            if (this.maxSize != op.maxSize) {
                return false;
            }
            if (this.idleTimeout != op.idleTimeout) {
                return false;
            }
        }
        return true;
    }

    public synchronized int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public synchronized int compareTo(ObjectPool pool) {
        if (pool == null) {
            throw new NullPointerException();
        }
        int i = this.getName().compareTo(pool.getName());
        if (i != 0) {
            return i;
        }
        i = Integer.valueOf(this.minPool).compareTo(pool.getMinPool());
        if (i != 0) {
            return i;
        }
        i = Integer.valueOf(this.maxPool).compareTo(pool.getMaxPool());
        if (i != 0) {
            return i;
        }
        i = Integer.valueOf(this.maxSize).compareTo(pool.getMaxSize());
        if (i != 0) {
            return i;
        }
        i = Long.valueOf(this.idleTimeout).compareTo(pool.getIdleTimeoutUnadjusted());
        return i;
    }

    public final void addObjectPoolListener(ObjectPoolListener x) {
        this.listeners.add(x);
    }

    public final void removeObjectPoolListener(ObjectPoolListener x) {
        this.listeners.remove(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void firePoolEvent(int type) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = null;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            poolEvent = new ObjectPoolEvent(this, type);
            poolEvent.setMinPool(this.getMinPool());
            poolEvent.setMaxPool(this.getMaxPool());
            poolEvent.setMaxSize(this.getMaxSize());
            poolEvent.setIdleTimeout(this.getIdleTimeout());
            poolEvent.setCheckOut(this.getCheckedOut());
            poolEvent.setFreeCount(this.getFreeCount());
            poolEvent.setSize(this.getSize());
            poolEvent.setPoolHitRate(this.getPoolHitRate());
        }
        this.eventDispatcher.dispatchEvent(poolEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent poolEvent = null;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            poolEvent = new ObjectPoolEvent(this, 11);
            poolEvent.setMinPool(this.getMinPool());
            poolEvent.setMaxPool(this.getMaxPool());
            poolEvent.setMaxSize(this.getMaxSize());
            poolEvent.setIdleTimeout(this.getIdleTimeout());
            poolEvent.setCheckOut(this.getCheckedOut());
            poolEvent.setFreeCount(this.getFreeCount());
            poolEvent.setSize(this.getSize());
            poolEvent.setPoolHitRate(this.getPoolHitRate());
        }
        for (ObjectPoolListener listener : this.listeners) {
            try {
                listener.poolReleased(poolEvent);
            }
            catch (RuntimeException rx) {
                this.log_warn("Exception thrown by listener on pool release", rx);
            }
        }
    }

    private final class Notifier
    implements EventNotifier<ObjectPoolListener, ObjectPoolEvent> {
        private Notifier() {
        }

        @Override
        public void notifyListener(ObjectPoolListener opl, ObjectPoolEvent evt) {
            try {
                switch (evt.getType()) {
                    case 1: {
                        opl.poolInitCompleted(evt);
                        break;
                    }
                    case 2: {
                        opl.poolCheckOut(evt);
                        break;
                    }
                    case 3: {
                        opl.poolCheckIn(evt);
                        break;
                    }
                    case 4: {
                        opl.validationError(evt);
                        break;
                    }
                    case 5: {
                        opl.maxPoolLimitReached(evt);
                        break;
                    }
                    case 6: {
                        opl.maxPoolLimitExceeded(evt);
                        break;
                    }
                    case 7: {
                        opl.maxSizeLimitReached(evt);
                        break;
                    }
                    case 8: {
                        opl.maxSizeLimitError(evt);
                        break;
                    }
                    case 9: {
                        opl.poolParametersChanged(evt);
                        break;
                    }
                    case 10: {
                        opl.poolFlushed(evt);
                        break;
                    }
                    case 11: {
                        opl.poolReleased(evt);
                        break;
                    }
                }
            }
            catch (RuntimeException rx) {
                ObjectPool.this.log_warn("Exception raised by pool listener", rx);
            }
        }
    }

    private static final class Releaser
    extends Thread {
        private ObjectPool instance;

        private Releaser(ObjectPool pool) {
            this.instance = pool;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (!this.instance.isReleased()) {
                this.instance.releaseForcibly();
            }
        }
    }

    private final class InitThread
    extends Thread {
        private final ObjectPool<T> pool;
        private int num;
        private volatile boolean stopped = false;
        private volatile boolean done = false;

        private InitThread(ObjectPool<T> pool, int num) {
            assert (pool != null);
            assert (num >= 0 && (num <= pool.getMaxSize() || ObjectPool.this.getMaxSize() == 0));
            this.pool = pool;
            this.num = pool.getIdleTimeoutUnadjusted() > 0L ? Math.min(ObjectPool.this.getMaxSize(), Math.max(num, 0)) : Math.min(ObjectPool.this.getMaxPool(), Math.max(num, 0));
            this.setDaemon(true);
        }

        public void halt() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ObjectPool objectPool;
            int count = 0;
            while (!this.stopped && !this.done) {
                objectPool = this.pool;
                synchronized (objectPool) {
                    if (this.pool.initer != Thread.currentThread()) {
                        this.stopped = true;
                        continue;
                    }
                    if (count >= this.num || ObjectPool.this.getFreeCount() >= this.num || ObjectPool.this.getMaxSize() > 0 && ObjectPool.this.getSize() >= ObjectPool.this.getMaxSize()) {
                        this.done = true;
                    }
                    if (!this.stopped && !this.done) {
                        try {
                            Object o = ObjectPool.this.create();
                            if (o == null) {
                                throw new RuntimeException("Null item created");
                            }
                            ObjectPool.this.free.add(new TimeWrapper(o, this.pool.idleTimeout));
                            this.pool.notifyAll();
                            ++count;
                            ObjectPool.this.log_debug("Initialized new item in pool");
                        }
                        catch (Exception ex) {
                            ObjectPool.this.log_warn("Unable to initialize items in pool", ex);
                            this.stopped = true;
                        }
                    }
                }
            }
            objectPool = this.pool;
            synchronized (objectPool) {
                if (!this.stopped && this.done) {
                    ObjectPool.this.log_debug("Initialized pool with " + count + (count > 1 ? " new items" : " new item"));
                    ObjectPool.this.firePoolEvent(1);
                }
                if (this.pool.initer != Thread.currentThread()) {
                    this.pool.initer = null;
                }
            }
        }
    }

    private final class Cleaner
    extends Thread {
        private final ObjectPool pool;
        private long interval;
        private volatile boolean stopped;

        private Cleaner(ObjectPool pool, long interval) {
            assert (pool != null && interval > 0L);
            this.setName("Cleaner-thread-" + Integer.toString(cleanerCount++));
            this.pool = pool;
            this.interval = interval;
            this.setDaemon(true);
        }

        @Override
        public void start() {
            this.stopped = false;
            super.start();
        }

        public void halt() {
            this.stopped = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean purged;
            boolean bl = purged = ObjectPool.this.getSize() > 0;
            while (!this.stopped) {
                ObjectPool objectPool = this.pool;
                synchronized (objectPool) {
                    if (this.pool.cleaner != Thread.currentThread()) {
                        this.stopped = true;
                    } else {
                        if (!purged && this.pool.getSize() == 0) {
                            try {
                                this.pool.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (!this.stopped) {
                            purged = this.pool.purge();
                            this.pool.init();
                        }
                    }
                }
                if (this.stopped) continue;
                try {
                    Cleaner.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

