/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN8Reader
extends UPCEANReader {
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray row, int[] startRange, StringBuilder result) throws NotFoundException {
        int n;
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int x = 0;
        while (x < 4 && rowOffset < end) {
            int bestMatch = EAN8Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            result.append((char)(48 + bestMatch));
            int[] nArray = counters;
            n = counters.length;
            int n2 = 0;
            while (n2 < n) {
                int counter = nArray[n2];
                rowOffset += counter;
                ++n2;
            }
            ++x;
        }
        int[] middleRange = EAN8Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN);
        rowOffset = middleRange[1];
        int x2 = 0;
        while (x2 < 4 && rowOffset < end) {
            int bestMatch = EAN8Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            result.append((char)(48 + bestMatch));
            int[] nArray = counters;
            int n3 = counters.length;
            n = 0;
            while (n < n3) {
                int counter = nArray[n];
                rowOffset += counter;
                ++n;
            }
            ++x2;
        }
        return rowOffset;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_8;
    }
}

