/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.frame;

import java.nio.charset.Charset;
import org.springframework.util.Assert;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;

public class SockJsFrame {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final SockJsFrame openFrame = new SockJsFrame("o");
    private static final SockJsFrame heartbeatFrame = new SockJsFrame("h");
    private static final SockJsFrame closeGoAwayFrame = SockJsFrame.closeFrame(3000, "Go away!");
    private static final SockJsFrame closeAnotherConnectionOpenFrame = SockJsFrame.closeFrame(2010, "Another connection still open");
    private final String content;

    public static SockJsFrame openFrame() {
        return openFrame;
    }

    public static SockJsFrame heartbeatFrame() {
        return heartbeatFrame;
    }

    public static SockJsFrame messageFrame(SockJsMessageCodec codec, String ... messages) {
        String encoded = codec.encode(messages);
        return new SockJsFrame(encoded);
    }

    public static SockJsFrame closeFrameGoAway() {
        return closeGoAwayFrame;
    }

    public static SockJsFrame closeFrameAnotherConnectionOpen() {
        return closeAnotherConnectionOpenFrame;
    }

    public static SockJsFrame closeFrame(int code, String reason) {
        return new SockJsFrame("c[" + code + ",\"" + reason + "\"]");
    }

    public SockJsFrame(String content) {
        Assert.notNull((Object)"Content must not be null");
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public byte[] getContentBytes() {
        return this.content.getBytes(UTF8_CHARSET);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SockJsFrame)) {
            return false;
        }
        return this.content.equals(((SockJsFrame)other).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        String result = this.content;
        if (result.length() > 80) {
            result = result.substring(0, 80) + "...(truncated)";
        }
        return "SockJsFrame content='" + result.replace("\n", "\\n").replace("\r", "\\r") + "'";
    }
}

