/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.springframework.web.socket.handler.SessionLimitExceededException;
import org.springframework.web.socket.messaging.SubProtocolHandler;

public class SubProtocolWebSocketHandler
implements WebSocketHandler,
SubProtocolCapable,
MessageHandler,
SmartLifecycle,
ApplicationEventPublisherAware {
    private final Log logger = LogFactory.getLog(SubProtocolWebSocketHandler.class);
    private final MessageChannel clientInboundChannel;
    private final SubscribableChannel clientOutboundChannel;
    private final Map<String, SubProtocolHandler> protocolHandlers = new TreeMap<String, SubProtocolHandler>(String.CASE_INSENSITIVE_ORDER);
    private SubProtocolHandler defaultProtocolHandler;
    private final Map<String, WebSocketSession> sessions = new ConcurrentHashMap<String, WebSocketSession>();
    private int sendTimeLimit = 10000;
    private int sendBufferSizeLimit = 524288;
    private Object lifecycleMonitor = new Object();
    private volatile boolean running = false;
    private ApplicationEventPublisher eventPublisher;

    public SubProtocolWebSocketHandler(MessageChannel clientInboundChannel, SubscribableChannel clientOutboundChannel) {
        Assert.notNull((Object)clientInboundChannel, (String)"ClientInboundChannel must not be null");
        Assert.notNull((Object)clientOutboundChannel, (String)"ClientOutboundChannel must not be null");
        this.clientInboundChannel = clientInboundChannel;
        this.clientOutboundChannel = clientOutboundChannel;
    }

    public void setProtocolHandlers(List<SubProtocolHandler> protocolHandlers) {
        this.protocolHandlers.clear();
        for (SubProtocolHandler handler : protocolHandlers) {
            this.addProtocolHandler(handler);
        }
    }

    public List<SubProtocolHandler> getProtocolHandlers() {
        return new ArrayList<SubProtocolHandler>(this.protocolHandlers.values());
    }

    public void addProtocolHandler(SubProtocolHandler handler) {
        List<String> protocols = handler.getSupportedProtocols();
        if (CollectionUtils.isEmpty(protocols)) {
            this.logger.warn((Object)("No sub-protocols, ignoring handler " + handler));
            return;
        }
        for (String protocol : protocols) {
            SubProtocolHandler replaced = this.protocolHandlers.put(protocol, handler);
            if (replaced == null || replaced == handler) continue;
            throw new IllegalStateException("Failed to map handler " + handler + " to protocol '" + protocol + "', it is already mapped to handler " + replaced);
        }
        if (handler instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)handler).setApplicationEventPublisher(this.eventPublisher);
        }
    }

    public Map<String, SubProtocolHandler> getProtocolHandlerMap() {
        return this.protocolHandlers;
    }

    public void setDefaultProtocolHandler(SubProtocolHandler defaultProtocolHandler) {
        this.defaultProtocolHandler = defaultProtocolHandler;
        if (this.protocolHandlers.isEmpty()) {
            this.setProtocolHandlers(Arrays.asList(defaultProtocolHandler));
        }
    }

    public SubProtocolHandler getDefaultProtocolHandler() {
        return this.defaultProtocolHandler;
    }

    @Override
    public List<String> getSubProtocols() {
        return new ArrayList<String>(this.protocolHandlers.keySet());
    }

    public void setSendTimeLimit(int sendTimeLimit) {
        this.sendTimeLimit = sendTimeLimit;
    }

    public int getSendTimeLimit() {
        return this.sendTimeLimit;
    }

    public void setSendBufferSizeLimit(int sendBufferSizeLimit) {
        this.sendBufferSizeLimit = sendBufferSizeLimit;
    }

    public int getSendBufferSizeLimit() {
        return this.sendBufferSizeLimit;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientOutboundChannel.subscribe((MessageHandler)this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.clientOutboundChannel.unsubscribe((MessageHandler)this);
            for (WebSocketSession session : this.sessions.values()) {
                try {
                    session.close(CloseStatus.GOING_AWAY);
                }
                catch (Throwable t) {
                    this.logger.error((Object)("Failed to close session id '" + session.getId() + "': " + t.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        session = new ConcurrentWebSocketSessionDecorator(session, this.getSendTimeLimit(), this.getSendBufferSizeLimit());
        this.sessions.put(session.getId(), session);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Started WebSocket session=" + session.getId() + ", number of sessions=" + this.sessions.size()));
        }
        this.findProtocolHandler(session).afterSessionStarted(session, this.clientInboundChannel);
    }

    protected final SubProtocolHandler findProtocolHandler(WebSocketSession session) {
        SubProtocolHandler handler;
        String protocol = null;
        try {
            protocol = session.getAcceptedProtocol();
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Ignoring protocol in WebSocket session after failure to obtain it: " + ex.toString()));
        }
        if (!StringUtils.isEmpty((Object)protocol)) {
            handler = this.protocolHandlers.get(protocol);
            Assert.state((handler != null ? 1 : 0) != 0, (String)("No handler for sub-protocol '" + protocol + "', handlers=" + this.protocolHandlers));
        } else if (this.defaultProtocolHandler != null) {
            handler = this.defaultProtocolHandler;
        } else {
            HashSet<SubProtocolHandler> handlers = new HashSet<SubProtocolHandler>(this.protocolHandlers.values());
            if (handlers.size() == 1) {
                handler = (SubProtocolHandler)handlers.iterator().next();
            } else {
                throw new IllegalStateException("No sub-protocol was requested and a default sub-protocol handler was not configured");
            }
        }
        return handler;
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        this.findProtocolHandler(session).handleMessageFromClient(session, message, this.clientInboundChannel);
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        String sessionId = this.resolveSessionId(message);
        if (sessionId == null) {
            this.logger.error((Object)("sessionId not found in message " + message));
            return;
        }
        WebSocketSession session = this.sessions.get(sessionId);
        if (session == null) {
            this.logger.error((Object)("Session not found for session with id '" + sessionId + "', ignoring message " + message));
            return;
        }
        try {
            this.findProtocolHandler(session).handleMessageToClient(session, message);
        }
        catch (SessionLimitExceededException ex) {
            try {
                this.logger.error((Object)("Terminating session id '" + sessionId + "'"), (Throwable)ex);
                this.clearSession(session, ex.getStatus());
                session.close(ex.getStatus());
            }
            catch (Exception secondException) {
                this.logger.error((Object)("Exception terminating session id '" + sessionId + "'"), (Throwable)secondException);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to send message to client " + message), (Throwable)e);
        }
    }

    private String resolveSessionId(Message<?> message) {
        String sessionId;
        for (SubProtocolHandler handler : this.protocolHandlers.values()) {
            String sessionId2 = handler.resolveSessionId(message);
            if (sessionId2 == null) continue;
            return sessionId2;
        }
        if (this.defaultProtocolHandler != null && (sessionId = this.defaultProtocolHandler.resolveSessionId(message)) != null) {
            return sessionId;
        }
        return null;
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        this.clearSession(session, closeStatus);
    }

    private void clearSession(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        this.sessions.remove(session.getId());
        this.findProtocolHandler(session).afterSessionEnded(session, closeStatus, this.clientInboundChannel);
    }

    @Override
    public boolean supportsPartialMessages() {
        return false;
    }
}

