/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.result;

import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapResultHandler<K, V>
implements ResultHandler {
    private final Map<K, V> mappedResults;
    private final String mapKey;

    public DefaultMapResultHandler(String mapKey, ObjectFactory objectFactory) {
        this.mappedResults = objectFactory.create(Map.class);
        this.mapKey = mapKey;
    }

    @Override
    public void handleResult(ResultContext context) {
        Object value = context.getResultObject();
        MetaObject mo = MetaObject.forObject(value);
        Object key = mo.getValue(this.mapKey);
        this.mappedResults.put(key, value);
    }

    public Map<K, V> getMappedResults() {
        return this.mappedResults;
    }
}

