/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    private static final int MAX_ACCEPTABLE = 512;
    private static final int PADDING = 384;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException {
        int charOffset;
        int startOffset;
        Arrays.fill(this.counters, 0);
        this.setCounters(row);
        int nextStart = startOffset = this.findStartPattern();
        this.decodeRowResult.setLength(0);
        do {
            if ((charOffset = this.toNarrowWidePattern(nextStart)) == -1) {
                throw NotFoundException.getNotFoundInstance();
            }
            this.decodeRowResult.append((char)charOffset);
        } while ((this.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[charOffset])) && (nextStart += 8) < this.counterLength);
        int trailingWhitespace = this.counters[nextStart - 1];
        int lastPatternSize = 0;
        int i = -8;
        while (i < -1) {
            lastPatternSize += this.counters[nextStart + i];
            ++i;
        }
        if (nextStart < this.counterLength && trailingWhitespace < lastPatternSize / 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.validatePattern(startOffset);
        i = 0;
        while (i < this.decodeRowResult.length()) {
            this.decodeRowResult.setCharAt(i, ALPHABET[this.decodeRowResult.charAt(i)]);
            ++i;
        }
        char startchar = this.decodeRowResult.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, startchar)) {
            throw NotFoundException.getNotFoundInstance();
        }
        char endchar = this.decodeRowResult.charAt(this.decodeRowResult.length() - 1);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, endchar)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.decodeRowResult.length() <= 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.decodeRowResult.deleteCharAt(this.decodeRowResult.length() - 1);
        this.decodeRowResult.deleteCharAt(0);
        int runningCount = 0;
        int i2 = 0;
        while (i2 < startOffset) {
            runningCount += this.counters[i2];
            ++i2;
        }
        float left = runningCount;
        int i3 = startOffset;
        while (i3 < nextStart - 1) {
            runningCount += this.counters[i3];
            ++i3;
        }
        float right = runningCount;
        return new Result(this.decodeRowResult.toString(), null, new ResultPoint[]{new ResultPoint(left, rowNumber), new ResultPoint(right, rowNumber)}, BarcodeFormat.CODABAR);
    }

    void validatePattern(int start) throws NotFoundException {
        int[] sizes = new int[4];
        int[] counts = new int[4];
        int end = this.decodeRowResult.length() - 1;
        int pos = start;
        int i = 0;
        while (true) {
            int pattern = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(i)];
            int j = 6;
            while (j >= 0) {
                int category;
                int n = category = (j & 1) + (pattern & 1) * 2;
                sizes[n] = sizes[n] + this.counters[pos + j];
                int n2 = category;
                counts[n2] = counts[n2] + 1;
                pattern >>= 1;
                --j;
            }
            if (i >= end) break;
            pos += 8;
            ++i;
        }
        int[] maxes = new int[4];
        int[] mins = new int[4];
        int i2 = 0;
        while (i2 < 2) {
            mins[i2] = 0;
            mins[i2 + 2] = (sizes[i2] << 8) / counts[i2] + (sizes[i2 + 2] << 8) / counts[i2 + 2] >> 1;
            maxes[i2] = mins[i2 + 2];
            maxes[i2 + 2] = (sizes[i2 + 2] * 512 + 384) / counts[i2 + 2];
            ++i2;
        }
        pos = start;
        i2 = 0;
        while (true) {
            int pattern = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(i2)];
            int j = 6;
            while (j >= 0) {
                int size = this.counters[pos + j] << 8;
                int category = (j & 1) + (pattern & 1) * 2;
                if (size < mins[category] || size > maxes[category]) {
                    throw NotFoundException.getNotFoundInstance();
                }
                pattern >>= 1;
                --j;
            }
            if (i2 >= end) break;
            pos += 8;
            ++i2;
        }
    }

    private void setCounters(BitArray row) throws NotFoundException {
        int end;
        this.counterLength = 0;
        int i = row.getNextUnset(0);
        if (i >= (end = row.getSize())) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean isWhite = true;
        int count = 0;
        while (i < end) {
            if (row.get(i) ^ isWhite) {
                ++count;
            } else {
                this.counterAppend(count);
                count = 1;
                isWhite = !isWhite;
            }
            ++i;
        }
        this.counterAppend(count);
    }

    private void counterAppend(int e) {
        this.counters[this.counterLength] = e;
        ++this.counterLength;
        if (this.counterLength >= this.counters.length) {
            int[] temp = new int[this.counterLength * 2];
            System.arraycopy(this.counters, 0, temp, 0, this.counterLength);
            this.counters = temp;
        }
    }

    private int findStartPattern() throws NotFoundException {
        int i = 1;
        while (i < this.counterLength) {
            int charOffset = this.toNarrowWidePattern(i);
            if (charOffset != -1 && CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[charOffset])) {
                int patternSize = 0;
                int j = i;
                while (j < i + 7) {
                    patternSize += this.counters[j];
                    ++j;
                }
                if (i == 1 || this.counters[i - 1] >= patternSize / 2) {
                    return i;
                }
            }
            i += 2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] array, char key) {
        if (array != null) {
            char[] cArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c == key) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int position) {
        int end = position + 7;
        if (end >= this.counterLength) {
            return -1;
        }
        int[] theCounters = this.counters;
        int maxBar = 0;
        int minBar = Integer.MAX_VALUE;
        int j = position;
        while (j < end) {
            int currentCounter = theCounters[j];
            if (currentCounter < minBar) {
                minBar = currentCounter;
            }
            if (currentCounter > maxBar) {
                maxBar = currentCounter;
            }
            j += 2;
        }
        int thresholdBar = (minBar + maxBar) / 2;
        int maxSpace = 0;
        int minSpace = Integer.MAX_VALUE;
        int j2 = position + 1;
        while (j2 < end) {
            int currentCounter = theCounters[j2];
            if (currentCounter < minSpace) {
                minSpace = currentCounter;
            }
            if (currentCounter > maxSpace) {
                maxSpace = currentCounter;
            }
            j2 += 2;
        }
        int thresholdSpace = (minSpace + maxSpace) / 2;
        int bitmask = 128;
        int pattern = 0;
        int i = 0;
        while (i < 7) {
            int threshold = (i & 1) == 0 ? thresholdBar : thresholdSpace;
            bitmask >>= 1;
            if (theCounters[position + i] > threshold) {
                pattern |= bitmask;
            }
            ++i;
        }
        i = 0;
        while (i < CHARACTER_ENCODINGS.length) {
            if (CHARACTER_ENCODINGS[i] == pattern) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

