/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;

public class ExceptionWebSocketHandlerDecorator
extends WebSocketHandlerDecorator {
    private final Log logger = LogFactory.getLog(ExceptionWebSocketHandlerDecorator.class);

    public ExceptionWebSocketHandlerDecorator(WebSocketHandler delegate) {
        super(delegate);
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession session) {
        try {
            this.getDelegate().afterConnectionEstablished(session);
        }
        catch (Throwable ex) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, ex, this.logger);
        }
    }

    public static void tryCloseWithError(WebSocketSession session, Throwable exception, Log logger) {
        logger.error((Object)("Closing due to exception for " + session), exception);
        if (session.isOpen()) {
            try {
                session.close(CloseStatus.SERVER_ERROR);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) {
        try {
            this.getDelegate().handleMessage(session, message);
        }
        catch (Throwable ex) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, ex, this.logger);
        }
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) {
        try {
            this.getDelegate().handleTransportError(session, exception);
        }
        catch (Throwable ex) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(session, ex, this.logger);
        }
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
        try {
            this.getDelegate().afterConnectionClosed(session, closeStatus);
        }
        catch (Throwable t) {
            this.logger.error((Object)("Unhandled error for " + this), t);
        }
    }
}

