/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    static {
        int i = 0;
        while (i < PDF417Common.SYMBOL_TABLE.length) {
            int currentSymbol = PDF417Common.SYMBOL_TABLE[i];
            int currentBit = currentSymbol & 1;
            int j = 0;
            while (j < 8) {
                float size = 0.0f;
                while ((currentSymbol & 1) == currentBit) {
                    size += 1.0f;
                    currentSymbol >>= 1;
                }
                currentBit = currentSymbol & 1;
                PDF417CodewordDecoder.RATIOS_TABLE[i][8 - j - 1] = size / 17.0f;
                ++j;
            }
            ++i;
        }
    }

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] moduleBitCount) {
        int decodedValue = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(moduleBitCount));
        if (decodedValue != -1) {
            return decodedValue;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(moduleBitCount);
    }

    private static int[] sampleBitCounts(int[] moduleBitCount) {
        float bitCountSum = PDF417Common.getBitCountSum(moduleBitCount);
        int[] result = new int[8];
        int bitCountIndex = 0;
        int sumPreviousBits = 0;
        int i = 0;
        while (i < 17) {
            float sampleIndex = bitCountSum / 34.0f + (float)i * bitCountSum / 17.0f;
            if ((float)(sumPreviousBits + moduleBitCount[bitCountIndex]) <= sampleIndex) {
                sumPreviousBits += moduleBitCount[bitCountIndex];
            }
            int n = ++bitCountIndex;
            result[n] = result[n] + 1;
            ++i;
        }
        return result;
    }

    private static int getDecodedCodewordValue(int[] moduleBitCount) {
        int decodedValue = PDF417CodewordDecoder.getBitValue(moduleBitCount);
        return PDF417Common.getCodeword(decodedValue) == -1 ? -1 : decodedValue;
    }

    private static int getBitValue(int[] moduleBitCount) {
        long result = 0L;
        int i = 0;
        while (i < moduleBitCount.length) {
            int bit = 0;
            while (bit < moduleBitCount[i]) {
                result = result << 1 | (long)(i % 2 == 0 ? 1 : 0);
                ++bit;
            }
            ++i;
        }
        return (int)result;
    }

    private static int getClosestDecodedValue(int[] moduleBitCount) {
        int bitCountSum = PDF417Common.getBitCountSum(moduleBitCount);
        float[] bitCountRatios = new float[8];
        int i = 0;
        while (i < bitCountRatios.length) {
            bitCountRatios[i] = (float)moduleBitCount[i] / (float)bitCountSum;
            ++i;
        }
        float bestMatchError = Float.MAX_VALUE;
        int bestMatch = -1;
        int j = 0;
        while (j < RATIOS_TABLE.length) {
            float error = 0.0f;
            int k = 0;
            while (k < 8) {
                float diff = RATIOS_TABLE[j][k] - bitCountRatios[k];
                error += diff * diff;
                ++k;
            }
            if (error < bestMatchError) {
                bestMatchError = error;
                bestMatch = PDF417Common.SYMBOL_TABLE[j];
            }
            ++j;
        }
        return bestMatch;
    }
}

