/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurationSupport;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;

@Configuration
public class DelegatingWebSocketMessageBrokerConfiguration
extends WebSocketMessageBrokerConfigurationSupport {
    private List<WebSocketMessageBrokerConfigurer> configurers = new ArrayList<WebSocketMessageBrokerConfigurer>();

    @Autowired(required=false)
    public void setConfigurers(List<WebSocketMessageBrokerConfigurer> configurers) {
        if (!CollectionUtils.isEmpty(configurers)) {
            this.configurers.addAll(configurers);
        }
    }

    @Override
    protected void registerStompEndpoints(StompEndpointRegistry registry) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.registerStompEndpoints(registry);
        }
    }

    @Override
    protected void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.configureWebSocketTransport(registration);
        }
    }

    protected void configureClientInboundChannel(ChannelRegistration registration) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.configureClientInboundChannel(registration);
        }
    }

    protected void configureClientOutboundChannel(ChannelRegistration registration) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.configureClientOutboundChannel(registration);
        }
    }

    protected boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        boolean registerDefaults = true;
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            if (c.configureMessageConverters(messageConverters)) continue;
            registerDefaults = false;
        }
        return registerDefaults;
    }

    protected void configureMessageBroker(MessageBrokerRegistry registry) {
        for (WebSocketMessageBrokerConfigurer c : this.configurers) {
            c.configureMessageBroker(registry);
        }
    }
}

