/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.cluster;

import com.taobao.api.ApiException;
import com.taobao.api.TaobaoClient;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.cluster.HttpdnsGetRequest;
import com.taobao.api.internal.cluster.HttpdnsGetResponse;
import com.taobao.api.internal.cluster.Weightable;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClusterManager {
    private static final Log log = LogFactory.getLog(ClusterManager.class);
    private static final Random random = new Random();
    private static final Object initLock = new Object();
    private static volatile DnsConfig dnsConfig = null;
    private static volatile Thread refreshThread = null;

    public static <T extends Weightable> T getElementByWeight(List<T> list) {
        Weightable selected = null;
        double totalWeight = 0.0;
        for (Weightable element : list) {
            double r = random.nextDouble() * (element.getWeight() + totalWeight);
            if (r >= totalWeight) {
                selected = element;
            }
            totalWeight += element.getWeight();
        }
        return (T)selected;
    }

    public static DnsConfig GetDnsConfigFromCache() {
        return dnsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initRefreshThread(final TaobaoClient client) throws ApiException {
        if (refreshThread == null) {
            Object object = initLock;
            synchronized (object) {
                if (refreshThread == null) {
                    try {
                        dnsConfig = ClusterManager.getDnsConfigFromTop(client);
                    }
                    catch (ApiException e) {
                        if ("22".equals(e.getErrCode())) {
                            return;
                        }
                        throw e;
                    }
                    refreshThread = new Thread(new Runnable(){

                        public void run() {
                            while (true) {
                                try {
                                    while (true) {
                                        ClusterManager.sleep((long)(dnsConfig.getRefreshInterval() * 60) * 1000L);
                                        dnsConfig = ClusterManager.getDnsConfigFromTop(client);
                                    }
                                }
                                catch (Exception e) {
                                    log.error((Object)"refresh http dns config from top fail", (Throwable)e);
                                    ClusterManager.sleep(3000L);
                                    continue;
                                }
                                break;
                            }
                        }
                    });
                    refreshThread.setDaemon(true);
                    refreshThread.setName("HTTP_DNS_REFRESH_THREAD");
                    refreshThread.start();
                }
            }
        }
    }

    private static DnsConfig getDnsConfigFromTop(TaobaoClient client) throws ApiException {
        HttpdnsGetRequest req = new HttpdnsGetRequest();
        HttpdnsGetResponse rsp = client.execute(req);
        if (rsp.isSuccess()) {
            return DnsConfig.parse(rsp.getResult());
        }
        throw new ApiException(rsp.getErrorCode(), rsp.getMsg());
    }

    private static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

