/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ObjectUtils;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PingMessage;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.adapter.AbstractWebSocketSession;

public class JettyWebSocketSession
extends AbstractWebSocketSession<Session> {
    private HttpHeaders headers;
    private List<WebSocketExtension> extensions;
    private Principal user;
    private String acceptedProtocol;

    public JettyWebSocketSession(Map<String, Object> attributes) {
        this(attributes, null);
    }

    public JettyWebSocketSession(Map<String, Object> attributes, Principal user) {
        super(attributes);
        this.user = user;
    }

    @Override
    public String getId() {
        this.checkNativeSessionInitialized();
        return ObjectUtils.getIdentityHexString(this.getNativeSession());
    }

    @Override
    public URI getUri() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getUpgradeRequest().getRequestURI();
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        this.checkNativeSessionInitialized();
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            this.headers.putAll(((Session)this.getNativeSession()).getUpgradeRequest().getHeaders());
            this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.headers);
        }
        return this.headers;
    }

    @Override
    public Principal getPrincipal() {
        if (this.user != null) {
            return this.user;
        }
        this.checkNativeSessionInitialized();
        return this.isOpen() ? ((Session)this.getNativeSession()).getUpgradeRequest().getUserPrincipal() : null;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getRemoteAddress();
    }

    @Override
    public String getAcceptedProtocol() {
        this.checkNativeSessionInitialized();
        return this.acceptedProtocol;
    }

    @Override
    public void setTextMessageSizeLimit(int messageSizeLimit) {
        this.checkNativeSessionInitialized();
        ((Session)this.getNativeSession()).getPolicy().setMaxTextMessageSize(messageSizeLimit);
    }

    @Override
    public int getTextMessageSizeLimit() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getPolicy().getMaxTextMessageSize();
    }

    @Override
    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
        this.checkNativeSessionInitialized();
        ((Session)this.getNativeSession()).getPolicy().setMaxBinaryMessageSize(messageSizeLimit);
    }

    @Override
    public int getBinaryMessageSizeLimit() {
        this.checkNativeSessionInitialized();
        return ((Session)this.getNativeSession()).getPolicy().getMaxBinaryMessageSize();
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        this.checkNativeSessionInitialized();
        if (this.extensions == null) {
            List source = ((Session)this.getNativeSession()).getUpgradeResponse().getExtensions();
            this.extensions = new ArrayList<WebSocketExtension>(source.size());
            for (ExtensionConfig e : source) {
                this.extensions.add(new WebSocketExtension(e.getName(), e.getParameters()));
            }
        }
        return this.extensions;
    }

    @Override
    public boolean isOpen() {
        return this.getNativeSession() != null && ((Session)this.getNativeSession()).isOpen();
    }

    @Override
    public void initializeNativeSession(Session session) {
        super.initializeNativeSession(session);
        if (this.user == null) {
            this.user = session.getUpgradeRequest().getUserPrincipal();
        }
        this.acceptedProtocol = session.getUpgradeResponse().getAcceptedSubProtocol();
    }

    @Override
    protected void sendTextMessage(TextMessage message) throws IOException {
        ((Session)this.getNativeSession()).getRemote().sendString((String)message.getPayload());
    }

    @Override
    protected void sendBinaryMessage(BinaryMessage message) throws IOException {
        ((Session)this.getNativeSession()).getRemote().sendBytes((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPingMessage(PingMessage message) throws IOException {
        ((Session)this.getNativeSession()).getRemote().sendPing((ByteBuffer)message.getPayload());
    }

    @Override
    protected void sendPongMessage(PongMessage message) throws IOException {
        ((Session)this.getNativeSession()).getRemote().sendPong((ByteBuffer)message.getPayload());
    }

    @Override
    protected void closeInternal(CloseStatus status) throws IOException {
        ((Session)this.getNativeSession()).close(status.getCode(), status.getReason());
    }
}

