/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class LongSerializer
implements ObjectSerializer {
    public static LongSerializer instance = new LongSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        long value = (Long)object;
        out.writeLong(value);
        if (serializer.isEnabled(SerializerFeature.WriteClassName) && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE && fieldType != Long.class) {
            out.write('L');
        }
    }
}

