/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

public class JDBCInfo {
    private static final String JDBC40_CLASSNAME = "java.sql.RowId";
    private static final String JDBC30_CLASSNAME = "java.sql.Savepoint";
    private static final String JDBC21_CLASSNAME = "java.sql.Struct";
    private static final String JDBC12_CLASSNAME = "java.sql.Driver";
    private static int verMajor = 0;
    private static int verMinor = 0;
    private static String verString = null;

    private JDBCInfo() {
    }

    public static synchronized String getVersionString() {
        if (verString != null) {
            return verString;
        }
        JDBCInfo.findVersion();
        return verString;
    }

    public static synchronized int getMajorVersion() {
        if (verMajor > 0) {
            return verMajor;
        }
        JDBCInfo.findVersion();
        return verMajor;
    }

    public static synchronized int getMinorVersion() {
        if (verMajor > 0) {
            return verMinor;
        }
        JDBCInfo.findVersion();
        return verMinor;
    }

    private static synchronized void findVersion() {
        try {
            Class.forName(JDBC40_CLASSNAME);
            verMajor = 4;
        }
        catch (ClassNotFoundException cnfx) {
            // empty catch block
        }
        try {
            if (verMajor == 0) {
                Class.forName(JDBC30_CLASSNAME);
                verMajor = 3;
            }
        }
        catch (ClassNotFoundException cnfx) {
            // empty catch block
        }
        try {
            if (verMajor == 0) {
                Class.forName(JDBC21_CLASSNAME);
                verMajor = 2;
                verMinor = 1;
            }
        }
        catch (ClassNotFoundException cnfx) {
            // empty catch block
        }
        try {
            if (verMajor == 0) {
                Class.forName(JDBC12_CLASSNAME);
                verMajor = 1;
                verMinor = 2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        verString = verMajor + "." + verMinor;
    }

    public static void main(String[] args) {
        System.out.println();
        System.out.println("Operating System: " + System.getProperty("os.name"));
        System.out.println("OS Achitecture  : " + System.getProperty("os.arch"));
        System.out.println("OS Version      : " + System.getProperty("os.version"));
        System.out.println("Java Version    : " + System.getProperty("java.version"));
        System.out.println("Java Vendor     : " + System.getProperty("java.vendor"));
        System.out.println("Java VM Name    : " + System.getProperty("java.vm.name"));
        System.out.println();
        System.out.println("Your JVM supports JDBC " + JDBCInfo.getVersionString());
    }
}

