/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;

public class SynchronizedCache
implements Cache {
    private Cache delegate;

    public SynchronizedCache(Cache delegate) {
        this.delegate = delegate;
    }

    public String getId() {
        return this.delegate.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.acquireReadLock();
        try {
            int n = this.delegate.getSize();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Object key, Object object) {
        this.acquireWriteLock();
        try {
            this.delegate.putObject(key, object);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object key) {
        this.acquireReadLock();
        try {
            Object object = this.delegate.getObject(key);
            return object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeObject(Object key) {
        this.acquireWriteLock();
        try {
            Object object = this.delegate.removeObject(key);
            return object;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.acquireWriteLock();
        try {
            this.delegate.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    private void acquireReadLock() {
        this.getReadWriteLock().readLock().lock();
    }

    private void releaseReadLock() {
        this.getReadWriteLock().readLock().unlock();
    }

    private void acquireWriteLock() {
        this.getReadWriteLock().writeLock().lock();
    }

    private void releaseWriteLock() {
        this.getReadWriteLock().writeLock().unlock();
    }
}

