/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tmc;

import com.taobao.api.internal.tmc.Message;
import com.taobao.api.internal.tmc.MessageKind;
import com.taobao.api.internal.tmc.MessageStatus;
import com.taobao.api.internal.tmc.TmcClient;
import com.taobao.api.internal.toplink.LinkException;
import com.taobao.api.internal.toplink.endpoint.EndpointBaseContext;
import com.taobao.api.internal.toplink.endpoint.EndpointContext;
import com.taobao.api.internal.toplink.endpoint.MessageHandler;
import com.taobao.api.internal.toplink.util.GZIPHelper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TmcHandler
implements MessageHandler {
    private static final Log log = LogFactory.getLog(TmcClient.class);
    protected TmcClient tmcClient;
    protected volatile boolean stopped;

    public TmcHandler(TmcClient tmcClient) {
        this.tmcClient = tmcClient;
    }

    @Override
    public final void onAckMessage(EndpointBaseContext context) {
    }

    @Override
    public void onMessage(EndpointContext context) throws Exception {
        Map<String, Object> rawMsg = context.getMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onMessage from %s: %s", context.getMessageFrom(), rawMsg));
        }
        this.handleMessage(this.parse(rawMsg), false);
    }

    public void close() {
        this.stopped = true;
    }

    public void handleConfirm(Message message) {
        if (this.tmcClient.getConfirmThreadPool() != null) {
            this.tmcClient.getConfirmThreadPool().submit(new ConfirmWorker(0, message){

                public void run() {
                    try {
                        TmcHandler.this.confirm(this.getMessage().getRaw());
                    }
                    catch (LinkException e) {
                        log.warn((Object)String.format("confirm message fail: %s", this.getMessage().getRaw()), (Throwable)e);
                        TmcHandler.this.holdTheThread();
                        if (this.getRetry() < 3) {
                            this.incrRetry();
                            TmcHandler.this.tmcClient.getConfirmThreadPool().submit(this);
                        }
                        log.warn((Object)String.format("confirm message fail 3 times,discard it : %s", this.getMessage().getRaw()));
                    }
                }
            });
        }
    }

    private void holdTheThread() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void retryMessage(final Message message) throws RejectedExecutionException {
        this.tmcClient.getThreadPool().submit(new Runnable(){

            public void run() {
                MessageStatus status = new MessageStatus();
                try {
                    TmcHandler.this.tmcClient.getMessageHandler().onMessage(message, status);
                }
                catch (Exception e) {
                    log.error((Object)String.format("handle message fail: %s", message.getRaw()), (Throwable)e);
                    return;
                }
                if (!TmcHandler.this.tmcClient.isUseDefaultConfirm()) {
                    return;
                }
                if (!status.isFail()) {
                    try {
                        TmcHandler.this.confirm(message.getRaw());
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("confirm message fail: %s", message.getRaw()), (Throwable)e);
                    }
                }
            }
        });
    }

    public void handleMessage(final Message message, final boolean ignore) {
        while (!this.stopped) {
            try {
                this.tmcClient.getThreadPool().submit(new Runnable(){

                    public void run() {
                        MessageStatus status = new MessageStatus();
                        if (!ignore) {
                            try {
                                TmcHandler.this.tmcClient.getMessageHandler().onMessage(message, status);
                            }
                            catch (Exception e) {
                                log.error((Object)String.format("handle message fail: %s", message.getRaw()), (Throwable)e);
                                return;
                            }
                        }
                        if (!TmcHandler.this.tmcClient.isUseDefaultConfirm()) {
                            status.fail();
                        }
                        if (ignore || !status.isFail()) {
                            try {
                                TmcHandler.this.confirm(message.getRaw());
                            }
                            catch (Exception e) {
                                log.warn((Object)String.format("confirm message fail: %s", message.getRaw()), (Throwable)e);
                            }
                        }
                    }
                });
                break;
            }
            catch (RejectedExecutionException ree) {
                log.warn((Object)String.format("all tmc worker threads are currently busy, waiting 50 ms, appkey:%s-group:%s", this.tmcClient.getAppKey(), this.tmcClient.getGroupName()));
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void confirm(Map<String, Object> message) throws LinkException {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("__kind", MessageKind.Confirm);
        msg.put("id", message.get("id"));
        this.tmcClient.getClient().send(msg);
    }

    protected Message parse(Map<String, Object> raw) throws IOException {
        Object content;
        Message msg = new Message();
        msg.setRaw(raw);
        msg.setId((Long)raw.get("id"));
        msg.setTopic((String)raw.get("topic"));
        msg.setPubAppKey((String)raw.get("publisher"));
        msg.setUserId((Long)raw.get("userid"));
        msg.setUserNick((String)raw.get("nick"));
        msg.setPubTime((Date)raw.get("time"));
        Object time = raw.get("outtime");
        if (time != null) {
            msg.setOutgoingTime((Date)time);
        }
        if ((content = raw.get("content")) instanceof String) {
            msg.setContent((String)content);
        } else if (content instanceof byte[]) {
            msg.setContent(new String(GZIPHelper.unzip((byte[])content), "UTF-8"));
        }
        return msg;
    }

    public abstract class ConfirmWorker
    implements Runnable {
        private int retry;
        private final Message message;

        public ConfirmWorker(int retry, Message message) {
            this.retry = retry;
            this.message = message;
        }

        public void incrRetry() {
            ++this.retry;
        }

        public int getRetry() {
            return this.retry;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

