/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging;

import java.lang.reflect.Constructor;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogFactory {
    public static final String GLOBAL_LOGGER_NAME = "global";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> aClass) {
        return LogFactory.getLog(aClass.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.slf4j.Slf4jImpl");
    }

    public static synchronized void useCommonsLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.commons.JakartaCommonsLoggingImpl");
    }

    public static synchronized void useLog4JLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.log4j.Log4jImpl");
    }

    public static synchronized void useJdkLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.jdk14.Jdk14LoggingImpl");
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.stdout.StdOutImpl");
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation("org.apache.ibatis.logging.nologging.NoLoggingImpl");
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(String implClassName) {
        try {
            Class<?> implClass = Resources.classForName(implClassName);
            Constructor<?> candidate = implClass.getConstructor(String.class);
            Log log = (Log)candidate.newInstance(LogFactory.class.getName());
            log.debug("Logging initialized using '" + implClassName + "' adapter.");
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useSlf4jLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useCommonsLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useLog4JLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useJdkLogging();
            }
        });
        LogFactory.tryImplementation(new Runnable(){

            public void run() {
                LogFactory.useNoLogging();
            }
        });
    }
}

