/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.theme;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.web.util.WebUtils;

public class SessionThemeResolver
extends AbstractThemeResolver {
    public static final String THEME_SESSION_ATTRIBUTE_NAME = String.valueOf(SessionThemeResolver.class.getName()) + ".THEME";

    public String resolveThemeName(HttpServletRequest request) {
        String theme = (String)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)THEME_SESSION_ATTRIBUTE_NAME);
        return theme != null ? theme : this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)THEME_SESSION_ATTRIBUTE_NAME, (Object)themeName);
    }
}

