/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheFactoryBean
implements FactoryBean<Ehcache>,
BeanNameAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private String cacheName;
    private int maxElementsInMemory = 10000;
    private int maxElementsOnDisk = 10000000;
    private MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = MemoryStoreEvictionPolicy.LRU;
    private boolean overflowToDisk = true;
    private boolean eternal = false;
    private int timeToLive = 120;
    private int timeToIdle = 120;
    private boolean diskPersistent = false;
    private int diskExpiryThreadIntervalSeconds = 120;
    private int diskSpoolBufferSize = 0;
    private boolean clearOnFlush = true;
    private boolean blocking = false;
    private CacheEntryFactory cacheEntryFactory;
    private BootstrapCacheLoader bootstrapCacheLoader;
    private Set<CacheEventListener> cacheEventListeners;
    private boolean statisticsEnabled = false;
    private boolean sampledStatisticsEnabled = false;
    private boolean disabled = false;
    private String beanName;
    private Ehcache cache;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.maxElementsOnDisk = maxElementsOnDisk;
    }

    public void setMemoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        Assert.notNull((Object)memoryStoreEvictionPolicy, (String)"memoryStoreEvictionPolicy must not be null");
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public void setOverflowToDisk(boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public void setEternal(boolean eternal) {
        this.eternal = eternal;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToIdle(int timeToIdle) {
        this.timeToIdle = timeToIdle;
    }

    public void setDiskPersistent(boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public void setDiskSpoolBufferSize(int diskSpoolBufferSize) {
        this.diskSpoolBufferSize = diskSpoolBufferSize;
    }

    public void setClearOnFlush(boolean clearOnFlush) {
        this.clearOnFlush = clearOnFlush;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setCacheEntryFactory(CacheEntryFactory cacheEntryFactory) {
        this.cacheEntryFactory = cacheEntryFactory;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) {
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setCacheEventListeners(Set<CacheEventListener> cacheEventListeners) {
        this.cacheEventListeners = cacheEventListeners;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public void setSampledStatisticsEnabled(boolean sampledStatisticsEnabled) {
        this.sampledStatisticsEnabled = sampledStatisticsEnabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws CacheException, IOException {
        Cache rawCache;
        if (this.cacheManager == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using default EHCache CacheManager for cache region '" + this.cacheName + "'"));
            }
            this.cacheManager = CacheManager.getInstance();
        }
        if (this.cacheName == null) {
            this.cacheName = this.beanName;
        }
        if (this.cacheManager.cacheExists(this.cacheName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using existing EHCache cache region '" + this.cacheName + "'"));
            }
            rawCache = this.cacheManager.getEhcache(this.cacheName);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating new EHCache cache region '" + this.cacheName + "'"));
            }
            rawCache = this.createCache();
            this.cacheManager.addCache((Ehcache)rawCache);
        }
        Ehcache decoratedCache = this.decorateCache((Ehcache)rawCache);
        if (decoratedCache != rawCache) {
            this.cacheManager.replaceCacheWithDecoratedCache((Ehcache)rawCache, decoratedCache);
        }
        this.cache = decoratedCache;
    }

    protected Cache createCache() {
        Cache cache;
        Cache cache2 = cache = !this.clearOnFlush ? new Cache(this.cacheName, this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, null, this.eternal, (long)this.timeToLive, (long)this.timeToIdle, this.diskPersistent, (long)this.diskExpiryThreadIntervalSeconds, null, this.bootstrapCacheLoader, this.maxElementsOnDisk, this.diskSpoolBufferSize, this.clearOnFlush) : new Cache(this.cacheName, this.maxElementsInMemory, this.memoryStoreEvictionPolicy, this.overflowToDisk, null, this.eternal, (long)this.timeToLive, (long)this.timeToIdle, this.diskPersistent, (long)this.diskExpiryThreadIntervalSeconds, null, this.bootstrapCacheLoader, this.maxElementsOnDisk, this.diskSpoolBufferSize);
        if (this.cacheEventListeners != null) {
            for (CacheEventListener listener : this.cacheEventListeners) {
                cache.getCacheEventNotificationService().registerListener(listener);
            }
        }
        if (this.statisticsEnabled) {
            cache.setStatisticsEnabled(true);
        }
        if (this.sampledStatisticsEnabled) {
            cache.setSampledStatisticsEnabled(true);
        }
        if (this.disabled) {
            cache.setDisabled(true);
        }
        return cache;
    }

    protected Ehcache decorateCache(Ehcache cache) {
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return new UpdatingSelfPopulatingCache(cache, (UpdatingCacheEntryFactory)this.cacheEntryFactory);
            }
            return new SelfPopulatingCache(cache, this.cacheEntryFactory);
        }
        if (this.blocking) {
            return new BlockingCache(cache);
        }
        return cache;
    }

    public Ehcache getObject() {
        return this.cache;
    }

    public Class<? extends Ehcache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Ehcache.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

