/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import org.apache.ibatis.ognl.ElementsAccessor;
import org.apache.ibatis.ognl.NumericTypes;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlRuntime;

public abstract class OgnlOps
implements NumericTypes {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    public static int compareWithConversion(Object v1, Object v2) {
        return OgnlOps.compareWithConversion(v1, v2, false);
    }

    public static int compareWithConversion(Object v1, Object v2, boolean equals) {
        int result;
        if (v1 == v2) {
            result = 0;
        } else {
            int t1 = OgnlOps.getNumericType(v1);
            int t2 = OgnlOps.getNumericType(v2);
            int type = OgnlOps.getNumericType(t1, t2, true);
            switch (type) {
                case 6: {
                    result = OgnlOps.bigIntValue(v1).compareTo(OgnlOps.bigIntValue(v2));
                    break;
                }
                case 9: {
                    result = OgnlOps.bigDecValue(v1).compareTo(OgnlOps.bigDecValue(v2));
                    break;
                }
                case 10: {
                    if (t1 == 10 && t2 == 10) {
                        if (v1 == null || v2 == null) {
                            boolean result2 = v1 != v2;
                        } else {
                            if (v1.getClass().isAssignableFrom(v2.getClass()) || v2.getClass().isAssignableFrom(v1.getClass())) {
                                if (v1 instanceof Comparable) {
                                    result = ((Comparable)v1).compareTo(v2);
                                    break;
                                }
                                if (equals) {
                                    result = v1.equals(v2) ? 0 : 1;
                                    break;
                                }
                            }
                            if (equals) {
                                result = 1;
                                break;
                            }
                            throw new IllegalArgumentException("invalid comparison: " + v1.getClass().getName() + " and " + v2.getClass().getName());
                        }
                    }
                }
                case 7: 
                case 8: {
                    double dv1 = OgnlOps.doubleValue(v1);
                    double dv2 = OgnlOps.doubleValue(v2);
                    return dv1 == dv2 ? 0 : (dv1 < dv2 ? -1 : 1);
                }
                default: {
                    long lv1 = OgnlOps.longValue(v1);
                    long lv2 = OgnlOps.longValue(v2);
                    return lv1 == lv2 ? 0 : (lv1 < lv2 ? -1 : 1);
                }
            }
        }
        return result;
    }

    public static boolean isEqual(Object object1, Object object2) {
        boolean result = false;
        if (object1 == object2) {
            result = true;
        } else if (object1 != null && object2 != null) {
            if (object1.getClass().isArray() && object2.getClass().isArray() && object2.getClass() == object1.getClass()) {
                boolean bl = result = Array.getLength(object1) == Array.getLength(object2);
                if (result) {
                    int i = 0;
                    int icount = Array.getLength(object1);
                    while (result && i < icount) {
                        result = OgnlOps.isEqual(Array.get(object1, i), Array.get(object2, i));
                        ++i;
                    }
                }
            } else if (object1 != null && object2 != null) {
                result = OgnlOps.compareWithConversion(object1, object2, true) == 0 || object1.equals(object2);
            }
        }
        return result;
    }

    public static boolean booleanValue(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> c = value.getClass();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz) {
            return (Boolean)value;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz2) {
            return ((Character)value).charValue() != '\u0000';
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    public static long longValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0L;
        }
        Class<?> c = value.getClass();
        Class<?> clazz = c.getSuperclass();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return ((Number)value).longValue();
        }
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz3) {
            return (Boolean)value != false ? 1 : 0;
        }
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz4) {
            return ((Character)value).charValue();
        }
        return Long.parseLong(OgnlOps.stringValue(value, true));
    }

    public static double doubleValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0.0;
        }
        Class<?> c = value.getClass();
        Class<?> clazz = c.getSuperclass();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return ((Number)value).doubleValue();
        }
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz3) {
            return (Boolean)value != false ? 1 : 0;
        }
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz4) {
            return ((Character)value).charValue();
        }
        String s = OgnlOps.stringValue(value, true);
        return s.length() == 0 ? 0.0 : Double.parseDouble(s);
    }

    public static BigInteger bigIntValue(Object value) throws NumberFormatException {
        if (value == null) {
            return BigInteger.valueOf(0L);
        }
        Class<?> c = value.getClass();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz) {
            return (BigInteger)value;
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz2) {
            return ((BigDecimal)value).toBigInteger();
        }
        Class<?> clazz3 = c.getSuperclass();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3 == clazz4) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz5) {
            return BigInteger.valueOf((Boolean)value != false ? 1 : 0);
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz6) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        return new BigInteger(OgnlOps.stringValue(value, true));
    }

    public static BigDecimal bigDecValue(Object value) throws NumberFormatException {
        if (value == null) {
            return BigDecimal.valueOf(0L);
        }
        Class<?> c = value.getClass();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz) {
            return (BigDecimal)value;
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz2) {
            return new BigDecimal((BigInteger)value);
        }
        Class<?> clazz3 = c.getSuperclass();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3 == clazz4) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz5) {
            return BigDecimal.valueOf((Boolean)value != false ? 1 : 0);
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz6) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        return new BigDecimal(OgnlOps.stringValue(value, true));
    }

    public static String stringValue(Object value, boolean trim) {
        String result;
        if (value == null) {
            result = OgnlRuntime.NULL_STRING;
        } else {
            result = value.toString();
            if (trim) {
                result = result.trim();
            }
        }
        return result;
    }

    public static String stringValue(Object value) {
        return OgnlOps.stringValue(value, false);
    }

    public static int getNumericType(Object value) {
        int result = 10;
        if (value != null) {
            Class<?> c = value.getClass();
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz) {
                return 4;
            }
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz2) {
                return 8;
            }
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz3) {
                return 0;
            }
            Class<?> clazz4 = class$7;
            if (clazz4 == null) {
                try {
                    clazz4 = class$7 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz4) {
                return 1;
            }
            Class<?> clazz5 = class$1;
            if (clazz5 == null) {
                try {
                    clazz5 = class$1 = Class.forName("java.lang.Character");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz5) {
                return 2;
            }
            Class<?> clazz6 = class$8;
            if (clazz6 == null) {
                try {
                    clazz6 = class$8 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz6) {
                return 3;
            }
            Class<?> clazz7 = class$9;
            if (clazz7 == null) {
                try {
                    clazz7 = class$9 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz7) {
                return 5;
            }
            Class<?> clazz8 = class$10;
            if (clazz8 == null) {
                try {
                    clazz8 = class$10 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz8) {
                return 7;
            }
            Class<?> clazz9 = class$3;
            if (clazz9 == null) {
                try {
                    clazz9 = class$3 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz9) {
                return 6;
            }
            Class<?> clazz10 = class$4;
            if (clazz10 == null) {
                try {
                    clazz10 = class$4 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz10) {
                return 9;
            }
        }
        return 10;
    }

    public static Object convertValue(Object value, Class toType) {
        Object result = null;
        if (value != null) {
            if (value.getClass().isArray() && toType.isArray()) {
                Class<?> componentType = toType.getComponentType();
                result = Array.newInstance(componentType, Array.getLength(value));
                int i = 0;
                int icount = Array.getLength(value);
                while (i < icount) {
                    Array.set(result, i, OgnlOps.convertValue(Array.get(value, i), componentType));
                    ++i;
                }
            } else {
                Class<?> clazz;
                Class<?> clazz2;
                Class<?> clazz3;
                Class<?> clazz4;
                Class<?> clazz5;
                Class<?> clazz6;
                Class<?> clazz7;
                Class<?> clazz8;
                Class<?> clazz9;
                Class<?> clazz10;
                Class<?> clazz11 = class$5;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz11 || toType == Integer.TYPE) {
                    result = new Integer((int)OgnlOps.longValue(value));
                }
                if ((clazz10 = class$6) == null) {
                    try {
                        clazz10 = class$6 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz10 || toType == Double.TYPE) {
                    result = new Double(OgnlOps.doubleValue(value));
                }
                if ((clazz9 = class$0) == null) {
                    try {
                        clazz9 = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz9 || toType == Boolean.TYPE) {
                    result = OgnlOps.booleanValue(value) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ((clazz8 = class$7) == null) {
                    try {
                        clazz8 = class$7 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz8 || toType == Byte.TYPE) {
                    result = new Byte((byte)OgnlOps.longValue(value));
                }
                if ((clazz7 = class$1) == null) {
                    try {
                        clazz7 = class$1 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz7 || toType == Character.TYPE) {
                    result = new Character((char)OgnlOps.longValue(value));
                }
                if ((clazz6 = class$8) == null) {
                    try {
                        clazz6 = class$8 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz6 || toType == Short.TYPE) {
                    result = new Short((short)OgnlOps.longValue(value));
                }
                if ((clazz5 = class$9) == null) {
                    try {
                        clazz5 = class$9 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz5 || toType == Long.TYPE) {
                    result = new Long(OgnlOps.longValue(value));
                }
                if ((clazz4 = class$10) == null) {
                    try {
                        clazz4 = class$10 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz4 || toType == Float.TYPE) {
                    result = new Float(OgnlOps.doubleValue(value));
                }
                if ((clazz3 = class$3) == null) {
                    try {
                        clazz3 = class$3 = Class.forName("java.math.BigInteger");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz3) {
                    result = OgnlOps.bigIntValue(value);
                }
                if ((clazz2 = class$4) == null) {
                    try {
                        clazz2 = class$4 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz2) {
                    result = OgnlOps.bigDecValue(value);
                }
                if ((clazz = class$11) == null) {
                    try {
                        clazz = class$11 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (toType == clazz) {
                    result = OgnlOps.stringValue(value);
                }
            }
        } else if (toType.isPrimitive()) {
            result = OgnlRuntime.getPrimitiveDefaultValue(toType);
        }
        return result;
    }

    public static int getNumericType(Object v1, Object v2) {
        return OgnlOps.getNumericType(v1, v2, false);
    }

    public static int getNumericType(int t1, int t2, boolean canBeNonNumeric) {
        if (t1 == t2) {
            return t1;
        }
        if (canBeNonNumeric && (t1 == 10 || t2 == 10 || t1 == 2 || t2 == 2)) {
            return 10;
        }
        if (t1 == 10) {
            t1 = 8;
        }
        if (t2 == 10) {
            t2 = 8;
        }
        if (t1 >= 7) {
            if (t2 >= 7) {
                return Math.max(t1, t2);
            }
            if (t2 < 4) {
                return t1;
            }
            if (t2 == 6) {
                return 9;
            }
            return Math.max(8, t1);
        }
        if (t2 >= 7) {
            if (t1 < 4) {
                return t2;
            }
            if (t1 == 6) {
                return 9;
            }
            return Math.max(8, t2);
        }
        return Math.max(t1, t2);
    }

    public static int getNumericType(Object v1, Object v2, boolean canBeNonNumeric) {
        return OgnlOps.getNumericType(OgnlOps.getNumericType(v1), OgnlOps.getNumericType(v2), canBeNonNumeric);
    }

    public static Number newInteger(int type, long value) {
        switch (type) {
            case 0: 
            case 2: 
            case 4: {
                return new Integer((int)value);
            }
            case 7: {
                if ((long)((float)value) == value) {
                    return new Float(value);
                }
            }
            case 8: {
                if ((long)((double)value) == value) {
                    return new Double(value);
                }
            }
            case 5: {
                return new Long(value);
            }
            case 1: {
                return new Byte((byte)value);
            }
            case 3: {
                return new Short((short)value);
            }
        }
        return BigInteger.valueOf(value);
    }

    public static Number newReal(int type, double value) {
        if (type == 7) {
            return new Float((float)value);
        }
        return new Double(value);
    }

    public static Object binaryOr(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).or(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) | OgnlOps.longValue(v2));
    }

    public static Object binaryXor(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).xor(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) ^ OgnlOps.longValue(v2));
    }

    public static Object binaryAnd(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).and(OgnlOps.bigIntValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) & OgnlOps.longValue(v2));
    }

    public static boolean equal(Object v1, Object v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 == v2 || OgnlOps.isEqual(v1, v2)) {
            return true;
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            return ((Number)v1).doubleValue() == ((Number)v2).doubleValue();
        }
        return false;
    }

    public static boolean less(Object v1, Object v2) {
        return OgnlOps.compareWithConversion(v1, v2) < 0;
    }

    public static boolean greater(Object v1, Object v2) {
        return OgnlOps.compareWithConversion(v1, v2) > 0;
    }

    public static boolean in(Object v1, Object v2) throws OgnlException {
        if (v2 == null) {
            return false;
        }
        ElementsAccessor elementsAccessor = OgnlRuntime.getElementsAccessor(OgnlRuntime.getTargetClass(v2));
        Enumeration e = elementsAccessor.getElements(v2);
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!OgnlOps.equal(v1, o)) continue;
            return true;
        }
        return false;
    }

    public static Object shiftLeft(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).shiftLeft((int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) << (int)OgnlOps.longValue(v2));
    }

    public static Object shiftRight(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).shiftRight((int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) >> (int)OgnlOps.longValue(v2));
    }

    public static Object unsignedShiftRight(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1);
        if (type == 6 || type == 9) {
            return OgnlOps.bigIntValue(v1).shiftRight((int)OgnlOps.longValue(v2));
        }
        if (type <= 4) {
            return OgnlOps.newInteger(4, (int)OgnlOps.longValue(v1) >>> (int)OgnlOps.longValue(v2));
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) >>> (int)OgnlOps.longValue(v2));
    }

    public static Object add(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2, true);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).add(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).add(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) + OgnlOps.doubleValue(v2));
            }
            case 10: {
                int t1 = OgnlOps.getNumericType(v1);
                int t2 = OgnlOps.getNumericType(v2);
                if (t1 != 10 && v2 == null || t2 != 10 && v1 == null) {
                    throw new NullPointerException();
                }
                return String.valueOf(OgnlOps.stringValue(v1)) + OgnlOps.stringValue(v2);
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) + OgnlOps.longValue(v2));
    }

    public static Object subtract(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).subtract(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).subtract(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) - OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) - OgnlOps.longValue(v2));
    }

    public static Object multiply(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).multiply(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).multiply(OgnlOps.bigDecValue(v2));
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) * OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) * OgnlOps.longValue(v2));
    }

    public static Object divide(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(v1).divide(OgnlOps.bigIntValue(v2));
            }
            case 9: {
                return OgnlOps.bigDecValue(v1).divide(OgnlOps.bigDecValue(v2), 6);
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, OgnlOps.doubleValue(v1) / OgnlOps.doubleValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) / OgnlOps.longValue(v2));
    }

    public static Object remainder(Object v1, Object v2) {
        int type = OgnlOps.getNumericType(v1, v2);
        switch (type) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(v1).remainder(OgnlOps.bigIntValue(v2));
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(v1) % OgnlOps.longValue(v2));
    }

    public static Object negate(Object value) {
        int type = OgnlOps.getNumericType(value);
        switch (type) {
            case 6: {
                return OgnlOps.bigIntValue(value).negate();
            }
            case 9: {
                return OgnlOps.bigDecValue(value).negate();
            }
            case 7: 
            case 8: {
                return OgnlOps.newReal(type, -OgnlOps.doubleValue(value));
            }
        }
        return OgnlOps.newInteger(type, -OgnlOps.longValue(value));
    }

    public static Object bitNegate(Object value) {
        int type = OgnlOps.getNumericType(value);
        switch (type) {
            case 6: 
            case 9: {
                return OgnlOps.bigIntValue(value).not();
            }
        }
        return OgnlOps.newInteger(type, OgnlOps.longValue(value) ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

