/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.CharTypes;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.Keywords;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.util.Base64;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONScanner
implements JSONLexer {
    public static final byte EOI = 26;
    private final String text;
    private int bp;
    private int eofPos;
    private char ch;
    private int pos;
    private char[] sbuf;
    private int sp;
    private int np;
    private int token;
    private Keywords keywods = Keywords.DEFAULT_KEYWORDS;
    private static final ThreadLocal<SoftReference<char[]>> sbufRefLocal;
    private int features = JSON.DEFAULT_PARSER_FEATURE;
    private Calendar calendar = null;
    private boolean resetFlag = false;
    public int resetCount = 0;
    private static boolean[] whitespaceFlags;
    boolean hasSpecial;
    public static final int NOT_MATCH = -1;
    public static final int NOT_MATCH_NAME = -2;
    public static final int UNKOWN = 0;
    public static final int OBJECT = 1;
    public static final int ARRAY = 2;
    public static final int VALUE = 3;
    public static final int END = 4;
    private static final char[] typeFieldName;
    public int matchStat = 0;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int INT_MULTMIN_RADIX_TEN = -214748364;
    private static final int INT_N_MULTMAX_RADIX_TEN = -214748364;
    private static final int[] digits;
    public final int ISO8601_LEN_0 = "0000-00-00".length();
    public final int ISO8601_LEN_1 = "0000-00-00T00:00:00".length();
    public final int ISO8601_LEN_2 = "0000-00-00T00:00:00.000".length();

    public JSONScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String input, int features) {
        this.features = features;
        SoftReference<char[]> sbufRef = sbufRefLocal.get();
        if (sbufRef != null) {
            this.sbuf = sbufRef.get();
            sbufRefLocal.set(null);
        }
        if (this.sbuf == null) {
            this.sbuf = new char[64];
        }
        this.text = input;
        this.bp = -1;
        this.ch = this.charAt(++this.bp);
        if (this.ch == '\ufeff') {
            this.ch = this.charAt(++this.bp);
        }
    }

    public final char charAt(int index) {
        if (index >= this.text.length()) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    public JSONScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    @Override
    public boolean isResetFlag() {
        return this.resetFlag;
    }

    @Override
    public void setResetFlag(boolean resetFlag) {
        this.resetFlag = resetFlag;
    }

    @Override
    public final int getBufferPosition() {
        return this.bp;
    }

    public void reset(int mark, char mark_ch, int token) {
        this.bp = mark;
        this.ch = mark_ch;
        this.token = token;
        this.resetFlag = true;
        ++this.resetCount;
    }

    @Override
    public boolean isBlankInput() {
        for (int i = 0; i < this.text.length(); ++i) {
            if (JSONScanner.isWhitespace(this.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b';
    }

    private void lexError(String key, Object ... args) {
        this.token = 1;
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final void skipWhitespace() {
        while (whitespaceFlags[this.ch]) {
            this.ch = this.charAt(++this.bp);
        }
    }

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public final void nextTokenWithColon() {
        while (true) {
            if (this.ch == ':') {
                this.ch = this.charAt(++this.bp);
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.ch = this.charAt(++this.bp);
        }
        throw new JSONException("not match ':' - " + this.ch);
    }

    @Override
    public final void nextTokenWithColon(int expect) {
        block17: {
            while (true) {
                if (this.ch == ':') break block17;
                if (!JSONScanner.isWhitespace(this.ch)) break;
                this.ch = this.charAt(++this.bp);
            }
            throw new JSONException("not match ':', actual " + this.ch);
        }
        this.ch = this.charAt(++this.bp);
        while (true) {
            if (expect == 2) {
                if (this.ch >= '0' && this.ch <= '9') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
                if (this.ch == '\"') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
            } else if (expect == 4) {
                if (this.ch == '\"') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanString();
                    return;
                }
                if (this.ch >= '0' && this.ch <= '9') {
                    this.sp = 0;
                    this.pos = this.bp;
                    this.scanNumber();
                    return;
                }
            } else if (expect == 12) {
                if (this.ch == '{') {
                    this.token = 12;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
                if (this.ch == '[') {
                    this.token = 14;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
            } else if (expect == 14) {
                if (this.ch == '[') {
                    this.token = 14;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
                if (this.ch == '{') {
                    this.token = 12;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
            }
            if (!JSONScanner.isWhitespace(this.ch)) break;
            this.ch = this.charAt(++this.bp);
        }
        this.nextToken();
    }

    @Override
    public final void incrementBufferPosition() {
        this.ch = this.charAt(++this.bp);
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public void nextToken(int expect) {
        while (true) {
            switch (expect) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.ch = this.charAt(++this.bp);
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.ch = this.charAt(++this.bp);
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.ch = this.charAt(++this.bp);
        }
        this.nextToken();
    }

    @Override
    public final void nextToken() {
        this.sp = 0;
        block17: while (true) {
            this.pos = this.bp++;
            if (this.ch == '\"') {
                this.scanString();
                return;
            }
            if (this.ch == ',') {
                this.ch = this.charAt(this.bp);
                this.token = 16;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.scanNumber();
                return;
            }
            if (this.ch == '-') {
                this.scanNumber();
                return;
            }
            switch (this.ch) {
                case '\'': {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    this.scanStringSingleQuote();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.ch = this.charAt(++this.bp);
                    continue block17;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'T': {
                    this.scanTreeSet();
                    return;
                }
                case 'S': {
                    this.scanSet();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'D': {
                    this.scanIdent();
                    return;
                }
                case '(': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 10;
                    return;
                }
                case ')': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 11;
                    return;
                }
                case '[': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 14;
                    return;
                }
                case ']': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 15;
                    return;
                }
                case '{': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 12;
                    return;
                }
                case '}': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 13;
                    return;
                }
                case ':': {
                    this.ch = this.charAt(++this.bp);
                    this.token = 17;
                    return;
                }
            }
            break;
        }
        if (this.bp == this.text.length() || this.ch == '\u001a' && this.bp + 1 == this.text.length()) {
            if (this.token == 20) {
                throw new JSONException("EOF error");
            }
            this.token = 20;
            this.pos = this.bp = this.eofPos;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.ch = this.charAt(++this.bp);
        }
    }

    public final void scanStringSingleQuote() {
        char ch;
        this.np = this.bp;
        this.hasSpecial = false;
        block13: while ((ch = this.charAt(++this.bp)) != '\'') {
            if (ch == '\u001a') {
                throw new JSONException("unclosed single-quote string");
            }
            if (ch == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] newsbuf = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                ch = this.charAt(++this.bp);
                switch (ch) {
                    case '\"': {
                        this.putChar('\"');
                        continue block13;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block13;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block13;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block13;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block13;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block13;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block13;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block13;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block13;
                    }
                    case 'x': {
                        char x1 = ch = this.charAt(++this.bp);
                        char x2 = ch = this.charAt(++this.bp);
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block13;
                    }
                    case 'u': {
                        char c1 = ch = this.charAt(++this.bp);
                        char c2 = ch = this.charAt(++this.bp);
                        char c3 = ch = this.charAt(++this.bp);
                        char c4 = ch = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        this.putChar((char)val);
                        continue block13;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.charAt(++this.bp);
    }

    @Override
    public final void scanString() {
        char ch;
        this.np = this.bp;
        this.hasSpecial = false;
        block12: while ((ch = this.charAt(++this.bp)) != '\"') {
            if (ch == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                ch = this.charAt(++this.bp);
                switch (ch) {
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case 'x': {
                        char x1 = ch = this.charAt(++this.bp);
                        char x2 = ch = this.charAt(++this.bp);
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block12;
                    }
                    case 'u': {
                        char u1 = ch = this.charAt(++this.bp);
                        char u2 = ch = this.charAt(++this.bp);
                        char u3 = ch = this.charAt(++this.bp);
                        char u4 = ch = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                        this.putChar((char)val);
                        continue block12;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed string : " + ch);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.charAt(++this.bp);
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char ch;
        boolean firstFlag;
        boolean[] firstIdentifierFlags = CharTypes.firstIdentifierFlags;
        int first = this.ch;
        boolean bl = firstFlag = this.ch >= firstIdentifierFlags.length || firstIdentifierFlags[first];
        if (!firstFlag) {
            throw new JSONException("illegal identifier : " + this.ch);
        }
        boolean[] identifierFlags = CharTypes.identifierFlags;
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while ((ch = this.charAt(++this.bp)) >= identifierFlags.length || identifierFlags[ch]) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        int NULL_HASH = 3392903;
        if (this.sp == 4 && hash == 3392903 && this.charAt(this.np) == 'n' && this.charAt(this.np + 1) == 'u' && this.charAt(this.np + 2) == 'l' && this.charAt(this.np + 3) == 'l') {
            return null;
        }
        return this.text.substring(this.np, this.np + this.sp).intern();
    }

    public int scanType(String type) {
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, typeFieldName)) {
            return -2;
        }
        int bp = this.bp + typeFieldName.length;
        int typeLength = type.length();
        for (int i = 0; i < typeLength; ++i) {
            if (type.charAt(i) == this.charAt(bp + i)) continue;
            return -1;
        }
        if (this.charAt(bp += typeLength) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++bp);
        if (this.ch == ',') {
            this.ch = this.charAt(++bp);
            this.bp = bp;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++bp);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++bp);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++bp);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++bp);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = bp;
        return this.matchStat;
    }

    public boolean matchField(char[] fieldName) {
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            return false;
        }
        this.bp += fieldName.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.ch = this.charAt(++this.bp);
            this.token = 12;
        } else if (this.ch == '[') {
            this.ch = this.charAt(++this.bp);
            this.token = 14;
        } else {
            this.nextToken();
        }
        return true;
    }

    static final boolean charArrayCompare(char[] src, int offset, char[] dest) {
        int destLen = dest.length;
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src[offset + i]) continue;
            return false;
        }
        return true;
    }

    static final boolean charArrayCompare(String src, int offset, char[] dest) {
        int destLen = dest.length;
        if (destLen + offset > src.length()) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src.charAt(offset + i)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] fieldName) {
        char ch;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        boolean hasSpecial = false;
        int startIndex = index;
        int endIndex = this.text.indexOf(34, startIndex);
        if (endIndex == -1) {
            throw new JSONException("unclosed str");
        }
        String stringVal = this.subString(startIndex, endIndex - startIndex);
        for (int i = 0; i < stringVal.length(); ++i) {
            if (stringVal.charAt(i) != '\\') continue;
            hasSpecial = true;
            break;
        }
        if (hasSpecial) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.bp = endIndex + 1;
        this.ch = ch = this.charAt(this.bp);
        String strVal = stringVal;
        if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return strVal;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return strVal;
    }

    public String stringDefaultValue() {
        if (this.isEnabled(Feature.InitStringFieldAsEmpty)) {
            return "";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldSymbol(char[] fieldName, SymbolTable symbolTable) {
        String strVal;
        char ch;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                    this.matchStat = -2;
                    return null;
                }
                int index = this.bp + fieldName.length;
                if ((ch = this.charAt(index++)) != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                int hash = 0;
                do {
                    if ((ch = this.charAt(index++)) == '\"') {
                        this.bp = index;
                        this.ch = ch = this.charAt(this.bp);
                        strVal = symbolTable.addSymbol(this.text, start, index - start - 1, hash);
                        if (ch != ',') break block12;
                        break block13;
                    }
                    hash = 31 * hash + ch;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return strVal;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return strVal;
    }

    public ArrayList<String> scanFieldStringArray(char[] fieldName) {
        return (ArrayList)this.scanFieldStringArray(fieldName, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<String> scanFieldStringArray(char[] fieldName, Class<?> type) {
        Collection<String> list;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return null;
        }
        if (type.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (type.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else {
            try {
                list = type.newInstance();
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
        int index = this.bp + fieldName.length;
        char ch = this.charAt(index++);
        if (ch != '[') {
            this.matchStat = -1;
            return null;
        }
        ch = this.charAt(index++);
        block2: while (true) {
            block21: {
                if (ch != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                int start = index;
                do {
                    if ((ch = this.charAt(index++)) != '\"') continue;
                    String strVal = this.text.substring(start, index - 1);
                    list.add(strVal);
                    ch = this.charAt(index++);
                    if (ch != ',') break block2;
                    break block21;
                } while (ch != '\\');
                this.matchStat = -1;
                return null;
            }
            ch = this.charAt(index++);
        }
        if (ch != ']') {
            this.matchStat = -1;
            return null;
        }
        ch = this.charAt(index++);
        this.bp = index;
        if (ch == ',') {
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return list;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return null;
        }
        ch = this.charAt(this.bp);
        if (ch == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.ch = ch;
        }
        this.matchStat = 4;
        return list;
    }

    public int scanFieldInt(char[] fieldName) {
        int value;
        char ch;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return 0;
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
            value = digits[ch];
            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                value = value * 10 + digits[ch];
            }
            if (ch == '.') {
                this.matchStat = -1;
                return 0;
            }
            this.bp = index - 1;
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (ch == ',') {
            ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch == '}') {
            if ((ch = this.charAt(++this.bp)) == ',') {
                this.token = 16;
                this.ch = this.charAt(++this.bp);
            } else if (ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '\u001a') {
                this.token = 20;
            } else {
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = 4;
        }
        return value;
    }

    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        char ch;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return false;
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) == 't') {
            if (this.charAt(index++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            this.bp = index;
            ch = this.charAt(this.bp);
            value = true;
        } else if (ch == 'f') {
            if (this.charAt(index++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(index++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            this.bp = index;
            ch = this.charAt(this.bp);
            value = false;
        } else {
            this.matchStat = -1;
            return false;
        }
        if (ch == ',') {
            ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
        } else if (ch == '}') {
            if ((ch = this.charAt(++this.bp)) == ',') {
                this.token = 16;
                this.ch = this.charAt(++this.bp);
            } else if (ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++this.bp);
            } else if (ch == '\u001a') {
                this.token = 20;
            } else {
                this.matchStat = -1;
                return false;
            }
            this.matchStat = 4;
        } else {
            this.matchStat = -1;
            return false;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] fieldName) {
        long value;
        char ch;
        this.matchStat = 0;
        if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
            this.matchStat = -2;
            return 0L;
        }
        int index = this.bp + fieldName.length;
        if ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
            value = digits[ch];
            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                value = value * 10L + (long)digits[ch];
            }
            if (ch == '.') {
                this.token = -1;
                return 0L;
            }
            this.bp = index - 1;
            if (value < 0L) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (ch == ',') {
            ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float scanFieldFloat(char[] fieldName) {
        float value;
        char ch;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    int index = this.bp + fieldName.length;
                    if ((ch = this.charAt(index++)) < '0' || ch > '9') break block14;
                    int start = index - 1;
                    while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                    }
                    if (ch == '.') {
                        if ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    this.bp = index - 1;
                    String text = this.text.substring(start, index - 1);
                    value = Float.parseFloat(text);
                    if (ch != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0f;
            }
            ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0.0f;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return 0.0f;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    @Override
    public byte[] bytesValue() {
        return Base64.decodeFast(this.text, this.np + 1, this.sp);
    }

    /*
     * Enabled aggressive block sorting
     */
    public double scanFieldDouble(char[] fieldName) {
        double value;
        char ch;
        block15: {
            block16: {
                block14: {
                    this.matchStat = 0;
                    if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    int index = this.bp + fieldName.length;
                    if ((ch = this.charAt(index++)) < '0' || ch > '9') break block14;
                    int start = index - 1;
                    while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                    }
                    if (ch == '.') {
                        if ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                            while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    this.bp = index - 1;
                    String text = this.text.substring(start, index - 1);
                    value = Double.parseDouble(text);
                    if (ch != ',') break block15;
                    break block16;
                }
                this.matchStat = -1;
                return 0.0;
            }
            ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return value;
        }
        if (ch != '}') {
            this.matchStat = -1;
            return 0.0;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else {
            if (ch != '\u001a') {
                this.matchStat = -1;
                return 0.0;
            }
            this.token = 20;
        }
        this.matchStat = 4;
        return value;
    }

    @Override
    public String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++this.bp);
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable, char quote) {
        char ch;
        int hash = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean hasSpecial = false;
        block11: while ((ch = this.charAt(++this.bp)) != quote) {
            if (ch == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (ch == '\\') {
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    this.text.getChars(this.np + 1, this.np + 1 + this.sp, this.sbuf, 0);
                }
                ch = this.charAt(++this.bp);
                switch (ch) {
                    case '\"': {
                        hash = 31 * hash + 34;
                        this.putChar('\"');
                        continue block11;
                    }
                    case '\\': {
                        hash = 31 * hash + 92;
                        this.putChar('\\');
                        continue block11;
                    }
                    case '/': {
                        hash = 31 * hash + 47;
                        this.putChar('/');
                        continue block11;
                    }
                    case 'b': {
                        hash = 31 * hash + 8;
                        this.putChar('\b');
                        continue block11;
                    }
                    case 'F': 
                    case 'f': {
                        hash = 31 * hash + 12;
                        this.putChar('\f');
                        continue block11;
                    }
                    case 'n': {
                        hash = 31 * hash + 10;
                        this.putChar('\n');
                        continue block11;
                    }
                    case 'r': {
                        hash = 31 * hash + 13;
                        this.putChar('\r');
                        continue block11;
                    }
                    case 't': {
                        hash = 31 * hash + 9;
                        this.putChar('\t');
                        continue block11;
                    }
                    case 'u': {
                        char c1 = ch = this.charAt(++this.bp);
                        char c2 = ch = this.charAt(++this.bp);
                        char c3 = ch = this.charAt(++this.bp);
                        char c4 = ch = this.charAt(++this.bp);
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        hash = 31 * hash + val;
                        this.putChar((char)val);
                        continue block11;
                    }
                }
                this.ch = ch;
                throw new JSONException("unclosed.str.lit");
            }
            hash = 31 * hash + ch;
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.token = 4;
        this.ch = this.charAt(++this.bp);
        if (!hasSpecial) {
            return symbolTable.addSymbol(this.text, this.np + 1, this.sp, hash);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp, hash);
    }

    public void scanTrue() {
        if (this.charAt(this.bp++) != 't') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'r') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'u') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'e') {
            throw new JSONException("error parse true");
        }
        this.ch = this.charAt(this.bp);
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 6;
    }

    public void scanSet() {
        if (this.charAt(this.bp++) != 'S') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 't') {
            throw new JSONException("error parse true");
        }
        this.ch = this.charAt(this.bp);
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 21;
    }

    public void scanTreeSet() {
        if (this.charAt(this.bp++) != 'T') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'r') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'S') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 'e') {
            throw new JSONException("error parse true");
        }
        if (this.charAt(this.bp++) != 't') {
            throw new JSONException("error parse true");
        }
        this.ch = this.charAt(this.bp);
        if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b' && this.ch != '[' && this.ch != '(') {
            throw new JSONException("scan set error");
        }
        this.token = 22;
    }

    public void scanNullOrNew() {
        if (this.charAt(this.bp++) != 'n') {
            throw new JSONException("error parse null or new");
        }
        if (this.charAt(this.bp) == 'u') {
            ++this.bp;
            if (this.charAt(this.bp++) != 'l') {
                throw new JSONException("error parse true");
            }
            if (this.charAt(this.bp++) != 'l') {
                throw new JSONException("error parse true");
            }
            this.ch = this.charAt(this.bp);
            if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
                throw new JSONException("scan true error");
            }
            this.token = 8;
            return;
        }
        if (this.charAt(this.bp) != 'e') {
            throw new JSONException("error parse e");
        }
        ++this.bp;
        if (this.charAt(this.bp++) != 'w') {
            throw new JSONException("error parse w");
        }
        this.ch = this.charAt(this.bp);
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan true error");
        }
        this.token = 9;
    }

    public void scanFalse() {
        if (this.charAt(this.bp++) != 'f') {
            throw new JSONException("error parse false");
        }
        if (this.charAt(this.bp++) != 'a') {
            throw new JSONException("error parse false");
        }
        if (this.charAt(this.bp++) != 'l') {
            throw new JSONException("error parse false");
        }
        if (this.charAt(this.bp++) != 's') {
            throw new JSONException("error parse false");
        }
        if (this.charAt(this.bp++) != 'e') {
            throw new JSONException("error parse false");
        }
        this.ch = this.charAt(this.bp);
        if (this.ch != ' ' && this.ch != ',' && this.ch != '}' && this.ch != ']' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\u001a' && this.ch != '\f' && this.ch != '\b') {
            throw new JSONException("scan false error");
        }
        this.token = 7;
    }

    public void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
        } while (Character.isLetterOrDigit(this.ch));
        String ident = this.stringVal();
        Integer tok = this.keywods.getKeyword(ident);
        this.token = tok != null ? tok : 18;
    }

    @Override
    public void scanNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.charAt(this.bp);
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
        }
        boolean isDouble = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.charAt(++this.bp);
            }
        }
        if (this.ch == 'L') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
        } else if (this.ch == 'S') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
        } else if (this.ch == 'B') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
        } else if (this.ch == 'F') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
            isDouble = true;
        } else if (this.ch == 'D') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
            isDouble = true;
        } else if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = this.charAt(++this.bp);
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = this.charAt(++this.bp);
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.charAt(++this.bp);
            }
            if (this.ch == 'D' || this.ch == 'F') {
                this.ch = this.charAt(++this.bp);
            }
            isDouble = true;
        }
        this.token = isDouble ? 3 : 2;
    }

    private final void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.text.substring(this.np + 1, this.np + 1 + this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public final String subString(int offset, int count) {
        return this.text.substring(offset, offset + count);
    }

    public boolean isRef() {
        if (this.hasSpecial) {
            return false;
        }
        if (this.sp != 4) {
            return false;
        }
        return this.charAt(this.np + 1) == '$' && this.charAt(this.np + 2) == 'r' && this.charAt(this.np + 3) == 'e' && this.charAt(this.np + 4) == 'f';
    }

    @Override
    public final String symbol(SymbolTable symbolTable) {
        if (symbolTable == null) {
            if (!this.hasSpecial) {
                return this.text.substring(this.np + 1, this.np + 1 + this.sp);
            }
            return new String(this.sbuf, 0, this.sp);
        }
        if (!this.hasSpecial) {
            return symbolTable.addSymbol(this.text, this.np + 1, this.sp);
        }
        return symbolTable.addSymbol(this.sbuf, 0, this.sp);
    }

    @Override
    public Number integerValue() throws NumberFormatException {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        int type = 32;
        if (max > 0) {
            switch (this.charAt(max - 1)) {
                case 'L': {
                    --max;
                    type = 76;
                    break;
                }
                case 'S': {
                    --max;
                    type = 83;
                    break;
                }
                case 'B': {
                    --max;
                    type = 66;
                    break;
                }
            }
        }
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.charAt(i++)];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE && type != 76) {
                    if (type == 83) {
                        return (short)result;
                    }
                    if (type == 66) {
                        return (byte)result;
                    }
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE && type != 76) {
            if (type == 83) {
                return (short)result;
            }
            if (type == 66) {
                return (byte)result;
            }
            return (int)result;
        }
        return result;
    }

    @Override
    public long longValue() throws NumberFormatException {
        char ch;
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (ch = this.charAt(i++)) != 'L' && ch != 'S' && ch != 'B') {
            digit = digits[ch];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    @Override
    public int intValue() {
        char ch;
        int digit;
        int multmin;
        int limit;
        int result = 0;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.charAt(this.np) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int n = multmin = negative ? -214748364 : -214748364;
        if (i < max) {
            digit = digits[this.charAt(i++)];
            result = -digit;
        }
        while (i < max && (ch = this.charAt(i++)) != 'L' && ch != 'S' && ch != 'B') {
            digit = digits[ch];
            if (result < multmin) {
                throw new NumberFormatException(this.numberString());
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(this.numberString());
            }
            result -= digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -result;
    }

    @Override
    public final String numberString() {
        char ch = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (ch == 'L' || ch == 'S' || ch == 'B' || ch == 'F' || ch == 'D') {
            --sp;
        }
        return this.text.substring(this.np, this.np + sp);
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.numberString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public Number decimalValue(boolean decimal) {
        char ch = this.charAt(this.np + this.sp - 1);
        if (ch == 'F') {
            return Float.valueOf(Float.parseFloat(this.text.substring(this.np, this.np + this.sp - 1)));
        }
        if (ch == 'D') {
            return Double.parseDouble(this.text.substring(this.np, this.np + this.sp - 1));
        }
        if (decimal) {
            return this.decimalValue();
        }
        return this.doubleValue();
    }

    @Override
    public BigDecimal decimalValue() {
        char ch = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (ch == 'L' || ch == 'S' || ch == 'B' || ch == 'F' || ch == 'D') {
            --sp;
        }
        return new BigDecimal(this.text.substring(this.np, this.np + sp));
    }

    @Override
    public void config(Feature feature, boolean state) {
        this.features = Feature.config(this.features, feature, state);
    }

    @Override
    public boolean isEnabled(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }

    @Override
    public boolean scanISO8601DateIfMatch() {
        int rest = this.text.length() - this.bp;
        if (rest < this.ISO8601_LEN_0) {
            return false;
        }
        char y0 = this.charAt(this.bp);
        char y1 = this.charAt(this.bp + 1);
        char y2 = this.charAt(this.bp + 2);
        char y3 = this.charAt(this.bp + 3);
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (this.charAt(this.bp + 4) != '-') {
            return false;
        }
        char M0 = this.charAt(this.bp + 5);
        char M1 = this.charAt(this.bp + 6);
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (this.charAt(this.bp + 7) != '-') {
            return false;
        }
        char d0 = this.charAt(this.bp + 8);
        char d1 = this.charAt(this.bp + 9);
        if (d0 == '0') {
            if (d1 < '1' || d1 > '9') {
                return false;
            }
        } else if (d0 == '1' || d0 == '2') {
            if (d1 < '0' || d1 > '9') {
                return false;
            }
        } else if (d0 == '3') {
            if (d1 != '0' && d1 != '1') {
                return false;
            }
        } else {
            return false;
        }
        Locale local = Locale.getDefault();
        this.calendar = Calendar.getInstance(TimeZone.getDefault(), local);
        int year = digits[y0] * 1000 + digits[y1] * 100 + digits[y2] * 10 + digits[y3];
        int month = digits[M0] * 10 + digits[M1] - 1;
        int day = digits[d0] * 10 + digits[d1];
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
        char t = this.charAt(this.bp + 10);
        if (t == 'T') {
            if (rest < this.ISO8601_LEN_1) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += 10);
                this.token = 5;
                return true;
            }
            return false;
        }
        char h0 = this.charAt(this.bp + 11);
        char h1 = this.charAt(this.bp + 12);
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (this.charAt(this.bp + 13) != ':') {
            return false;
        }
        char m0 = this.charAt(this.bp + 14);
        char m1 = this.charAt(this.bp + 15);
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (this.charAt(this.bp + 16) != ':') {
            return false;
        }
        char s0 = this.charAt(this.bp + 17);
        char s1 = this.charAt(this.bp + 18);
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        int hour = digits[h0] * 10 + digits[h1];
        int minute = digits[m0] * 10 + digits[m1];
        int seconds = digits[s0] * 10 + digits[s1];
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
        char dot = this.charAt(this.bp + 19);
        if (dot == '.') {
            if (rest < this.ISO8601_LEN_2) {
                return false;
            }
        } else {
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += 19);
            this.token = 5;
            return true;
        }
        char S0 = this.charAt(this.bp + 20);
        char S1 = this.charAt(this.bp + 21);
        char S2 = this.charAt(this.bp + 22);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        if (S1 < '0' || S1 > '9') {
            return false;
        }
        if (S2 < '0' || S2 > '9') {
            return false;
        }
        int millis = digits[S0] * 100 + digits[S1] * 10 + digits[S2];
        this.calendar.set(14, millis);
        this.ch = this.charAt(this.bp += 23);
        this.token = 5;
        return true;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public boolean isEOF() {
        switch (this.token) {
            case 20: {
                return true;
            }
            case 1: {
                return false;
            }
            case 13: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            sbufRefLocal.set(new SoftReference<char[]>(this.sbuf));
        }
        this.sbuf = null;
    }

    static {
        int i;
        sbufRefLocal = new ThreadLocal();
        whitespaceFlags = new boolean[256];
        JSONScanner.whitespaceFlags[32] = true;
        JSONScanner.whitespaceFlags[10] = true;
        JSONScanner.whitespaceFlags[13] = true;
        JSONScanner.whitespaceFlags[9] = true;
        JSONScanner.whitespaceFlags[12] = true;
        JSONScanner.whitespaceFlags[8] = true;
        typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
        digits = new int[103];
        for (i = 48; i <= 57; ++i) {
            JSONScanner.digits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            JSONScanner.digits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            JSONScanner.digits[i] = i - 65 + 10;
        }
    }
}

