/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.File;
import java.util.Locale;

public final class CommandLineEncoder {
    private static final BarcodeFormat DEFAULT_BARCODE_FORMAT = BarcodeFormat.QR_CODE;
    private static final String DEFAULT_IMAGE_FORMAT = "PNG";
    private static final String DEFAULT_OUTPUT_FILE = "out";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;

    private CommandLineEncoder() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            CommandLineEncoder.printUsage();
            return;
        }
        BarcodeFormat barcodeFormat = DEFAULT_BARCODE_FORMAT;
        String imageFormat = DEFAULT_IMAGE_FORMAT;
        String outFileString = DEFAULT_OUTPUT_FILE;
        int width = 300;
        int height = 300;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("--barcode_format")) {
                barcodeFormat = BarcodeFormat.valueOf((String)arg.split("=")[1]);
            } else if (arg.startsWith("--image_format")) {
                imageFormat = arg.split("=")[1];
            } else if (arg.startsWith("--output")) {
                outFileString = arg.split("=")[1];
            } else if (arg.startsWith("--width")) {
                width = Integer.parseInt(arg.split("=")[1]);
            } else if (arg.startsWith("--height")) {
                height = Integer.parseInt(arg.split("=")[1]);
            }
            ++n2;
        }
        if (DEFAULT_OUTPUT_FILE.equals(outFileString)) {
            outFileString = String.valueOf(outFileString) + '.' + imageFormat.toLowerCase(Locale.ENGLISH);
        }
        String contents = null;
        String[] stringArray2 = args;
        int n3 = args.length;
        n = 0;
        while (n < n3) {
            String arg = stringArray2[n];
            if (!arg.startsWith("--")) {
                contents = arg;
                break;
            }
            ++n;
        }
        if (contents == null) {
            CommandLineEncoder.printUsage();
            return;
        }
        MultiFormatWriter barcodeWriter = new MultiFormatWriter();
        BitMatrix matrix = barcodeWriter.encode(contents, barcodeFormat, width, height);
        MatrixToImageWriter.writeToFile(matrix, imageFormat, new File(outFileString));
    }

    private static void printUsage() {
        System.err.println("Encodes barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineEncoder [ options ] content_to_encode");
        System.err.println("  --barcode_format=format: Format to encode, from BarcodeFormat class. Not all formats are supported. Defaults to QR_CODE.");
        System.err.println("  --image_format=format: image output format, such as PNG, JPG, GIF. Defaults to PNG");
        System.err.println("  --output=filename: File to write to. Defaults to out.png");
        System.err.println("  --width=pixels: Image width. Defaults to 300");
        System.err.println("  --height=pixels: Image height. Defaults to 300");
    }
}

