/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import snaq.util.ObjectPool;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;
import snaq.util.logging.LogUtil;

public class PoolTracer
implements ObjectPoolListener {
    private LogUtil logger = new LogUtil();
    private static final DateFormat DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private static final String DEFAULT_FORMAT_STRING = "name={0}, minpool={1,number,#}, maxpool={2,number,#}, maxsize={3,number,#}, expiry={4,number,#}, out={5,number,#}, free={6,number,#}, hitRate={8,number,0.0##%}, event={9}";
    private MessageFormat msgFormat;

    public PoolTracer(ObjectPool pool, PrintWriter logWriter, boolean closeOnExit) {
        this.logger.setLog(logWriter, closeOnExit);
        this.logger.setDateFormat(DEFAULT_DATEFORMAT);
        this.setMessageFormat(null);
        pool.addObjectPoolListener(this);
    }

    public PoolTracer(ObjectPool pool, File file) throws FileNotFoundException {
        this(pool, new PrintWriter(file), true);
    }

    public PoolTracer(ObjectPool pool, String filename) throws FileNotFoundException {
        this(pool, new PrintWriter(filename), true);
    }

    public PoolTracer(Properties props) throws FileNotFoundException {
        Properties p = PoolTracer.convertToLC(props);
        String filename = p.getProperty("file");
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("Property not specified: file");
        }
        this.logger.setLog(new PrintWriter(new File(filename)), true);
        String dateFormat = p.getProperty("dateformat");
        if (dateFormat != null && !dateFormat.trim().equals("")) {
            this.logger.setDateFormat(new SimpleDateFormat(dateFormat));
        } else {
            this.logger.setDateFormat(DEFAULT_DATEFORMAT);
        }
        String format = p.getProperty("format");
        if (format != null && !format.trim().equals("")) {
            this.setMessageFormat(new MessageFormat(format));
        } else {
            this.setMessageFormat(null);
        }
    }

    private static Properties convertToLC(Properties p) {
        Properties props = new Properties();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            props.put(key.toLowerCase(), p.getProperty(key));
        }
        return props;
    }

    public synchronized void setDateFormat(DateFormat df) {
        this.logger.setDateFormat(df);
    }

    public void setMessageFormat(MessageFormat mf) {
        this.msgFormat = mf == null ? new MessageFormat(DEFAULT_FORMAT_STRING) : mf;
    }

    public MessageFormat getMessageFormatInstance() {
        return this.msgFormat;
    }

    protected void logPoolStats(ObjectPoolEvent evt) {
        Object[] o = new Object[]{evt.getPool().getName(), evt.getMinPool(), evt.getMaxPool(), evt.getMaxSize(), evt.getIdleTimeout(), evt.getCheckedOut(), evt.getFreeCount(), evt.getSize(), Float.valueOf(evt.getPoolHitRate()), evt.getTypeString()};
        String msg = this.msgFormat.format(o);
        this.logger.log(msg);
    }

    @Override
    public void poolInitCompleted(ObjectPoolEvent evt) {
    }

    @Override
    public void validationError(ObjectPoolEvent evt) {
    }

    @Override
    public void maxPoolLimitReached(ObjectPoolEvent evt) {
    }

    @Override
    public void maxPoolLimitExceeded(ObjectPoolEvent evt) {
    }

    @Override
    public void maxSizeLimitReached(ObjectPoolEvent evt) {
    }

    @Override
    public void maxSizeLimitError(ObjectPoolEvent evt) {
    }

    @Override
    public void poolCheckIn(ObjectPoolEvent evt) {
        this.logPoolStats(evt);
    }

    @Override
    public void poolCheckOut(ObjectPoolEvent evt) {
        this.logPoolStats(evt);
    }

    @Override
    public void poolParametersChanged(ObjectPoolEvent evt) {
        this.logPoolStats(evt);
    }

    @Override
    public void poolFlushed(ObjectPoolEvent evt) {
        this.logPoolStats(evt);
    }

    @Override
    public void poolReleased(ObjectPoolEvent evt) {
        this.logPoolStats(evt);
        evt.getPool().removeObjectPoolListener(this);
        this.logger.close();
    }
}

