/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml.dynamic;

import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.ognl.ExpressionSyntaxException;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.Ognl;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.ParseException;
import org.apache.ibatis.ognl.TokenMgrError;

public class OgnlCache {
    private static final Map<String, Node> expressionCache = new ConcurrentHashMap<String, Node>();

    public static Object getValue(String expression, Object root) throws OgnlException {
        return Ognl.getValue(OgnlCache.parseExpression(expression), root);
    }

    private static Object parseExpression(String expression) throws OgnlException {
        try {
            Node node = expressionCache.get(expression);
            if (node == null) {
                node = new OgnlParser(new StringReader(expression)).topLevelExpression();
                expressionCache.put(expression, node);
            }
            return node;
        }
        catch (ParseException e) {
            throw new ExpressionSyntaxException(expression, e);
        }
        catch (TokenMgrError e) {
            throw new ExpressionSyntaxException(expression, e);
        }
    }
}

