/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.qrcode.decoder.BitMatrixParser;
import com.google.zxing.qrcode.decoder.DataBlock;
import com.google.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    public DecoderResult decode(boolean[][] image) throws ChecksumException, FormatException {
        return this.decode(image, null);
    }

    public DecoderResult decode(boolean[][] image, Map<DecodeHintType, ?> hints) throws ChecksumException, FormatException {
        int dimension = image.length;
        BitMatrix bits = new BitMatrix(dimension);
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                if (image[i][j]) {
                    bits.set(j, i);
                }
                ++j;
            }
            ++i;
        }
        return this.decode(bits, hints);
    }

    public DecoderResult decode(BitMatrix bits) throws ChecksumException, FormatException {
        return this.decode(bits, null);
    }

    public DecoderResult decode(BitMatrix bits, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        BitMatrixParser parser = new BitMatrixParser(bits);
        Version version = parser.readVersion();
        ErrorCorrectionLevel ecLevel = parser.readFormatInformation().getErrorCorrectionLevel();
        byte[] codewords = parser.readCodewords();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(codewords, version, ecLevel);
        int totalBytes = 0;
        DataBlock[] dataBlockArray = dataBlocks;
        int n = dataBlocks.length;
        int n2 = 0;
        while (n2 < n) {
            DataBlock dataBlock = dataBlockArray[n2];
            totalBytes += dataBlock.getNumDataCodewords();
            ++n2;
        }
        byte[] resultBytes = new byte[totalBytes];
        int resultOffset = 0;
        DataBlock[] dataBlockArray2 = dataBlocks;
        int n3 = dataBlocks.length;
        int n4 = 0;
        while (n4 < n3) {
            DataBlock dataBlock = dataBlockArray2[n4];
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            int i = 0;
            while (i < numDataCodewords) {
                resultBytes[resultOffset++] = codewordBytes[i];
                ++i;
            }
            ++n4;
        }
        return DecodedBitStreamParser.decode(resultBytes, version, ecLevel, hints);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) throws ChecksumException {
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        int i = 0;
        while (i < numCodewords) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
            ++i;
        }
        int numECCodewords = codewordBytes.length - numDataCodewords;
        try {
            this.rsDecoder.decode(codewordsInts, numECCodewords);
        }
        catch (ReedSolomonException ignored) {
            throw ChecksumException.getChecksumInstance();
        }
        int i2 = 0;
        while (i2 < numDataCodewords) {
            codewordBytes[i2] = (byte)codewordsInts[i2];
            ++i2;
        }
    }
}

