/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class Decoder {
    private static final int[] NB_BITS_COMPACT;
    private static final int[] NB_BITS;
    private static final int[] NB_DATABLOCK_COMPACT;
    private static final int[] NB_DATABLOCK;
    private static final String[] UPPER_TABLE;
    private static final String[] LOWER_TABLE;
    private static final String[] MIXED_TABLE;
    private static final String[] PUNCT_TABLE;
    private static final String[] DIGIT_TABLE;
    private int numCodewords;
    private int codewordSize;
    private AztecDetectorResult ddata;
    private int invertedBitCount;

    static {
        int[] nArray = new int[5];
        nArray[1] = 104;
        nArray[2] = 240;
        nArray[3] = 408;
        nArray[4] = 608;
        NB_BITS_COMPACT = nArray;
        int[] nArray2 = new int[33];
        nArray2[1] = 128;
        nArray2[2] = 288;
        nArray2[3] = 480;
        nArray2[4] = 704;
        nArray2[5] = 960;
        nArray2[6] = 1248;
        nArray2[7] = 1568;
        nArray2[8] = 1920;
        nArray2[9] = 2304;
        nArray2[10] = 2720;
        nArray2[11] = 3168;
        nArray2[12] = 3648;
        nArray2[13] = 4160;
        nArray2[14] = 4704;
        nArray2[15] = 5280;
        nArray2[16] = 5888;
        nArray2[17] = 6528;
        nArray2[18] = 7200;
        nArray2[19] = 7904;
        nArray2[20] = 8640;
        nArray2[21] = 9408;
        nArray2[22] = 10208;
        nArray2[23] = 11040;
        nArray2[24] = 11904;
        nArray2[25] = 12800;
        nArray2[26] = 13728;
        nArray2[27] = 14688;
        nArray2[28] = 15680;
        nArray2[29] = 16704;
        nArray2[30] = 17760;
        nArray2[31] = 18848;
        nArray2[32] = 19968;
        NB_BITS = nArray2;
        int[] nArray3 = new int[5];
        nArray3[1] = 17;
        nArray3[2] = 40;
        nArray3[3] = 51;
        nArray3[4] = 76;
        NB_DATABLOCK_COMPACT = nArray3;
        int[] nArray4 = new int[33];
        nArray4[1] = 21;
        nArray4[2] = 48;
        nArray4[3] = 60;
        nArray4[4] = 88;
        nArray4[5] = 120;
        nArray4[6] = 156;
        nArray4[7] = 196;
        nArray4[8] = 240;
        nArray4[9] = 230;
        nArray4[10] = 272;
        nArray4[11] = 316;
        nArray4[12] = 364;
        nArray4[13] = 416;
        nArray4[14] = 470;
        nArray4[15] = 528;
        nArray4[16] = 588;
        nArray4[17] = 652;
        nArray4[18] = 720;
        nArray4[19] = 790;
        nArray4[20] = 864;
        nArray4[21] = 940;
        nArray4[22] = 1020;
        nArray4[23] = 920;
        nArray4[24] = 992;
        nArray4[25] = 1066;
        nArray4[26] = 1144;
        nArray4[27] = 1224;
        nArray4[28] = 1306;
        nArray4[29] = 1392;
        nArray4[30] = 1480;
        nArray4[31] = 1570;
        nArray4[32] = 1664;
        NB_DATABLOCK = nArray4;
        UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
        LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
        MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
        PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
        DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    }

    public DecoderResult decode(AztecDetectorResult detectorResult) throws FormatException {
        this.ddata = detectorResult;
        BitMatrix matrix = detectorResult.getBits();
        if (!this.ddata.isCompact()) {
            matrix = Decoder.removeDashedLines(this.ddata.getBits());
        }
        boolean[] rawbits = this.extractBits(matrix);
        boolean[] correctedBits = this.correctBits(rawbits);
        String result = this.getEncodedData(correctedBits);
        return new DecoderResult(null, result, null, null);
    }

    private String getEncodedData(boolean[] correctedBits) throws FormatException {
        int endIndex = this.codewordSize * this.ddata.getNbDatablocks() - this.invertedBitCount;
        if (endIndex > correctedBits.length) {
            throw FormatException.getFormatInstance();
        }
        Table lastTable = Table.UPPER;
        Table table = Table.UPPER;
        int startIndex = 0;
        StringBuilder result = new StringBuilder(20);
        boolean end = false;
        boolean shift = false;
        boolean switchShift = false;
        boolean binaryShift = false;
        while (!end) {
            int code;
            if (shift) {
                switchShift = true;
            } else {
                lastTable = table;
            }
            if (binaryShift) {
                if (endIndex - startIndex < 5) break;
                int length = Decoder.readCode(correctedBits, startIndex, 5);
                startIndex += 5;
                if (length == 0) {
                    if (endIndex - startIndex < 11) break;
                    length = Decoder.readCode(correctedBits, startIndex, 11) + 31;
                    startIndex += 11;
                }
                int charCount = 0;
                while (charCount < length) {
                    if (endIndex - startIndex < 8) {
                        end = true;
                        break;
                    }
                    code = Decoder.readCode(correctedBits, startIndex, 8);
                    result.append((char)code);
                    startIndex += 8;
                    ++charCount;
                }
                binaryShift = false;
            } else if (table == Table.BINARY) {
                if (endIndex - startIndex < 8) break;
                code = Decoder.readCode(correctedBits, startIndex, 8);
                startIndex += 8;
                result.append((char)code);
            } else {
                int size = 5;
                if (table == Table.DIGIT) {
                    size = 4;
                }
                if (endIndex - startIndex < size) break;
                code = Decoder.readCode(correctedBits, startIndex, size);
                startIndex += size;
                String str = Decoder.getCharacter(table, code);
                if (str.startsWith("CTRL_")) {
                    table = Decoder.getTable(str.charAt(5));
                    if (str.charAt(6) == 'S') {
                        shift = true;
                        if (str.charAt(5) == 'B') {
                            binaryShift = true;
                        }
                    }
                } else {
                    result.append(str);
                }
            }
            if (!switchShift) continue;
            table = lastTable;
            shift = false;
            switchShift = false;
        }
        return result.toString();
    }

    private static Table getTable(char t) {
        switch (t) {
            case 'L': {
                return Table.LOWER;
            }
            case 'P': {
                return Table.PUNCT;
            }
            case 'M': {
                return Table.MIXED;
            }
            case 'D': {
                return Table.DIGIT;
            }
            case 'B': {
                return Table.BINARY;
            }
        }
        return Table.UPPER;
    }

    private static String getCharacter(Table table, int code) {
        switch (table) {
            case UPPER: {
                return UPPER_TABLE[code];
            }
            case LOWER: {
                return LOWER_TABLE[code];
            }
            case MIXED: {
                return MIXED_TABLE[code];
            }
            case PUNCT: {
                return PUNCT_TABLE[code];
            }
            case DIGIT: {
                return DIGIT_TABLE[code];
            }
        }
        return "";
    }

    private boolean[] correctBits(boolean[] rawbits) throws FormatException {
        int numECCodewords;
        int offset;
        GenericGF gf;
        if (this.ddata.getNbLayers() <= 2) {
            this.codewordSize = 6;
            gf = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            this.codewordSize = 8;
            gf = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            this.codewordSize = 10;
            gf = GenericGF.AZTEC_DATA_10;
        } else {
            this.codewordSize = 12;
            gf = GenericGF.AZTEC_DATA_12;
        }
        int numDataCodewords = this.ddata.getNbDatablocks();
        if (this.ddata.isCompact()) {
            offset = NB_BITS_COMPACT[this.ddata.getNbLayers()] - this.numCodewords * this.codewordSize;
            numECCodewords = NB_DATABLOCK_COMPACT[this.ddata.getNbLayers()] - numDataCodewords;
        } else {
            offset = NB_BITS[this.ddata.getNbLayers()] - this.numCodewords * this.codewordSize;
            numECCodewords = NB_DATABLOCK[this.ddata.getNbLayers()] - numDataCodewords;
        }
        int[] dataWords = new int[this.numCodewords];
        int i = 0;
        while (i < this.numCodewords) {
            int flag = 1;
            int j = 1;
            while (j <= this.codewordSize) {
                if (rawbits[this.codewordSize * i + this.codewordSize - j + offset]) {
                    int n = i;
                    dataWords[n] = dataWords[n] + flag;
                }
                flag <<= 1;
                ++j;
            }
            ++i;
        }
        try {
            ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(gf);
            rsDecoder.decode(dataWords, numECCodewords);
        }
        catch (ReedSolomonException ignored) {
            throw FormatException.getFormatInstance();
        }
        offset = 0;
        this.invertedBitCount = 0;
        boolean[] correctedBits = new boolean[numDataCodewords * this.codewordSize];
        int i2 = 0;
        while (i2 < numDataCodewords) {
            boolean seriesColor = false;
            int seriesCount = 0;
            int flag = 1 << this.codewordSize - 1;
            int j = 0;
            while (j < this.codewordSize) {
                boolean color;
                boolean bl = color = (dataWords[i2] & flag) == flag;
                if (seriesCount == this.codewordSize - 1) {
                    if (color == seriesColor) {
                        throw FormatException.getFormatInstance();
                    }
                    seriesColor = false;
                    seriesCount = 0;
                    ++offset;
                    ++this.invertedBitCount;
                } else {
                    if (seriesColor == color) {
                        ++seriesCount;
                    } else {
                        seriesCount = 1;
                        seriesColor = color;
                    }
                    correctedBits[i2 * this.codewordSize + j - offset] = color;
                }
                flag >>>= 1;
                ++j;
            }
            ++i2;
        }
        return correctedBits;
    }

    private boolean[] extractBits(BitMatrix matrix) throws FormatException {
        boolean[] rawbits;
        if (this.ddata.isCompact()) {
            if (this.ddata.getNbLayers() > NB_BITS_COMPACT.length) {
                throw FormatException.getFormatInstance();
            }
            rawbits = new boolean[NB_BITS_COMPACT[this.ddata.getNbLayers()]];
            this.numCodewords = NB_DATABLOCK_COMPACT[this.ddata.getNbLayers()];
        } else {
            if (this.ddata.getNbLayers() > NB_BITS.length) {
                throw FormatException.getFormatInstance();
            }
            rawbits = new boolean[NB_BITS[this.ddata.getNbLayers()]];
            this.numCodewords = NB_DATABLOCK[this.ddata.getNbLayers()];
        }
        int layer = this.ddata.getNbLayers();
        int size = matrix.getHeight();
        int rawbitsOffset = 0;
        int matrixOffset = 0;
        while (layer != 0) {
            int flip = 0;
            int i = 0;
            while (i < 2 * size - 4) {
                rawbits[rawbitsOffset + i] = matrix.get(matrixOffset + flip, matrixOffset + i / 2);
                rawbits[rawbitsOffset + 2 * size - 4 + i] = matrix.get(matrixOffset + i / 2, matrixOffset + size - 1 - flip);
                flip = (flip + 1) % 2;
                ++i;
            }
            flip = 0;
            i = 2 * size + 1;
            while (i > 5) {
                rawbits[rawbitsOffset + 4 * size - 8 + (2 * size - i) + 1] = matrix.get(matrixOffset + size - 1 - flip, matrixOffset + i / 2 - 1);
                rawbits[rawbitsOffset + 6 * size - 12 + (2 * size - i) + 1] = matrix.get(matrixOffset + i / 2 - 1, matrixOffset + flip);
                flip = (flip + 1) % 2;
                --i;
            }
            matrixOffset += 2;
            rawbitsOffset += 8 * size - 16;
            --layer;
            size -= 4;
        }
        return rawbits;
    }

    private static BitMatrix removeDashedLines(BitMatrix matrix) {
        int nbDashed = 1 + 2 * ((matrix.getWidth() - 1) / 2 / 16);
        BitMatrix newMatrix = new BitMatrix(matrix.getWidth() - nbDashed, matrix.getHeight() - nbDashed);
        int nx = 0;
        int x = 0;
        while (x < matrix.getWidth()) {
            if ((matrix.getWidth() / 2 - x) % 16 != 0) {
                int ny = 0;
                int y = 0;
                while (y < matrix.getHeight()) {
                    if ((matrix.getWidth() / 2 - y) % 16 != 0) {
                        if (matrix.get(x, y)) {
                            newMatrix.set(nx, ny);
                        }
                        ++ny;
                    }
                    ++y;
                }
                ++nx;
            }
            ++x;
        }
        return newMatrix;
    }

    private static int readCode(boolean[] rawbits, int startIndex, int length) {
        int res = 0;
        int i = startIndex;
        while (i < startIndex + length) {
            res <<= 1;
            if (rawbits[i]) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    private static enum Table {
        UPPER,
        LOWER,
        MIXED,
        DIGIT,
        PUNCT,
        BINARY;

    }
}

