/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.AbstractJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.SymbolTable;
import com.alibaba.fastjson.parser.deserializer.DefaultObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.IntegerDeserializer;
import com.alibaba.fastjson.parser.deserializer.ListResolveFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.MapResolveFieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.parser.deserializer.StringDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJSONParser
extends AbstractJSONParser {
    protected final Object input;
    protected final SymbolTable symbolTable;
    protected ParserConfig config;
    private DefaultObjectDeserializer derializer = new DefaultObjectDeserializer();
    private static final Set<Class<?>> primitiveClasses = new HashSet();
    private String dateFormatPattern = JSON.DEFFAULT_DATE_FORMAT;
    private DateFormat dateFormat;
    protected final JSONLexer lexer;
    protected ParseContext context;
    private ParseContext[] contextArray = new ParseContext[8];
    private int contextArrayIndex = 0;
    private final List<ResolveTask> resolveTaskList = new ArrayList<ResolveTask>();
    public static final int NONE = 0;
    public static final int NeedToResolve = 1;
    public static final int TypeNameRedirect = 2;
    private int resolveStatus = 0;

    public String getDateFomartPattern() {
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormatPattern = dateFormat;
        this.dateFormat = null;
    }

    public void setDateFomrat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DefaultJSONParser(String input) {
        this(input, ParserConfig.getGlobalInstance(), JSON.DEFAULT_PARSER_FEATURE);
    }

    public DefaultJSONParser(String input, ParserConfig config) {
        this((Object)input, new JSONScanner(input, JSON.DEFAULT_PARSER_FEATURE), config);
    }

    public DefaultJSONParser(String input, ParserConfig config, int features) {
        this((Object)input, new JSONScanner(input, features), config);
    }

    public DefaultJSONParser(char[] input, int length, ParserConfig config, int features) {
        this(input, new JSONScanner(input, length, features), config);
    }

    public DefaultJSONParser(Object input, JSONLexer lexer, ParserConfig config) {
        this.lexer = lexer;
        this.input = input;
        this.config = config;
        this.symbolTable = config.getSymbolTable();
        lexer.nextToken(12);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public String getInput() {
        if (this.input instanceof char[]) {
            return new String((char[])this.input);
        }
        return this.input.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object parseObject(Map object, Object fieldName) {
        JSONScanner lexer = (JSONScanner)this.lexer;
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error, expect {, actual " + lexer.tokenName());
        }
        ParseContext context = this.getContext();
        try {
            Map map;
            Object key;
            char ch;
            boolean setContextFlag = false;
            while (true) {
                Object value;
                Object object2;
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (ch == ',') {
                        lexer.incrementBufferPosition();
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                    }
                }
                boolean isObjectKey = false;
                if (ch == '\"') {
                    key = lexer.scanSymbol(this.symbolTable, '\"');
                    lexer.skipWhitespace();
                    ch = lexer.getCurrent();
                    if (ch != ':') {
                        throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                    }
                } else {
                    if (ch == '}') {
                        lexer.incrementBufferPosition();
                        lexer.resetStringPosition();
                        lexer.nextToken();
                        Map map2 = object;
                        return map2;
                    }
                    if (ch == '\'') {
                        if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("syntax error");
                        }
                        key = lexer.scanSymbol(this.symbolTable, '\'');
                        lexer.skipWhitespace();
                        ch = lexer.getCurrent();
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos());
                        }
                    } else {
                        if (ch == '\u001a') {
                            throw new JSONException("syntax error");
                        }
                        if (ch == ',') {
                            throw new JSONException("syntax error");
                        }
                        if (ch >= '0' && ch <= '9' || ch == '-') {
                            lexer.resetStringPosition();
                            lexer.scanNumber();
                            key = lexer.token() == 2 ? (Number)lexer.integerValue() : (Number)lexer.decimalValue(true);
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
                            }
                        } else if (ch == '{' || ch == '[') {
                            lexer.nextToken();
                            key = this.parse();
                            isObjectKey = true;
                        } else {
                            if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
                                throw new JSONException("syntax error");
                            }
                            key = lexer.scanSymbolUnQuoted(this.symbolTable);
                            lexer.skipWhitespace();
                            ch = lexer.getCurrent();
                            if (ch != ':') {
                                throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
                            }
                        }
                    }
                }
                if (!isObjectKey) {
                    lexer.incrementBufferPosition();
                    lexer.skipWhitespace();
                }
                ch = lexer.getCurrent();
                lexer.resetStringPosition();
                if (key == "@type") {
                    String typeName = lexer.scanSymbol(this.symbolTable, '\"');
                    Class<?> clazz = TypeUtils.loadClass(typeName);
                    if (clazz == null) {
                        object.put("@type", typeName);
                        continue;
                    }
                    lexer.nextToken(16);
                    if (lexer.token() == 13) {
                        lexer.nextToken(16);
                        try {
                            object2 = clazz.newInstance();
                            return object2;
                        }
                        catch (Exception e) {
                            throw new JSONException("create instance error", e);
                        }
                    }
                    this.setResolveStatus(2);
                    if (this.context != null && !(fieldName instanceof Integer)) {
                        this.popContext();
                    }
                    ObjectDeserializer deserializer = this.config.getDeserializer(clazz);
                    Object t = deserializer.deserialze(this, clazz, fieldName);
                    return t;
                }
                if (key == "$ref") {
                    Object rootContext;
                    lexer.nextToken(4);
                    if (lexer.token() != 4) throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                    String ref = lexer.stringVal();
                    lexer.nextToken(13);
                    Object refValue = null;
                    if ("@".equals(ref)) {
                        if (this.getContext() != null) {
                            refValue = this.getContext().getObject();
                        }
                    } else if ("..".equals(ref)) {
                        ParseContext parentContext = context.getParentContext();
                        if (parentContext.getObject() != null) {
                            refValue = this.getContext().getObject();
                        } else {
                            this.addResolveTask(new ResolveTask(parentContext, ref));
                            this.setResolveStatus(1);
                        }
                    } else if ("$".equals(ref)) {
                        rootContext = context;
                        while (((ParseContext)rootContext).getParentContext() != null) {
                            rootContext = ((ParseContext)rootContext).getParentContext();
                        }
                        if (((ParseContext)rootContext).getObject() != null) {
                            refValue = ((ParseContext)rootContext).getObject();
                        } else {
                            this.addResolveTask(new ResolveTask((ParseContext)rootContext, ref));
                            this.setResolveStatus(1);
                        }
                    } else {
                        this.addResolveTask(new ResolveTask(context, ref));
                        this.setResolveStatus(1);
                    }
                    if (lexer.token() != 13) {
                        throw new JSONException("syntax error");
                    }
                    lexer.nextToken(16);
                    rootContext = refValue;
                    return rootContext;
                }
                if (!setContextFlag) {
                    this.setContext(object, fieldName);
                    setContextFlag = true;
                }
                if (ch == '\"') {
                    JSONScanner iso8601Lexer;
                    lexer.scanString();
                    String strValue = lexer.stringVal();
                    value = strValue;
                    if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(strValue)).scanISO8601DateIfMatch()) {
                        value = iso8601Lexer.getCalendar().getTime();
                    }
                    if (object.getClass() == JSONObject.class) {
                        object.put(key.toString(), value);
                    } else {
                        object.put(key, value);
                    }
                } else if (ch >= '0' && ch <= '9' || ch == '-') {
                    lexer.scanNumber();
                    value = lexer.token() == 2 ? lexer.integerValue() : lexer.decimalValue();
                    object.put(key, value);
                } else {
                    if (ch == '[') {
                        lexer.nextToken();
                        JSONArray list = new JSONArray();
                        this.parseArray(list, key);
                        value = list;
                        object.put(key, value);
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            object2 = object;
                            return object2;
                        }
                        if (lexer.token() != 16) throw new JSONException("syntax error");
                        continue;
                    }
                    if (ch == '{') {
                        lexer.nextToken();
                        Object obj = this.parseObject(new JSONObject(), key);
                        this.checkMapResolve(object, key.toString());
                        if (object.getClass() == JSONObject.class) {
                            object.put(key.toString(), obj);
                        } else {
                            object.put(key, obj);
                        }
                        this.setContext(context, obj, key);
                        if (lexer.token() == 13) {
                            lexer.nextToken();
                            this.setContext(context);
                            object2 = object;
                            return object2;
                        }
                        if (lexer.token() != 16) throw new JSONException("syntax error, " + lexer.tokenName());
                        continue;
                    }
                    lexer.nextToken();
                    value = this.parse();
                    object.put(key, value);
                    if (lexer.token() == 13) {
                        lexer.nextToken();
                        map = object;
                        return map;
                    }
                    if (lexer.token() != 16) throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
                    continue;
                }
                lexer.skipWhitespace();
                ch = lexer.getCurrent();
                if (ch != ',') break;
                lexer.incrementBufferPosition();
            }
            if (ch != '}') throw new JSONException("syntax error, position at " + lexer.pos() + ", name " + key);
            lexer.incrementBufferPosition();
            lexer.resetStringPosition();
            lexer.nextToken();
            this.setContext(object, fieldName);
            map = object;
            return map;
        }
        finally {
            this.setContext(context);
        }
    }

    public ParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(ParserConfig config) {
        this.config = config;
    }

    public <T> T parseObject(Class<T> clazz) {
        return this.parseObject((Type)clazz);
    }

    public <T> T parseObject(Type type) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        ObjectDeserializer derializer = this.config.getDeserializer(type);
        try {
            return derializer.deserialze(this, type, null);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    public <T> List<T> parseArray(Class<T> clazz) {
        ArrayList array = new ArrayList();
        this.parseArray(clazz, array);
        return array;
    }

    public void parseArray(Class<?> clazz, Collection array) {
        this.parseArray((Type)clazz, array);
    }

    public void parseArray(Type type, Collection array) {
        this.parseArray(type, array, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArray(Type type, Collection array, Object fieldName) {
        if (this.lexer.token() == 21 || this.lexer.token() == 22) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + JSONToken.name(this.lexer.token()));
        }
        ObjectDeserializer deserializer = null;
        if (Integer.TYPE == type) {
            deserializer = IntegerDeserializer.instance;
            this.lexer.nextToken(2);
        } else if (String.class == type) {
            deserializer = StringDeserializer.instance;
            this.lexer.nextToken(4);
        } else {
            deserializer = this.config.getDeserializer(type);
            this.lexer.nextToken(deserializer.getFastMatchToken());
        }
        ParseContext context = this.getContext();
        this.setContext(array, fieldName);
        try {
            int i = 0;
            while (true) {
                Object val;
                if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (this.lexer.token() == 16) {
                        this.lexer.nextToken();
                    }
                }
                if (this.lexer.token() == 15) {
                    break;
                }
                if (Integer.TYPE == type) {
                    val = IntegerDeserializer.deserialze(this);
                    array.add(val);
                } else if (String.class == type) {
                    String value;
                    if (this.lexer.token() == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        Object obj = this.parse();
                        value = obj == null ? null : obj.toString();
                    }
                    array.add(value);
                } else {
                    if (this.lexer.token() == 8) {
                        this.lexer.nextToken();
                        val = null;
                    } else {
                        val = deserializer.deserialze(this, type, i);
                    }
                    array.add(val);
                    this.checkListResolve(array);
                }
                if (this.lexer.token() == 16) {
                    this.lexer.nextToken(deserializer.getFastMatchToken());
                }
                ++i;
            }
        }
        finally {
            this.setContext(context);
        }
        this.lexer.nextToken(16);
    }

    public Object[] parseArray(Type[] types) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken(16);
            return null;
        }
        if (this.lexer.token() != 14) {
            throw new JSONException("syntax error : " + this.lexer.tokenName());
        }
        Object[] list = new Object[types.length];
        if (types.length == 0) {
            this.lexer.nextToken(15);
            if (this.lexer.token() != 15) {
                throw new JSONException("syntax error");
            }
            this.lexer.nextToken(16);
            return new Object[0];
        }
        this.lexer.nextToken(2);
        for (int i = 0; i < types.length; ++i) {
            Object value;
            if (this.lexer.token() == 8) {
                value = null;
                this.lexer.nextToken(16);
            } else {
                Type type = types[i];
                if (type == Integer.TYPE || type == Integer.class) {
                    if (this.lexer.token() == 2) {
                        value = this.lexer.intValue();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else if (type == String.class) {
                    if (this.lexer.token() == 4) {
                        value = this.lexer.stringVal();
                        this.lexer.nextToken(16);
                    } else {
                        value = this.parse();
                        value = TypeUtils.cast(value, type, this.config);
                    }
                } else {
                    boolean isArray = false;
                    Class<?> componentType = null;
                    if (i == types.length - 1 && type instanceof Class) {
                        Class clazz = (Class)type;
                        isArray = clazz.isArray();
                        componentType = clazz.getComponentType();
                    }
                    if (isArray && this.lexer.token() != 14) {
                        ArrayList varList = new ArrayList();
                        ObjectDeserializer derializer = this.config.getDeserializer(componentType);
                        int fastMatch = derializer.getFastMatchToken();
                        if (this.lexer.token() != 15) {
                            while (true) {
                                Object item = derializer.deserialze(this, type, null);
                                varList.add(item);
                                if (this.lexer.token() != 16) break;
                                this.lexer.nextToken(fastMatch);
                            }
                            if (this.lexer.token() != 15) {
                                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
                            }
                        }
                        value = TypeUtils.cast(varList, type, this.config);
                    } else {
                        ObjectDeserializer derializer = this.config.getDeserializer(type);
                        value = derializer.deserialze(this, type, null);
                    }
                }
            }
            list[i] = value;
            if (this.lexer.token() == 15) break;
            if (this.lexer.token() != 16) {
                throw new JSONException("syntax error :" + JSONToken.name(this.lexer.token()));
            }
            if (i == types.length - 1) {
                this.lexer.nextToken(15);
                continue;
            }
            this.lexer.nextToken(2);
        }
        if (this.lexer.token() != 15) {
            throw new JSONException("syntax error");
        }
        this.lexer.nextToken(16);
        return list;
    }

    public void parseObject(Object object) {
        this.derializer.parseObject(this, object);
    }

    public Object parseArrayWithType(Type collectionType) {
        if (this.lexer.token() == 8) {
            this.lexer.nextToken();
            return null;
        }
        Type[] actualTypes = ((ParameterizedType)collectionType).getActualTypeArguments();
        if (actualTypes.length != 1) {
            throw new JSONException("not support type " + collectionType);
        }
        Type actualTypeArgument = actualTypes[0];
        if (actualTypeArgument instanceof Class) {
            ArrayList array = new ArrayList();
            this.parseArray((Class)actualTypeArgument, array);
            return array;
        }
        if (actualTypeArgument instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            Type upperBoundType = wildcardType.getUpperBounds()[0];
            if (Object.class.equals((Object)upperBoundType)) {
                if (wildcardType.getLowerBounds().length == 0) {
                    return this.parse();
                }
                throw new JSONException("not support type : " + collectionType);
            }
            ArrayList array = new ArrayList();
            this.parseArray((Class)upperBoundType, array);
            return array;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length != 1) {
                throw new JSONException("not support : " + typeVariable);
            }
            Type boundType = bounds[0];
            if (boundType instanceof Class) {
                ArrayList array = new ArrayList();
                this.parseArray((Class)boundType, array);
                return array;
            }
        }
        if (actualTypeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualTypeArgument;
            ArrayList array = new ArrayList();
            this.parseArray(parameterizedType, array);
            return array;
        }
        throw new JSONException("TODO : " + collectionType);
    }

    public void acceptType(String typeName) {
        JSONScanner lexer = (JSONScanner)this.lexer;
        lexer.nextTokenWithColon();
        if (lexer.token() != 4) {
            throw new JSONException("type not match error");
        }
        if (typeName.equals(lexer.stringVal())) {
            lexer.nextToken();
            if (lexer.token() == 16) {
                lexer.nextToken();
            }
        } else {
            throw new JSONException("type not match error");
        }
    }

    public int getResolveStatus() {
        return this.resolveStatus;
    }

    public void setResolveStatus(int resolveStatus) {
        this.resolveStatus = resolveStatus;
    }

    public Object getObject(String path) {
        for (int i = 0; i < this.contextArrayIndex; ++i) {
            if (!path.equals(this.contextArray[i].getPath())) continue;
            return this.contextArray[i].getObject();
        }
        return null;
    }

    public void checkListResolve(Collection array) {
        if (this.resolveStatus == 1) {
            int index = array.size() - 1;
            List list = (List)array;
            ResolveTask task = this.getLastResolveTask();
            task.setFieldDeserializer(new ListResolveFieldDeserializer(this, list, index));
            task.setOwnerContext(this.context);
            this.setResolveStatus(0);
        }
    }

    public void checkMapResolve(Map object, String fieldName) {
        if (this.resolveStatus == 1) {
            MapResolveFieldDeserializer fieldResolver = new MapResolveFieldDeserializer(object, fieldName);
            ResolveTask task = this.getLastResolveTask();
            task.setFieldDeserializer(fieldResolver);
            task.setOwnerContext(this.context);
            this.setResolveStatus(0);
        }
    }

    public Object parseObject(Map object) {
        return this.parseObject(object, null);
    }

    public JSONObject parseObject() {
        JSONObject object = new JSONObject();
        this.parseObject(object);
        return object;
    }

    public final void parseArray(Collection array) {
        this.parseArray(array, null);
    }

    public final void parseArray(Collection array, Object fieldName) {
        JSONLexer lexer = this.getLexer();
        if (lexer.token() == 21 || lexer.token() == 22) {
            lexer.nextToken();
        }
        if (lexer.token() != 14) {
            throw new JSONException("syntax error, expect [, actual " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken(4);
        ParseContext context = this.getContext();
        this.setContext(array, fieldName);
        try {
            int i = 0;
            while (true) {
                Object value;
                if (this.isEnabled(Feature.AllowArbitraryCommas)) {
                    while (lexer.token() == 16) {
                        lexer.nextToken();
                    }
                }
                switch (lexer.token()) {
                    case 2: {
                        value = lexer.integerValue();
                        lexer.nextToken(16);
                        break;
                    }
                    case 3: {
                        value = lexer.isEnabled(Feature.UseBigDecimal) ? (Number)lexer.decimalValue(true) : (Number)lexer.decimalValue(false);
                        lexer.nextToken(16);
                        break;
                    }
                    case 4: {
                        String stringLiteral = lexer.stringVal();
                        lexer.nextToken(16);
                        if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                            JSONScanner iso8601Lexer = new JSONScanner(stringLiteral);
                            if (iso8601Lexer.scanISO8601DateIfMatch()) {
                                value = iso8601Lexer.getCalendar().getTime();
                                break;
                            }
                            value = stringLiteral;
                            break;
                        }
                        value = stringLiteral;
                        break;
                    }
                    case 6: {
                        value = Boolean.TRUE;
                        lexer.nextToken(16);
                        break;
                    }
                    case 7: {
                        value = Boolean.FALSE;
                        lexer.nextToken(16);
                        break;
                    }
                    case 12: {
                        JSONObject object = new JSONObject();
                        value = this.parseObject(object, i);
                        break;
                    }
                    case 14: {
                        JSONArray items = new JSONArray();
                        this.parseArray(items, i);
                        value = items;
                        break;
                    }
                    case 8: {
                        value = null;
                        lexer.nextToken(4);
                        break;
                    }
                    case 15: {
                        lexer.nextToken(16);
                        return;
                    }
                    default: {
                        value = this.parse();
                    }
                }
                array.add(value);
                this.checkListResolve(array);
                if (lexer.token() == 16) {
                    lexer.nextToken(4);
                }
                ++i;
            }
        }
        finally {
            this.setContext(context);
        }
    }

    public ParseContext getContext() {
        return this.context;
    }

    public List<ResolveTask> getResolveTaskList() {
        return this.resolveTaskList;
    }

    public void addResolveTask(ResolveTask task) {
        this.resolveTaskList.add(task);
    }

    public ResolveTask getLastResolveTask() {
        return this.resolveTaskList.get(this.resolveTaskList.size() - 1);
    }

    public void setContext(ParseContext context) {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = context;
    }

    public void popContext() {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return;
        }
        this.context = this.context.getParentContext();
        this.contextArray[this.contextArrayIndex - 1] = null;
        --this.contextArrayIndex;
    }

    public ParseContext setContext(Object object, Object fieldName) {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return null;
        }
        return this.setContext(this.context, object, fieldName);
    }

    public ParseContext setContext(ParseContext parent, Object object, Object fieldName) {
        if (this.isEnabled(Feature.DisableCircularReferenceDetect)) {
            return null;
        }
        if (this.lexer.isResetFlag()) {
            for (int i = 0; i < this.contextArrayIndex; ++i) {
                ParseContext item = this.contextArray[i];
                if (item.getParentContext() != parent || item.getFieldName() != fieldName) continue;
                this.context = item;
                this.context.setObject(object);
                this.clearChildContext(this.context, i + 1);
                break;
            }
            this.lexer.setResetFlag(false);
        } else {
            this.context = new ParseContext(parent, object, fieldName);
            this.addContext(this.context);
        }
        return this.context;
    }

    private void clearChildContext(ParseContext parent, int start) {
        for (int i = start; i < this.contextArrayIndex; ++i) {
            ParseContext item = this.contextArray[i];
            if (item.getParentContext() != parent) continue;
            int end = this.contextArrayIndex - 1;
            if (i != end) {
                System.arraycopy(this.contextArray, i + 1, this.contextArray, i, end - i);
            }
            this.contextArray[end] = null;
            --this.contextArrayIndex;
            this.clearChildContext(item, i + 1);
        }
    }

    private void addContext(ParseContext context) {
        int i;
        if ((i = this.contextArrayIndex++) >= this.contextArray.length) {
            int newLen = this.contextArray.length * 3 / 2;
            ParseContext[] newArray = new ParseContext[newLen];
            System.arraycopy(this.contextArray, 0, newArray, 0, this.contextArray.length);
            this.contextArray = newArray;
        }
        this.contextArray[i] = context;
    }

    public Object parse() {
        return this.parse(null);
    }

    public Object parse(Object fieldName) {
        JSONLexer lexer = this.getLexer();
        switch (lexer.token()) {
            case 21: {
                lexer.nextToken();
                HashSet set = new HashSet();
                this.parseArray(set, fieldName);
                return set;
            }
            case 22: {
                lexer.nextToken();
                TreeSet treeSet = new TreeSet();
                this.parseArray(treeSet, fieldName);
                return treeSet;
            }
            case 14: {
                JSONArray array = new JSONArray();
                this.parseArray(array, fieldName);
                return array;
            }
            case 12: {
                JSONObject object = new JSONObject();
                return this.parseObject(object, fieldName);
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                Number value = lexer.decimalValue(this.isEnabled(Feature.UseBigDecimal));
                lexer.nextToken();
                return value;
            }
            case 4: {
                JSONScanner iso8601Lexer;
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(stringLiteral)).scanISO8601DateIfMatch()) {
                    return iso8601Lexer.getCalendar().getTime();
                }
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                lexer.nextToken(18);
                if (lexer.token() != 18) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(10);
                this.accept(10);
                long time = lexer.integerValue().longValue();
                this.accept(2);
                this.accept(11);
                return new Date(time);
            }
            case 20: {
                if (lexer.isBlankInput()) {
                    return null;
                }
                throw new JSONException("unterminated json string, pos " + lexer.getBufferPosition());
            }
        }
        throw new JSONException("syntax error, pos " + lexer.getBufferPosition());
    }

    public void config(Feature feature, boolean state) {
        this.getLexer().config(feature, state);
    }

    public boolean isEnabled(Feature feature) {
        return this.getLexer().isEnabled(feature);
    }

    public JSONLexer getLexer() {
        return this.lexer;
    }

    public final void accept(int token) {
        JSONLexer lexer = this.getLexer();
        if (lexer.token() != token) {
            throw new JSONException("syntax error, expect " + JSONToken.name(token) + ", actual " + JSONToken.name(lexer.token()));
        }
        lexer.nextToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JSONLexer lexer = this.getLexer();
        try {
            if (this.isEnabled(Feature.AutoCloseSource) && !lexer.isEOF()) {
                throw new JSONException("not close json text, token : " + JSONToken.name(lexer.token()));
            }
        }
        finally {
            lexer.close();
        }
    }

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
    }

    public static class ResolveTask {
        private final ParseContext context;
        private final String referenceValue;
        private FieldDeserializer fieldDeserializer;
        private ParseContext ownerContext;

        public ResolveTask(ParseContext context, String referenceValue) {
            this.context = context;
            this.referenceValue = referenceValue;
        }

        public ParseContext getContext() {
            return this.context;
        }

        public String getReferenceValue() {
            return this.referenceValue;
        }

        public FieldDeserializer getFieldDeserializer() {
            return this.fieldDeserializer;
        }

        public void setFieldDeserializer(FieldDeserializer fieldDeserializer) {
            this.fieldDeserializer = fieldDeserializer;
        }

        public ParseContext getOwnerContext() {
            return this.ownerContext;
        }

        public void setOwnerContext(ParseContext ownerContext) {
            this.ownerContext = ownerContext;
        }
    }
}

