/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperMethod {
    private final SqlSession sqlSession;
    private final Configuration config;
    private final ObjectFactory objectFactory;
    private SqlCommandType type;
    private String commandName;
    private Class<?> declaringInterface;
    private Method method;
    private boolean returnsMany;
    private boolean returnsMap;
    private boolean returnsVoid;
    private String mapKey;
    private Integer resultHandlerIndex;
    private Integer rowBoundsIndex;
    private List<String> paramNames = new ArrayList<String>();
    private List<Integer> paramPositions = new ArrayList<Integer>();
    private boolean hasNamedParameters;

    public MapperMethod(Class<?> declaringInterface, Method method, SqlSession sqlSession) {
        this.sqlSession = sqlSession;
        this.method = method;
        this.config = sqlSession.getConfiguration();
        this.hasNamedParameters = false;
        this.declaringInterface = declaringInterface;
        this.objectFactory = this.config.getObjectFactory();
        this.setupFields();
        this.setupMethodSignature();
        this.setupCommandType();
        this.validateStatement();
    }

    public Object execute(Object[] args) {
        Map result = null;
        if (SqlCommandType.INSERT == this.type) {
            Object param = this.getParam(args);
            result = this.sqlSession.insert(this.commandName, param);
        } else if (SqlCommandType.UPDATE == this.type) {
            Object param = this.getParam(args);
            result = this.sqlSession.update(this.commandName, param);
        } else if (SqlCommandType.DELETE == this.type) {
            Object param = this.getParam(args);
            result = this.sqlSession.delete(this.commandName, param);
        } else if (SqlCommandType.SELECT == this.type) {
            if (this.returnsVoid && this.resultHandlerIndex != null) {
                this.executeWithResultHandler(args);
            } else if (this.returnsMany) {
                result = this.executeForMany(args);
            } else if (this.returnsMap) {
                result = this.executeForMap(args);
            } else {
                Object param = this.getParam(args);
                result = this.sqlSession.selectOne(this.commandName, param);
            }
        } else {
            throw new BindingException("Unknown execution method for: " + this.commandName);
        }
        return result;
    }

    private void executeWithResultHandler(Object[] args) {
        MappedStatement ms = this.config.getMappedStatement(this.commandName);
        if (Void.TYPE.equals(ms.getResultMaps().get(0).getType())) {
            throw new BindingException("method " + this.method.getName() + " needs either a @ResultMap annotation or a resultType attribute in XML so a ResultHandler can be used as a parameter.");
        }
        Object param = this.getParam(args);
        if (this.rowBoundsIndex != null) {
            RowBounds rowBounds = (RowBounds)args[this.rowBoundsIndex];
            this.sqlSession.select(this.commandName, param, rowBounds, (ResultHandler)args[this.resultHandlerIndex]);
        } else {
            this.sqlSession.select(this.commandName, param, (ResultHandler)args[this.resultHandlerIndex]);
        }
    }

    private <E> Object executeForMany(Object[] args) {
        List result;
        Object param = this.getParam(args);
        if (this.rowBoundsIndex != null) {
            RowBounds rowBounds = (RowBounds)args[this.rowBoundsIndex];
            result = this.sqlSession.selectList(this.commandName, param, rowBounds);
        } else {
            result = this.sqlSession.selectList(this.commandName, param);
        }
        if (!this.method.getReturnType().isAssignableFrom(result.getClass())) {
            if (this.method.getReturnType().isArray()) {
                return this.convertToArray(result);
            }
            return this.convertToDeclaredCollection(result);
        }
        return result;
    }

    private <E> Object convertToDeclaredCollection(List<E> list) {
        Object collection = this.objectFactory.create(this.method.getReturnType());
        MetaObject metaObject = this.config.newMetaObject(collection);
        metaObject.addAll(list);
        return collection;
    }

    private <E> E[] convertToArray(List<E> list) {
        Object[] array = (Object[])Array.newInstance(this.method.getReturnType().getComponentType(), list.size());
        array = list.toArray(array);
        return array;
    }

    private <K, V> Map<K, V> executeForMap(Object[] args) {
        Map result;
        Object param = this.getParam(args);
        if (this.rowBoundsIndex != null) {
            RowBounds rowBounds = (RowBounds)args[this.rowBoundsIndex];
            result = this.sqlSession.selectMap(this.commandName, param, this.mapKey, rowBounds);
        } else {
            result = this.sqlSession.selectMap(this.commandName, param, this.mapKey);
        }
        return result;
    }

    private Object getParam(Object[] args) {
        int i;
        int paramCount = this.paramPositions.size();
        if (args == null || paramCount == 0) {
            return null;
        }
        if (!this.hasNamedParameters && paramCount == 1) {
            return args[this.paramPositions.get(0)];
        }
        MapperParamMap<Object> param = new MapperParamMap<Object>();
        for (i = 0; i < paramCount; ++i) {
            param.put(this.paramNames.get(i), args[this.paramPositions.get(i)]);
        }
        for (i = 0; i < paramCount; ++i) {
            String genericParamName = "param" + String.valueOf(i + 1);
            if (param.containsKey(genericParamName)) continue;
            param.put(genericParamName, args[this.paramPositions.get(i)]);
        }
        return param;
    }

    private void setupFields() {
        this.commandName = this.declaringInterface.getName() + "." + this.method.getName();
    }

    private void setupMethodSignature() {
        MapKey mapKeyAnnotation;
        if (this.method.getReturnType().equals(Void.TYPE)) {
            this.returnsVoid = true;
        }
        if (this.objectFactory.isCollection(this.method.getReturnType()) || this.method.getReturnType().isArray()) {
            this.returnsMany = true;
        }
        if (Map.class.isAssignableFrom(this.method.getReturnType()) && (mapKeyAnnotation = this.method.getAnnotation(MapKey.class)) != null) {
            this.mapKey = mapKeyAnnotation.value();
            this.returnsMap = true;
        }
        Class<?>[] argTypes = this.method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (RowBounds.class.isAssignableFrom(argTypes[i])) {
                if (this.rowBoundsIndex == null) {
                    this.rowBoundsIndex = i;
                    continue;
                }
                throw new BindingException(this.method.getName() + " cannot have multiple RowBounds parameters");
            }
            if (ResultHandler.class.isAssignableFrom(argTypes[i])) {
                if (this.resultHandlerIndex == null) {
                    this.resultHandlerIndex = i;
                    continue;
                }
                throw new BindingException(this.method.getName() + " cannot have multiple ResultHandler parameters");
            }
            String paramName = String.valueOf(this.paramPositions.size());
            paramName = this.getParamNameFromAnnotation(i, paramName);
            this.paramNames.add(paramName);
            this.paramPositions.add(i);
        }
    }

    private String getParamNameFromAnnotation(int i, String paramName) {
        Annotation[] paramAnnos = this.method.getParameterAnnotations()[i];
        for (int j = 0; j < paramAnnos.length; ++j) {
            if (!(paramAnnos[j] instanceof Param)) continue;
            this.hasNamedParameters = true;
            paramName = ((Param)paramAnnos[j]).value();
        }
        return paramName;
    }

    private void setupCommandType() {
        MappedStatement ms = this.config.getMappedStatement(this.commandName);
        this.type = ms.getSqlCommandType();
        if (this.type == SqlCommandType.UNKNOWN) {
            throw new BindingException("Unknown execution method for: " + this.commandName);
        }
    }

    private void validateStatement() {
        try {
            this.config.getMappedStatement(this.commandName);
        }
        catch (Exception e) {
            throw new BindingException("Invalid bound statement (not found): " + this.commandName, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapperParamMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -2212268410512043556L;

        @Override
        public V get(Object key) {
            if (!super.containsKey(key)) {
                throw new BindingException("Parameter '" + key + "' not found. Available parameters are " + this.keySet());
            }
            return super.get(key);
        }
    }
}

