/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import java.util.Arrays;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    private static final int TABLE_UPPER = 0;
    private static final int TABLE_LOWER = 1;
    private static final int TABLE_DIGIT = 2;
    private static final int TABLE_MIXED = 3;
    private static final int TABLE_PUNCT = 4;
    private static final int TABLE_BINARY = 5;
    private static final int[][] CHAR_MAP = new int[5][256];
    private static final int[][] SHIFT_TABLE = new int[6][6];
    private static final int[][] LATCH_TABLE = new int[6][6];
    private static final int[] NB_BITS;
    private static final int[] NB_BITS_COMPACT;
    private static final int[] WORD_SIZE;

    static {
        Encoder.CHAR_MAP[0][32] = 1;
        int c = 65;
        while (c <= 90) {
            Encoder.CHAR_MAP[0][c] = c - 65 + 2;
            ++c;
        }
        Encoder.CHAR_MAP[1][32] = 1;
        c = 97;
        while (c <= 122) {
            Encoder.CHAR_MAP[1][c] = c - 97 + 2;
            ++c;
        }
        Encoder.CHAR_MAP[2][32] = 1;
        c = 48;
        while (c <= 57) {
            Encoder.CHAR_MAP[2][c] = c - 48 + 2;
            ++c;
        }
        Encoder.CHAR_MAP[2][44] = 12;
        Encoder.CHAR_MAP[2][46] = 13;
        int[] nArray = new int[28];
        nArray[1] = 32;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 5;
        nArray[7] = 6;
        nArray[8] = 7;
        nArray[9] = 8;
        nArray[10] = 9;
        nArray[11] = 10;
        nArray[12] = 11;
        nArray[13] = 12;
        nArray[14] = 13;
        nArray[15] = 27;
        nArray[16] = 28;
        nArray[17] = 29;
        nArray[18] = 30;
        nArray[19] = 31;
        nArray[20] = 64;
        nArray[21] = 92;
        nArray[22] = 94;
        nArray[23] = 95;
        nArray[24] = 96;
        nArray[25] = 124;
        nArray[26] = 126;
        nArray[27] = 127;
        int[] mixedTable = nArray;
        int i = 0;
        while (i < mixedTable.length) {
            Encoder.CHAR_MAP[3][mixedTable[i]] = i;
            ++i;
        }
        int[] nArray2 = new int[31];
        nArray2[1] = 13;
        nArray2[6] = 33;
        nArray2[7] = 39;
        nArray2[8] = 35;
        nArray2[9] = 36;
        nArray2[10] = 37;
        nArray2[11] = 38;
        nArray2[12] = 39;
        nArray2[13] = 40;
        nArray2[14] = 41;
        nArray2[15] = 42;
        nArray2[16] = 43;
        nArray2[17] = 44;
        nArray2[18] = 45;
        nArray2[19] = 46;
        nArray2[20] = 47;
        nArray2[21] = 58;
        nArray2[22] = 59;
        nArray2[23] = 60;
        nArray2[24] = 61;
        nArray2[25] = 62;
        nArray2[26] = 63;
        nArray2[27] = 91;
        nArray2[28] = 93;
        nArray2[29] = 123;
        nArray2[30] = 125;
        int[] punctTable = nArray2;
        int i2 = 0;
        while (i2 < punctTable.length) {
            if (punctTable[i2] > 0) {
                Encoder.CHAR_MAP[4][punctTable[i2]] = i2;
            }
            ++i2;
        }
        int[][] nArray3 = SHIFT_TABLE;
        int n = SHIFT_TABLE.length;
        int n2 = 0;
        while (n2 < n) {
            int[] table = nArray3[n2];
            Arrays.fill(table, -1);
            ++n2;
        }
        nArray3 = LATCH_TABLE;
        n = LATCH_TABLE.length;
        n2 = 0;
        while (n2 < n) {
            int[] table = nArray3[n2];
            Arrays.fill(table, -1);
            ++n2;
        }
        Encoder.SHIFT_TABLE[0][4] = 0;
        Encoder.LATCH_TABLE[0][1] = 28;
        Encoder.LATCH_TABLE[0][3] = 29;
        Encoder.LATCH_TABLE[0][2] = 30;
        Encoder.SHIFT_TABLE[0][5] = 31;
        Encoder.SHIFT_TABLE[1][4] = 0;
        Encoder.SHIFT_TABLE[1][0] = 28;
        Encoder.LATCH_TABLE[1][3] = 29;
        Encoder.LATCH_TABLE[1][2] = 30;
        Encoder.SHIFT_TABLE[1][5] = 31;
        Encoder.SHIFT_TABLE[3][4] = 0;
        Encoder.LATCH_TABLE[3][1] = 28;
        Encoder.LATCH_TABLE[3][0] = 29;
        Encoder.LATCH_TABLE[3][4] = 30;
        Encoder.SHIFT_TABLE[3][5] = 31;
        Encoder.LATCH_TABLE[4][0] = 31;
        Encoder.SHIFT_TABLE[2][4] = 0;
        Encoder.LATCH_TABLE[2][0] = 30;
        Encoder.SHIFT_TABLE[2][0] = 31;
        NB_BITS_COMPACT = new int[5];
        i = 1;
        while (i < NB_BITS_COMPACT.length) {
            Encoder.NB_BITS_COMPACT[i] = (88 + 16 * i) * i;
            ++i;
        }
        NB_BITS = new int[33];
        i = 1;
        while (i < NB_BITS.length) {
            Encoder.NB_BITS[i] = (112 + 16 * i) * i;
            ++i;
        }
        WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    }

    private Encoder() {
    }

    public static AztecCode encode(byte[] data) {
        return Encoder.encode(data, 33);
    }

    public static AztecCode encode(byte[] data, int minECCPercent) {
        int matrixSize;
        BitArray bits = Encoder.highLevelEncode(data);
        int eccBits = bits.getSize() * minECCPercent / 100 + 11;
        int totalSizeBits = bits.getSize() + eccBits;
        int wordSize = 0;
        int totalSymbolBits = 0;
        BitArray stuffedBits = null;
        int layers = 1;
        while (layers < NB_BITS_COMPACT.length) {
            if (NB_BITS_COMPACT[layers] >= totalSizeBits) {
                if (wordSize != WORD_SIZE[layers]) {
                    wordSize = WORD_SIZE[layers];
                    stuffedBits = Encoder.stuffBits(bits, wordSize);
                }
                totalSymbolBits = NB_BITS_COMPACT[layers];
                if (stuffedBits.getSize() + eccBits <= NB_BITS_COMPACT[layers]) break;
            }
            ++layers;
        }
        boolean compact = true;
        if (layers == NB_BITS_COMPACT.length) {
            compact = false;
            layers = 1;
            while (layers < NB_BITS.length) {
                if (NB_BITS[layers] >= totalSizeBits) {
                    if (wordSize != WORD_SIZE[layers]) {
                        wordSize = WORD_SIZE[layers];
                        stuffedBits = Encoder.stuffBits(bits, wordSize);
                    }
                    totalSymbolBits = NB_BITS[layers];
                    if (stuffedBits.getSize() + eccBits <= NB_BITS[layers]) break;
                }
                ++layers;
            }
        }
        if (layers == NB_BITS.length) {
            throw new IllegalArgumentException("Data too large for an Aztec code");
        }
        int messageSizeInWords = (stuffedBits.getSize() + wordSize - 1) / wordSize;
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.getGF(wordSize));
        int totalSizeInFullWords = totalSymbolBits / wordSize;
        int[] messageWords = Encoder.bitsToWords(stuffedBits, wordSize, totalSizeInFullWords);
        rs.encode(messageWords, totalSizeInFullWords - messageSizeInWords);
        int startPad = totalSymbolBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.appendBits(0, startPad);
        int[] nArray = messageWords;
        int n = messageWords.length;
        int n2 = 0;
        while (n2 < n) {
            int messageWord = nArray[n2];
            messageBits.appendBits(messageWord, wordSize);
            ++n2;
        }
        BitArray modeMessage = Encoder.generateModeMessage(compact, layers, messageSizeInWords);
        int baseMatrixSize = compact ? 11 + layers * 4 : 14 + layers * 4;
        int[] alignmentMap = new int[baseMatrixSize];
        if (compact) {
            matrixSize = baseMatrixSize;
            int i = 0;
            while (i < alignmentMap.length) {
                alignmentMap[i] = i;
                ++i;
            }
        } else {
            matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center = matrixSize / 2;
            int i = 0;
            while (i < origCenter) {
                int newOffset = i + i / 15;
                alignmentMap[origCenter - i - 1] = center - newOffset - 1;
                alignmentMap[origCenter + i] = center + newOffset + 1;
                ++i;
            }
        }
        BitMatrix matrix = new BitMatrix(matrixSize);
        int i = 0;
        int rowOffset = 0;
        while (i < layers) {
            int rowSize = compact ? (layers - i) * 4 + 9 : (layers - i) * 4 + 12;
            int j = 0;
            while (j < rowSize) {
                int columnOffset = j * 2;
                int k = 0;
                while (k < 2) {
                    if (messageBits.get(rowOffset + columnOffset + k)) {
                        matrix.set(alignmentMap[i * 2 + k], alignmentMap[i * 2 + j]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 2 + columnOffset + k)) {
                        matrix.set(alignmentMap[i * 2 + j], alignmentMap[baseMatrixSize - 1 - i * 2 - k]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 4 + columnOffset + k)) {
                        matrix.set(alignmentMap[baseMatrixSize - 1 - i * 2 - k], alignmentMap[baseMatrixSize - 1 - i * 2 - j]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 6 + columnOffset + k)) {
                        matrix.set(alignmentMap[baseMatrixSize - 1 - i * 2 - j], alignmentMap[i * 2 + k]);
                    }
                    ++k;
                }
                ++j;
            }
            rowOffset += rowSize * 8;
            ++i;
        }
        Encoder.drawModeMessage(matrix, compact, matrixSize, modeMessage);
        if (compact) {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 5);
        } else {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 7);
            i = 0;
            int j = 0;
            while (i < baseMatrixSize / 2 - 1) {
                int k = matrixSize / 2 & 1;
                while (k < matrixSize) {
                    matrix.set(matrixSize / 2 - j, k);
                    matrix.set(matrixSize / 2 + j, k);
                    matrix.set(k, matrixSize / 2 - j);
                    matrix.set(k, matrixSize / 2 + j);
                    k += 2;
                }
                i += 15;
                j += 16;
            }
        }
        AztecCode aztec = new AztecCode();
        aztec.setCompact(compact);
        aztec.setSize(matrixSize);
        aztec.setLayers(layers);
        aztec.setCodeWords(messageSizeInWords);
        aztec.setMatrix(matrix);
        return aztec;
    }

    static void drawBullsEye(BitMatrix matrix, int center, int size) {
        int i = 0;
        while (i < size) {
            int j = center - i;
            while (j <= center + i) {
                matrix.set(j, center - i);
                matrix.set(j, center + i);
                matrix.set(center - i, j);
                matrix.set(center + i, j);
                ++j;
            }
            i += 2;
        }
        matrix.set(center - size, center - size);
        matrix.set(center - size + 1, center - size);
        matrix.set(center - size, center - size + 1);
        matrix.set(center + size, center - size);
        matrix.set(center + size, center - size + 1);
        matrix.set(center + size, center + size - 1);
    }

    static BitArray generateModeMessage(boolean compact, int layers, int messageSizeInWords) {
        BitArray modeMessage = new BitArray();
        if (compact) {
            modeMessage.appendBits(layers - 1, 2);
            modeMessage.appendBits(messageSizeInWords - 1, 6);
            modeMessage = Encoder.generateCheckWords(modeMessage, 28, 4);
        } else {
            modeMessage.appendBits(layers - 1, 5);
            modeMessage.appendBits(messageSizeInWords - 1, 11);
            modeMessage = Encoder.generateCheckWords(modeMessage, 40, 4);
        }
        return modeMessage;
    }

    static void drawModeMessage(BitMatrix matrix, boolean compact, int matrixSize, BitArray modeMessage) {
        if (compact) {
            int i = 0;
            while (i < 7) {
                if (modeMessage.get(i)) {
                    matrix.set(matrixSize / 2 - 3 + i, matrixSize / 2 - 5);
                }
                if (modeMessage.get(i + 7)) {
                    matrix.set(matrixSize / 2 + 5, matrixSize / 2 - 3 + i);
                }
                if (modeMessage.get(20 - i)) {
                    matrix.set(matrixSize / 2 - 3 + i, matrixSize / 2 + 5);
                }
                if (modeMessage.get(27 - i)) {
                    matrix.set(matrixSize / 2 - 5, matrixSize / 2 - 3 + i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 10) {
                if (modeMessage.get(i)) {
                    matrix.set(matrixSize / 2 - 5 + i + i / 5, matrixSize / 2 - 7);
                }
                if (modeMessage.get(i + 10)) {
                    matrix.set(matrixSize / 2 + 7, matrixSize / 2 - 5 + i + i / 5);
                }
                if (modeMessage.get(29 - i)) {
                    matrix.set(matrixSize / 2 - 5 + i + i / 5, matrixSize / 2 + 7);
                }
                if (modeMessage.get(39 - i)) {
                    matrix.set(matrixSize / 2 - 7, matrixSize / 2 - 5 + i + i / 5);
                }
                ++i;
            }
        }
    }

    static BitArray generateCheckWords(BitArray stuffedBits, int totalSymbolBits, int wordSize) {
        int messageSizeInWords = (stuffedBits.getSize() + wordSize - 1) / wordSize;
        int i = messageSizeInWords * wordSize - stuffedBits.getSize();
        while (i > 0) {
            stuffedBits.appendBit(true);
            --i;
        }
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.getGF(wordSize));
        int totalSizeInFullWords = totalSymbolBits / wordSize;
        int[] messageWords = Encoder.bitsToWords(stuffedBits, wordSize, totalSizeInFullWords);
        rs.encode(messageWords, totalSizeInFullWords - messageSizeInWords);
        int startPad = totalSymbolBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.appendBits(0, startPad);
        int[] nArray = messageWords;
        int n = messageWords.length;
        int n2 = 0;
        while (n2 < n) {
            int messageWord = nArray[n2];
            messageBits.appendBits(messageWord, wordSize);
            ++n2;
        }
        return messageBits;
    }

    static int[] bitsToWords(BitArray stuffedBits, int wordSize, int totalWords) {
        int[] message = new int[totalWords];
        int i = 0;
        int n = stuffedBits.getSize() / wordSize;
        while (i < n) {
            int value = 0;
            int j = 0;
            while (j < wordSize) {
                value |= stuffedBits.get(i * wordSize + j) ? 1 << wordSize - j - 1 : 0;
                ++j;
            }
            message[i] = value;
            ++i;
        }
        return message;
    }

    static GenericGF getGF(int wordSize) {
        switch (wordSize) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        return null;
    }

    static BitArray stuffBits(BitArray bits, int wordSize) {
        BitArray out = new BitArray();
        int n = bits.getSize();
        int mask = (1 << wordSize) - 2;
        int i = 0;
        while (i < n) {
            int word = 0;
            int j = 0;
            while (j < wordSize) {
                if (i + j >= n || bits.get(i + j)) {
                    word |= 1 << wordSize - 1 - j;
                }
                ++j;
            }
            if ((word & mask) == mask) {
                out.appendBits(word & mask, wordSize);
                --i;
            } else if ((word & mask) == 0) {
                out.appendBits(word | 1, wordSize);
                --i;
            } else {
                out.appendBits(word, wordSize);
            }
            i += wordSize;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    static BitArray highLevelEncode(byte[] data) {
        bits = new BitArray();
        mode = 0;
        idx = new int[5];
        idxnext = new int[5];
        i = 0;
        while (i < data.length) {
            block37: {
                block41: {
                    block40: {
                        block39: {
                            block35: {
                                block38: {
                                    block36: {
                                        c = data[i] & 255;
                                        next = i < data.length - 1 ? data[i + 1] & 255 : 0;
                                        punctWord = 0;
                                        if (c == 13 && next == 10) {
                                            punctWord = 2;
                                        } else if (c == 46 && next == 32) {
                                            punctWord = 3;
                                        } else if (c == 44 && next == 32) {
                                            punctWord = 4;
                                        } else if (c == 58 && next == 32) {
                                            punctWord = 5;
                                        }
                                        if (punctWord <= 0) break block35;
                                        if (mode != 4) break block36;
                                        Encoder.outputWord(bits, 4, punctWord);
                                        ++i;
                                        break block37;
                                    }
                                    if (Encoder.SHIFT_TABLE[mode][4] < 0) break block38;
                                    Encoder.outputWord(bits, mode, Encoder.SHIFT_TABLE[mode][4]);
                                    Encoder.outputWord(bits, 4, punctWord);
                                    ++i;
                                    break block37;
                                }
                                if (Encoder.LATCH_TABLE[mode][4] < 0) break block35;
                                Encoder.outputWord(bits, mode, Encoder.LATCH_TABLE[mode][4]);
                                Encoder.outputWord(bits, 4, punctWord);
                                mode = 4;
                                ++i;
                                break block37;
                            }
                            firstMatch = -1;
                            shiftMode = -1;
                            latchMode = -1;
                            j = 0;
                            while (j < 5) {
                                idx[j] = Encoder.CHAR_MAP[j][c];
                                if (idx[j] > 0 && firstMatch < 0) {
                                    firstMatch = j;
                                }
                                if (shiftMode < 0 && idx[j] > 0 && Encoder.SHIFT_TABLE[mode][j] >= 0) {
                                    shiftMode = j;
                                }
                                idxnext[j] = Encoder.CHAR_MAP[j][next];
                                if (latchMode < 0 && idx[j] > 0 && (next == 0 || idxnext[j] > 0) && Encoder.LATCH_TABLE[mode][j] >= 0) {
                                    latchMode = j;
                                }
                                ++j;
                            }
                            if (shiftMode < 0 && latchMode < 0) {
                                j = 0;
                                while (j < 5) {
                                    if (idx[j] > 0 && Encoder.LATCH_TABLE[mode][j] >= 0) {
                                        latchMode = j;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            if (idx[mode] <= 0) break block39;
                            Encoder.outputWord(bits, mode, idx[mode]);
                            break block37;
                        }
                        if (latchMode < 0) break block40;
                        Encoder.outputWord(bits, mode, Encoder.LATCH_TABLE[mode][latchMode]);
                        Encoder.outputWord(bits, latchMode, idx[latchMode]);
                        mode = latchMode;
                        break block37;
                    }
                    if (shiftMode < 0) break block41;
                    Encoder.outputWord(bits, mode, Encoder.SHIFT_TABLE[mode][shiftMode]);
                    Encoder.outputWord(bits, shiftMode, idx[shiftMode]);
                    break block37;
                }
                if (firstMatch < 0) ** GOTO lbl-1000
                if (mode == 4) {
                    Encoder.outputWord(bits, 4, Encoder.LATCH_TABLE[4][0]);
                    mode = 0;
                    --i;
                } else if (mode == 2) {
                    Encoder.outputWord(bits, 2, Encoder.LATCH_TABLE[2][0]);
                    mode = 0;
                    --i;
                } else lbl-1000:
                // 2 sources

                {
                    k = i + 1;
                    lookahead = 0;
                    while (k < data.length) {
                        next = data[k] & 255;
                        binary = true;
                        j = 0;
                        while (j < 5) {
                            if (Encoder.CHAR_MAP[j][next] > 0) {
                                binary = false;
                                break;
                            }
                            ++j;
                        }
                        if (binary) {
                            lookahead = 0;
                        } else {
                            if (lookahead >= 1) {
                                k -= lookahead;
                                break;
                            }
                            ++lookahead;
                        }
                        ++k;
                    }
                    k -= i;
                    switch (mode) {
                        case 0: 
                        case 1: 
                        case 3: {
                            Encoder.outputWord(bits, mode, Encoder.SHIFT_TABLE[mode][5]);
                            break;
                        }
                        case 2: {
                            Encoder.outputWord(bits, mode, Encoder.LATCH_TABLE[mode][0]);
                            mode = 0;
                            Encoder.outputWord(bits, mode, Encoder.SHIFT_TABLE[mode][5]);
                            break;
                        }
                        case 4: {
                            Encoder.outputWord(bits, mode, Encoder.LATCH_TABLE[mode][0]);
                            mode = 0;
                            Encoder.outputWord(bits, mode, Encoder.SHIFT_TABLE[mode][5]);
                        }
                    }
                    if (k >= 32 && k < 63) {
                        k = 31;
                    }
                    if (k > 542) {
                        k = 542;
                    }
                    if (k < 32) {
                        bits.appendBits(k, 5);
                    } else {
                        bits.appendBits(k - 31, 16);
                    }
                    while (k > 0) {
                        bits.appendBits(data[i], 8);
                        --k;
                        ++i;
                    }
                    --i;
                }
            }
            ++i;
        }
        return bits;
    }

    static void outputWord(BitArray bits, int mode, int value) {
        if (mode == 2) {
            bits.appendBits(value, 4);
        } else if (mode < 5) {
            bits.appendBits(value, 5);
        } else {
            bits.appendBits(value, 8);
        }
    }
}

