/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS;
    private final int[] decodeMiddleCounters = new int[4];

    static {
        int[] nArray = new int[10];
        nArray[1] = 11;
        nArray[2] = 13;
        nArray[3] = 14;
        nArray[4] = 19;
        nArray[5] = 25;
        nArray[6] = 28;
        nArray[7] = 21;
        nArray[8] = 22;
        nArray[9] = 26;
        FIRST_DIGIT_ENCODINGS = nArray;
    }

    @Override
    protected int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        int n;
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        int x = 0;
        while (x < 6 && rowOffset < end) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            n = counters.length;
            int n2 = 0;
            while (n2 < n) {
                int counter = nArray[n2];
                rowOffset += counter;
                ++n2;
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << 5 - x;
            }
            ++x;
        }
        EAN13Reader.determineFirstDigit(resultString, lgPatternFound);
        int[] middleRange = EAN13Reader.findGuardPattern(row, rowOffset, true, MIDDLE_PATTERN);
        rowOffset = middleRange[1];
        int x2 = 0;
        while (x2 < 6 && rowOffset < end) {
            int bestMatch = EAN13Reader.decodeDigit(row, counters, rowOffset, L_PATTERNS);
            resultString.append((char)(48 + bestMatch));
            int[] nArray = counters;
            int n3 = counters.length;
            n = 0;
            while (n < n3) {
                int counter = nArray[n];
                rowOffset += counter;
                ++n;
            }
            ++x2;
        }
        return rowOffset;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuilder resultString, int lgPatternFound) throws NotFoundException {
        int d = 0;
        while (d < 10) {
            if (lgPatternFound == FIRST_DIGIT_ENCODINGS[d]) {
                resultString.insert(0, (char)(48 + d));
                return;
            }
            ++d;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

