/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.datamatrix.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version) {
        int i;
        Version.ECB[] ecBlockArray;
        Version.ECBlocks ecBlocks = version.getECBlocks();
        int totalBlocks = 0;
        Version.ECB[] eCBArray = ecBlockArray = ecBlocks.getECBlocks();
        int n = ecBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version.ECB ecBlock = eCBArray[n2];
            totalBlocks += ecBlock.getCount();
            ++n2;
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        Version.ECB[] eCBArray2 = ecBlockArray;
        int n3 = ecBlockArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Version.ECB ecBlock = eCBArray2[n4];
            i = 0;
            while (i < ecBlock.getCount()) {
                int numDataCodewords = ecBlock.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewords() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
                ++i;
            }
            ++n4;
        }
        int longerBlocksTotalCodewords = result[0].codewords.length;
        int longerBlocksNumDataCodewords = longerBlocksTotalCodewords - ecBlocks.getECCodewords();
        int shorterBlocksNumDataCodewords = longerBlocksNumDataCodewords - 1;
        int rawCodewordsOffset = 0;
        i = 0;
        while (i < shorterBlocksNumDataCodewords) {
            int j = 0;
            while (j < numResultBlocks) {
                result[j].codewords[i] = rawCodewords[rawCodewordsOffset++];
                ++j;
            }
            ++i;
        }
        boolean specialVersion = version.getVersionNumber() == 24;
        int numLongerBlocks = specialVersion ? 8 : numResultBlocks;
        int j = 0;
        while (j < numLongerBlocks) {
            result[j].codewords[longerBlocksNumDataCodewords - 1] = rawCodewords[rawCodewordsOffset++];
            ++j;
        }
        int max = result[0].codewords.length;
        int i2 = longerBlocksNumDataCodewords;
        while (i2 < max) {
            int j2 = 0;
            while (j2 < numResultBlocks) {
                int iOffset = specialVersion && j2 > 7 ? i2 - 1 : i2;
                result[j2].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
                ++j2;
            }
            ++i2;
        }
        if (rawCodewordsOffset != rawCodewords.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

