/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.io.IOException;
import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsFrameFormat;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.AbstractHttpSockJsSession;

public class StreamingSockJsSession
extends AbstractHttpSockJsSession {
    private int byteCount;

    public StreamingSockJsSession(String sessionId, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        super(sessionId, config, wsHandler, attributes);
    }

    @Override
    public void handleInitialRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) throws SockJsException {
        super.handleInitialRequest(request, response, frameFormat);
        if (!this.isClosed()) {
            super.startAsyncRequest();
        }
    }

    @Override
    protected void flushCache() throws SockJsTransportFailureException {
        this.cancelHeartbeat();
        do {
            String message = this.getMessageCache().poll();
            SockJsMessageCodec messageCodec = this.getSockJsServiceConfig().getMessageCodec();
            SockJsFrame frame = SockJsFrame.messageFrame(messageCodec, message);
            this.writeFrame(frame);
            this.byteCount += frame.getContentBytes().length + 1;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.byteCount + " bytes written so far, " + this.getMessageCache().size() + " more messages not flushed"));
            }
            if (this.byteCount < this.getSockJsServiceConfig().getStreamBytesLimit()) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Streamed bytes limit reached. Recycling current request");
            }
            this.resetRequest();
            break;
        } while (!this.getMessageCache().isEmpty());
        this.scheduleHeartbeat();
    }

    @Override
    protected void resetRequest() {
        super.resetRequest();
        this.byteCount = 0;
    }

    @Override
    protected void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.isActive()) {
            super.writeFrameInternal(frame);
            this.getResponse().flush();
        }
    }
}

