/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import snaq.db.ConnectionPoolManager;

public class SQLUpdate {
    protected static final Log logger = LogFactory.getLog(SQLUpdate.class);
    private static final String LSEP = System.getProperty("line.separator");
    private ConnectionPoolManager cpm = ConnectionPoolManager.getInstance();
    private Connection con;
    private Statement statement;

    public SQLUpdate(String db) throws IOException {
    }

    private void openConnection(String poolname) throws SQLException {
        if (poolname == null || poolname.equals("")) {
            throw new SQLException("Please specify the name of a defined connection pool");
        }
        try {
            this.con = this.cpm.getConnection(poolname);
            this.statement = this.con.createStatement();
        }
        catch (SQLException sqlx) {
            try {
                this.statement.close();
            }
            catch (SQLException sqlx2) {
                // empty catch block
            }
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeConnection() {
        try {
            this.statement.close();
        }
        catch (SQLException sqlx) {
            sqlx.printStackTrace();
        }
        try {
            this.con.close();
        }
        catch (SQLException sqlx) {
            sqlx.printStackTrace();
        }
        this.cpm.release();
    }

    private void doStatement(String sql) throws SQLException {
        try {
            logger.debug((Object)("SQL: " + sql));
            this.statement.executeUpdate(sql);
        }
        catch (SQLException sqlx) {
            logger.info((Object)sqlx.getMessage(), (Throwable)sqlx);
            throw sqlx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextFile(File f) throws IOException {
        FileInputStream fis = null;
        try {
            int n;
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            fis = new FileInputStream(f);
            byte[] b = new byte[4096];
            while ((n = fis.read(b)) != -1) {
                bao.write(b, 0, n);
            }
            String string = new String(bao.toByteArray());
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String[] splitSQL(String text, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (separator == null) {
            StringTokenizer st = new StringTokenizer(text, "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("#") || token.equals("")) continue;
                list.add(token);
            }
        } else {
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(text, "\n\r");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.startsWith("#") || line.startsWith("--")) {
                    sb.setLength(0);
                    continue;
                }
                int pos = line.indexOf(separator);
                if (pos >= 0) {
                    sb.append(line.substring(0, pos));
                    list.add(sb.toString());
                    sb.setLength(0);
                    continue;
                }
                sb.append(line);
            }
        }
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        String separator;
        String cn = SQLUpdate.class.getName();
        if (args == null || args.length < 2) {
            System.out.println("Usage: java " + cn + " <poolname> <text file> [<separator>]");
            System.exit(0);
        }
        String db = args[0];
        String file = args[1];
        String string = separator = args.length < 3 ? null : args[2];
        if (separator != null) {
            System.out.println("Separator: " + separator);
        }
        String contents = null;
        try {
            contents = SQLUpdate.loadTextFile(new File(file));
        }
        catch (IOException iox) {
            System.out.println("I/O error with file " + file);
            iox.printStackTrace();
            System.exit(1);
        }
        String[] sql = SQLUpdate.splitSQL(contents, separator);
        SQLUpdate sqlUpdate = null;
        try {
            sqlUpdate = new SQLUpdate(db);
            sqlUpdate.openConnection(db);
            for (int i = 0; i < sql.length; ++i) {
                sqlUpdate.doStatement(sql[i]);
            }
            sqlUpdate.closeConnection();
        }
        catch (IOException iox) {
            System.err.println("Unable to create instance of " + cn);
            iox.printStackTrace();
            System.exit(1);
            sqlUpdate.closeConnection();
        }
        catch (SQLException sqlx) {
            sqlx.printStackTrace();
            sqlUpdate.closeConnection();
            {
                catch (Throwable throwable) {
                    super.closeConnection();
                    throw throwable;
                }
            }
        }
        System.out.println();
    }
}

