/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

public abstract class OneDReader
implements Reader {
    protected static final int INTEGER_MATH_SHIFT = 8;
    protected static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        block4: {
            block5: {
                try {
                    return this.doDecode(image, hints);
                }
                catch (NotFoundException nfe) {
                    v0 = tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER) != false;
                    if (!tryHarder || !image.isRotateSupported()) break block4;
                    rotatedImage = image.rotateCounterClockwise();
                    result = this.doDecode(rotatedImage, hints);
                    metadata = result.getResultMetadata();
                    orientation = 270;
                    if (metadata != null && metadata.containsKey((Object)ResultMetadataType.ORIENTATION)) {
                        orientation = (orientation + (Integer)metadata.get((Object)ResultMetadataType.ORIENTATION)) % 360;
                    }
                    result.putMetadata(ResultMetadataType.ORIENTATION, orientation);
                    points = result.getResultPoints();
                    if (points == null) break block5;
                    height = rotatedImage.getHeight();
                    i = 0;
                    ** while (i < points.length)
                }
lbl-1000:
                // 1 sources

                {
                    points[i] = new ResultPoint((float)height - points[i].getY() - 1.0f, points[i].getX());
                    ++i;
                    continue;
                }
            }
            return result;
        }
        throw nfe;
    }

    @Override
    public void reset() {
    }

    private Result doDecode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        int width = image.getWidth();
        int height = image.getHeight();
        BitArray row = new BitArray(width);
        int middle = height >> 1;
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        int rowStep = Math.max(1, height >> (tryHarder ? 8 : 5));
        int maxLines = tryHarder ? height : 15;
        int x = 0;
        while (x < maxLines) {
            block10: {
                int rowStepsAboveOrBelow = x + 1 >> 1;
                boolean isAbove = (x & 1) == 0;
                int rowNumber = middle + rowStep * (isAbove ? rowStepsAboveOrBelow : -rowStepsAboveOrBelow);
                if (rowNumber < 0 || rowNumber >= height) break;
                try {
                    row = image.getBlackRow(rowNumber, row);
                }
                catch (NotFoundException ignored) {
                    break block10;
                }
                int attempt = 0;
                while (attempt < 2) {
                    if (attempt == 1) {
                        row.reverse();
                        if (hints != null && hints.containsKey((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) {
                            EnumMap newHints = new EnumMap(DecodeHintType.class);
                            newHints.putAll(hints);
                            newHints.remove((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
                            hints = newHints;
                        }
                    }
                    try {
                        Result result = this.decodeRow(rowNumber, row, hints);
                        if (attempt == 1) {
                            result.putMetadata(ResultMetadataType.ORIENTATION, 180);
                            ResultPoint[] points = result.getResultPoints();
                            if (points != null) {
                                points[0] = new ResultPoint((float)width - points[0].getX() - 1.0f, points[0].getY());
                                points[1] = new ResultPoint((float)width - points[1].getX() - 1.0f, points[1].getY());
                            }
                        }
                        return result;
                    }
                    catch (ReaderException readerException) {
                        ++attempt;
                    }
                }
            }
            ++x;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static void recordPattern(BitArray row, int start, int[] counters) throws NotFoundException {
        int numCounters = counters.length;
        Arrays.fill(counters, 0, numCounters, 0);
        int end = row.getSize();
        if (start >= end) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean isWhite = !row.get(start);
        int counterPosition = 0;
        int i = start;
        while (i < end) {
            if (row.get(i) ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (++counterPosition == numCounters) break;
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++i;
        }
        if (counterPosition != numCounters && (counterPosition != numCounters - 1 || i != end)) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    protected static void recordPatternInReverse(BitArray row, int start, int[] counters) throws NotFoundException {
        int numTransitionsLeft = counters.length;
        boolean last = row.get(start);
        while (start > 0 && numTransitionsLeft >= 0) {
            if (row.get(--start) == last) continue;
            --numTransitionsLeft;
            boolean bl = last = !last;
        }
        if (numTransitionsLeft >= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        OneDReader.recordPattern(row, start + 1, counters);
    }

    protected static int patternMatchVariance(int[] counters, int[] pattern, int maxIndividualVariance) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        int i = 0;
        while (i < numCounters) {
            total += counters[i];
            patternLength += pattern[i];
            ++i;
        }
        if (total < patternLength) {
            return Integer.MAX_VALUE;
        }
        int unitBarWidth = (total << 8) / patternLength;
        maxIndividualVariance = maxIndividualVariance * unitBarWidth >> 8;
        int totalVariance = 0;
        int x = 0;
        while (x < numCounters) {
            int variance;
            int counter = counters[x] << 8;
            int scaledPattern = pattern[x] * unitBarWidth;
            int n = variance = counter > scaledPattern ? counter - scaledPattern : scaledPattern - counter;
            if (variance > maxIndividualVariance) {
                return Integer.MAX_VALUE;
            }
            totalVariance += variance;
            ++x;
        }
        return totalVariance / total;
    }

    public abstract Result decodeRow(int var1, BitArray var2, Map<DecodeHintType, ?> var3) throws NotFoundException, ChecksumException, FormatException;
}

