/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type[] actualTypeArguments;
    private final Type ownerType;
    private final Type rawType;
    private int hash;

    public ParameterizedTypeImpl(Type[] actualTypeArguments, Type ownerType, Type rawType) {
        if (actualTypeArguments == null || actualTypeArguments.length == 0 || rawType == null) {
            throw new IllegalArgumentException();
        }
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = ownerType;
        this.rawType = rawType;
        this.hash = 31 + (ownerType != null ? ownerType.hashCode() : 0);
        this.hash = 31 * this.hash + rawType.hashCode();
        this.hash = 31 * this.hash + Arrays.hashCode(actualTypeArguments);
    }

    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    public Type getOwnerType() {
        return this.ownerType;
    }

    public Type getRawType() {
        return this.rawType;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        if (!Arrays.equals(this.actualTypeArguments, other.getActualTypeArguments())) {
            return false;
        }
        if (this.ownerType == null ? other.getOwnerType() != null : !this.ownerType.equals(other.getOwnerType())) {
            return false;
        }
        return !(this.rawType == null ? other.getRawType() != null : !this.rawType.equals(other.getRawType()));
    }
}

